/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx_policy.infra.sites.enforcement_points.
 * Used by client-side stubs.
 */

package com.vmware.nsx_policy.infra.sites.enforcement_points;

public interface TransportNodeCollections extends com.vmware.vapi.bindings.Service, com.vmware.nsx_policy.infra.sites.enforcement_points.TransportNodeCollectionsTypes {

    /**
     * By deleting transport node collection, we are detaching the transport node
     * profile(TNP) from the compute collection. It has no effect on existing transport
     * nodes. However, new hosts added to the compute collection will no longer be
     * automatically converted to NSX transport node. Detaching TNP from compute
     * collection does not delete TNP.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param siteId (required)
     * @param enforcementpointId (required)
     * @param transportNodeCollectionId (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void delete(java.lang.String siteId, java.lang.String enforcementpointId, java.lang.String transportNodeCollectionId);

    /**
     * By deleting transport node collection, we are detaching the transport node
     * profile(TNP) from the compute collection. It has no effect on existing transport
     * nodes. However, new hosts added to the compute collection will no longer be
     * automatically converted to NSX transport node. Detaching TNP from compute
     * collection does not delete TNP.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param siteId (required)
     * @param enforcementpointId (required)
     * @param transportNodeCollectionId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void delete(java.lang.String siteId, java.lang.String enforcementpointId, java.lang.String transportNodeCollectionId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * By deleting transport node collection, we are detaching the transport node
     * profile(TNP) from the compute collection. It has no effect on existing transport
     * nodes. However, new hosts added to the compute collection will no longer be
     * automatically converted to NSX transport node. Detaching TNP from compute
     * collection does not delete TNP.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param siteId (required)
     * @param enforcementpointId (required)
     * @param transportNodeCollectionId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void delete(java.lang.String siteId, java.lang.String enforcementpointId, java.lang.String transportNodeCollectionId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * By deleting transport node collection, we are detaching the transport node
     * profile(TNP) from the compute collection. It has no effect on existing transport
     * nodes. However, new hosts added to the compute collection will no longer be
     * automatically converted to NSX transport node. Detaching TNP from compute
     * collection does not delete TNP.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param siteId (required)
     * @param enforcementpointId (required)
     * @param transportNodeCollectionId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void delete(java.lang.String siteId, java.lang.String enforcementpointId, java.lang.String transportNodeCollectionId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Returns transport node collection by id
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param siteId (required)
     * @param enforcementpointId (required)
     * @param transportNodeCollectionId (required)
     * @return com.vmware.nsx_policy.model.HostTransportNodeCollection
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.HostTransportNodeCollection get(java.lang.String siteId, java.lang.String enforcementpointId, java.lang.String transportNodeCollectionId);

    /**
     * Returns transport node collection by id
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param siteId (required)
     * @param enforcementpointId (required)
     * @param transportNodeCollectionId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.HostTransportNodeCollection
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.HostTransportNodeCollection get(java.lang.String siteId, java.lang.String enforcementpointId, java.lang.String transportNodeCollectionId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns transport node collection by id
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.HostTransportNodeCollection
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param siteId (required)
     * @param enforcementpointId (required)
     * @param transportNodeCollectionId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void get(java.lang.String siteId, java.lang.String enforcementpointId, java.lang.String transportNodeCollectionId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.HostTransportNodeCollection> asyncCallback);

    /**
     * Returns transport node collection by id
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.HostTransportNodeCollection
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param siteId (required)
     * @param enforcementpointId (required)
     * @param transportNodeCollectionId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void get(java.lang.String siteId, java.lang.String enforcementpointId, java.lang.String transportNodeCollectionId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.HostTransportNodeCollection> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * This API configures a compute collection for security. In the request body,
     * specify a Transport Node Collection with only the ID of the target compute
     * collection meant for security. Specifically, a Transport Node Profile ID should
     * not be specified. This API will define a system-generated security Transport
     * Node Profile and apply it on the compute collection to create the Transport Node
     * Collection.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param siteId (required)
     * @param enforcementpointId (required)
     * @param transportNodeCollectionId (required)
     * @param hostTransportNodeCollection (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void installformicroseg(java.lang.String siteId, java.lang.String enforcementpointId, java.lang.String transportNodeCollectionId, com.vmware.nsx_policy.model.HostTransportNodeCollection hostTransportNodeCollection);

    /**
     * This API configures a compute collection for security. In the request body,
     * specify a Transport Node Collection with only the ID of the target compute
     * collection meant for security. Specifically, a Transport Node Profile ID should
     * not be specified. This API will define a system-generated security Transport
     * Node Profile and apply it on the compute collection to create the Transport Node
     * Collection.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param siteId (required)
     * @param enforcementpointId (required)
     * @param transportNodeCollectionId (required)
     * @param hostTransportNodeCollection (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void installformicroseg(java.lang.String siteId, java.lang.String enforcementpointId, java.lang.String transportNodeCollectionId, com.vmware.nsx_policy.model.HostTransportNodeCollection hostTransportNodeCollection, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * This API configures a compute collection for security. In the request body,
     * specify a Transport Node Collection with only the ID of the target compute
     * collection meant for security. Specifically, a Transport Node Profile ID should
     * not be specified. This API will define a system-generated security Transport
     * Node Profile and apply it on the compute collection to create the Transport Node
     * Collection.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param siteId (required)
     * @param enforcementpointId (required)
     * @param transportNodeCollectionId (required)
     * @param hostTransportNodeCollection (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void installformicroseg(java.lang.String siteId, java.lang.String enforcementpointId, java.lang.String transportNodeCollectionId, com.vmware.nsx_policy.model.HostTransportNodeCollection hostTransportNodeCollection, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * This API configures a compute collection for security. In the request body,
     * specify a Transport Node Collection with only the ID of the target compute
     * collection meant for security. Specifically, a Transport Node Profile ID should
     * not be specified. This API will define a system-generated security Transport
     * Node Profile and apply it on the compute collection to create the Transport Node
     * Collection.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param siteId (required)
     * @param enforcementpointId (required)
     * @param transportNodeCollectionId (required)
     * @param hostTransportNodeCollection (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void installformicroseg(java.lang.String siteId, java.lang.String enforcementpointId, java.lang.String transportNodeCollectionId, com.vmware.nsx_policy.model.HostTransportNodeCollection hostTransportNodeCollection, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Returns all Transport Node collections
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param siteId (required)
     * @param enforcementpointId (required)
     * @param clusterMoid Managed object ID of cluster in VC (optional)
     * @param computeCollectionId Compute collection id (optional)
     * @param vcInstanceUuid UUID for VC deployment (optional)
     * @return com.vmware.nsx_policy.model.HostTransportNodeCollectionListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.HostTransportNodeCollectionListResult list(java.lang.String siteId, java.lang.String enforcementpointId, java.lang.String clusterMoid, java.lang.String computeCollectionId, java.lang.String vcInstanceUuid);

    /**
     * Returns all Transport Node collections
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param siteId (required)
     * @param enforcementpointId (required)
     * @param clusterMoid Managed object ID of cluster in VC (optional)
     * @param computeCollectionId Compute collection id (optional)
     * @param vcInstanceUuid UUID for VC deployment (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.HostTransportNodeCollectionListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.HostTransportNodeCollectionListResult list(java.lang.String siteId, java.lang.String enforcementpointId, java.lang.String clusterMoid, java.lang.String computeCollectionId, java.lang.String vcInstanceUuid, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns all Transport Node collections
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.HostTransportNodeCollectionListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param siteId (required)
     * @param enforcementpointId (required)
     * @param clusterMoid Managed object ID of cluster in VC (optional)
     * @param computeCollectionId Compute collection id (optional)
     * @param vcInstanceUuid UUID for VC deployment (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void list(java.lang.String siteId, java.lang.String enforcementpointId, java.lang.String clusterMoid, java.lang.String computeCollectionId, java.lang.String vcInstanceUuid, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.HostTransportNodeCollectionListResult> asyncCallback);

    /**
     * Returns all Transport Node collections
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.HostTransportNodeCollectionListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param siteId (required)
     * @param enforcementpointId (required)
     * @param clusterMoid Managed object ID of cluster in VC (optional)
     * @param computeCollectionId Compute collection id (optional)
     * @param vcInstanceUuid UUID for VC deployment (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void list(java.lang.String siteId, java.lang.String enforcementpointId, java.lang.String clusterMoid, java.lang.String computeCollectionId, java.lang.String vcInstanceUuid, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.HostTransportNodeCollectionListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Attach different transport node profile to compute collection by updating
     * transport node collection.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param siteId (required)
     * @param enforcementpointId (required)
     * @param transportNodeCollectionId (required)
     * @param hostTransportNodeCollection (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void patch(java.lang.String siteId, java.lang.String enforcementpointId, java.lang.String transportNodeCollectionId, com.vmware.nsx_policy.model.HostTransportNodeCollection hostTransportNodeCollection);

    /**
     * Attach different transport node profile to compute collection by updating
     * transport node collection.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param siteId (required)
     * @param enforcementpointId (required)
     * @param transportNodeCollectionId (required)
     * @param hostTransportNodeCollection (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void patch(java.lang.String siteId, java.lang.String enforcementpointId, java.lang.String transportNodeCollectionId, com.vmware.nsx_policy.model.HostTransportNodeCollection hostTransportNodeCollection, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Attach different transport node profile to compute collection by updating
     * transport node collection.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param siteId (required)
     * @param enforcementpointId (required)
     * @param transportNodeCollectionId (required)
     * @param hostTransportNodeCollection (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void patch(java.lang.String siteId, java.lang.String enforcementpointId, java.lang.String transportNodeCollectionId, com.vmware.nsx_policy.model.HostTransportNodeCollection hostTransportNodeCollection, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Attach different transport node profile to compute collection by updating
     * transport node collection.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param siteId (required)
     * @param enforcementpointId (required)
     * @param transportNodeCollectionId (required)
     * @param hostTransportNodeCollection (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void patch(java.lang.String siteId, java.lang.String enforcementpointId, java.lang.String transportNodeCollectionId, com.vmware.nsx_policy.model.HostTransportNodeCollection hostTransportNodeCollection, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * This API uninstalls NSX applied to the Transport Node Collection with the ID
     * corresponding to the one specified in the request.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param siteId (required)
     * @param enforcementpointId (required)
     * @param transportNodeCollectionId (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void removensx(java.lang.String siteId, java.lang.String enforcementpointId, java.lang.String transportNodeCollectionId);

    /**
     * This API uninstalls NSX applied to the Transport Node Collection with the ID
     * corresponding to the one specified in the request.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param siteId (required)
     * @param enforcementpointId (required)
     * @param transportNodeCollectionId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void removensx(java.lang.String siteId, java.lang.String enforcementpointId, java.lang.String transportNodeCollectionId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * This API uninstalls NSX applied to the Transport Node Collection with the ID
     * corresponding to the one specified in the request.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param siteId (required)
     * @param enforcementpointId (required)
     * @param transportNodeCollectionId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void removensx(java.lang.String siteId, java.lang.String enforcementpointId, java.lang.String transportNodeCollectionId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * This API uninstalls NSX applied to the Transport Node Collection with the ID
     * corresponding to the one specified in the request.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param siteId (required)
     * @param enforcementpointId (required)
     * @param transportNodeCollectionId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void removensx(java.lang.String siteId, java.lang.String enforcementpointId, java.lang.String transportNodeCollectionId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * This API is relevant for compute collection on which vLCM is enabled. This API
     * should be invoked to retry the realization of transport node profile on the
     * compute collection. This is useful when profile realization had failed because
     * of error in vLCM. This API has no effect if vLCM is not enabled on the computer
     * collection.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param siteId (required)
     * @param enforcementpointId (required)
     * @param transportNodeCollectionId (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void retryprofilerealization(java.lang.String siteId, java.lang.String enforcementpointId, java.lang.String transportNodeCollectionId);

    /**
     * This API is relevant for compute collection on which vLCM is enabled. This API
     * should be invoked to retry the realization of transport node profile on the
     * compute collection. This is useful when profile realization had failed because
     * of error in vLCM. This API has no effect if vLCM is not enabled on the computer
     * collection.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param siteId (required)
     * @param enforcementpointId (required)
     * @param transportNodeCollectionId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void retryprofilerealization(java.lang.String siteId, java.lang.String enforcementpointId, java.lang.String transportNodeCollectionId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * This API is relevant for compute collection on which vLCM is enabled. This API
     * should be invoked to retry the realization of transport node profile on the
     * compute collection. This is useful when profile realization had failed because
     * of error in vLCM. This API has no effect if vLCM is not enabled on the computer
     * collection.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param siteId (required)
     * @param enforcementpointId (required)
     * @param transportNodeCollectionId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void retryprofilerealization(java.lang.String siteId, java.lang.String enforcementpointId, java.lang.String transportNodeCollectionId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * This API is relevant for compute collection on which vLCM is enabled. This API
     * should be invoked to retry the realization of transport node profile on the
     * compute collection. This is useful when profile realization had failed because
     * of error in vLCM. This API has no effect if vLCM is not enabled on the computer
     * collection.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param siteId (required)
     * @param enforcementpointId (required)
     * @param transportNodeCollectionId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void retryprofilerealization(java.lang.String siteId, java.lang.String enforcementpointId, java.lang.String transportNodeCollectionId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * When transport node collection is created the hosts which are part of compute
     * collection will be prepared automatically i.e. NSX Manager attempts to install
     * the NSX components on hosts. Transport nodes for these hosts are created using
     * the configuration specified in transport node profile. Pass apply_profile to
     * false, if you do not want to apply transport node profile on the existing
     * transport node with overridden host flag set and ignore overridden hosts flag is
     * set to true on the transport node profile.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param siteId (required)
     * @param enforcementpointId (required)
     * @param transportNodeCollectionsId (required)
     * @param hostTransportNodeCollection (required)
     * @param applyProfile Indicates if the Transport Node Profile (TNP) configuration should be applied
     * during creation (optional, default to true)
     * @param overrideNsxOwnership Override NSX Ownership (optional, default to false)
     * @return com.vmware.nsx_policy.model.HostTransportNodeCollection
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.HostTransportNodeCollection update(java.lang.String siteId, java.lang.String enforcementpointId, java.lang.String transportNodeCollectionsId, com.vmware.nsx_policy.model.HostTransportNodeCollection hostTransportNodeCollection, java.lang.Boolean applyProfile, java.lang.Boolean overrideNsxOwnership);

    /**
     * When transport node collection is created the hosts which are part of compute
     * collection will be prepared automatically i.e. NSX Manager attempts to install
     * the NSX components on hosts. Transport nodes for these hosts are created using
     * the configuration specified in transport node profile. Pass apply_profile to
     * false, if you do not want to apply transport node profile on the existing
     * transport node with overridden host flag set and ignore overridden hosts flag is
     * set to true on the transport node profile.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param siteId (required)
     * @param enforcementpointId (required)
     * @param transportNodeCollectionsId (required)
     * @param hostTransportNodeCollection (required)
     * @param applyProfile Indicates if the Transport Node Profile (TNP) configuration should be applied
     * during creation (optional, default to true)
     * @param overrideNsxOwnership Override NSX Ownership (optional, default to false)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.HostTransportNodeCollection
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.HostTransportNodeCollection update(java.lang.String siteId, java.lang.String enforcementpointId, java.lang.String transportNodeCollectionsId, com.vmware.nsx_policy.model.HostTransportNodeCollection hostTransportNodeCollection, java.lang.Boolean applyProfile, java.lang.Boolean overrideNsxOwnership, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * When transport node collection is created the hosts which are part of compute
     * collection will be prepared automatically i.e. NSX Manager attempts to install
     * the NSX components on hosts. Transport nodes for these hosts are created using
     * the configuration specified in transport node profile. Pass apply_profile to
     * false, if you do not want to apply transport node profile on the existing
     * transport node with overridden host flag set and ignore overridden hosts flag is
     * set to true on the transport node profile.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.HostTransportNodeCollection
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param siteId (required)
     * @param enforcementpointId (required)
     * @param transportNodeCollectionsId (required)
     * @param hostTransportNodeCollection (required)
     * @param applyProfile Indicates if the Transport Node Profile (TNP) configuration should be applied
     * during creation (optional, default to true)
     * @param overrideNsxOwnership Override NSX Ownership (optional, default to false)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void update(java.lang.String siteId, java.lang.String enforcementpointId, java.lang.String transportNodeCollectionsId, com.vmware.nsx_policy.model.HostTransportNodeCollection hostTransportNodeCollection, java.lang.Boolean applyProfile, java.lang.Boolean overrideNsxOwnership, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.HostTransportNodeCollection> asyncCallback);

    /**
     * When transport node collection is created the hosts which are part of compute
     * collection will be prepared automatically i.e. NSX Manager attempts to install
     * the NSX components on hosts. Transport nodes for these hosts are created using
     * the configuration specified in transport node profile. Pass apply_profile to
     * false, if you do not want to apply transport node profile on the existing
     * transport node with overridden host flag set and ignore overridden hosts flag is
     * set to true on the transport node profile.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.HostTransportNodeCollection
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param siteId (required)
     * @param enforcementpointId (required)
     * @param transportNodeCollectionsId (required)
     * @param hostTransportNodeCollection (required)
     * @param applyProfile Indicates if the Transport Node Profile (TNP) configuration should be applied
     * during creation (optional, default to true)
     * @param overrideNsxOwnership Override NSX Ownership (optional, default to false)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void update(java.lang.String siteId, java.lang.String enforcementpointId, java.lang.String transportNodeCollectionsId, com.vmware.nsx_policy.model.HostTransportNodeCollection hostTransportNodeCollection, java.lang.Boolean applyProfile, java.lang.Boolean overrideNsxOwnership, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.HostTransportNodeCollection> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
