/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx_policy.infra.sites.enforcement_points.edge_clusters.
 * Used by client-side stubs.
 */

package com.vmware.nsx_policy.infra.sites.enforcement_points.edge_clusters;

public interface FqdnAnalysisConfig extends com.vmware.vapi.bindings.Service, com.vmware.nsx_policy.infra.sites.enforcement_points.edge_clusters.FqdnAnalysisConfigTypes {

    /**
     * Delete FqdnAnalysisConfig from the passed edge cluser node.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param siteId (required)
     * @param enforcementPointId (required)
     * @param edgeClusterId (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void delete(java.lang.String siteId, java.lang.String enforcementPointId, java.lang.String edgeClusterId);

    /**
     * Delete FqdnAnalysisConfig from the passed edge cluser node.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param siteId (required)
     * @param enforcementPointId (required)
     * @param edgeClusterId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void delete(java.lang.String siteId, java.lang.String enforcementPointId, java.lang.String edgeClusterId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Delete FqdnAnalysisConfig from the passed edge cluser node.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param siteId (required)
     * @param enforcementPointId (required)
     * @param edgeClusterId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void delete(java.lang.String siteId, java.lang.String enforcementPointId, java.lang.String edgeClusterId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Delete FqdnAnalysisConfig from the passed edge cluser node.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param siteId (required)
     * @param enforcementPointId (required)
     * @param edgeClusterId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void delete(java.lang.String siteId, java.lang.String enforcementPointId, java.lang.String edgeClusterId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Gets a FqdnAnalysisConfig. This returns the details of the config like whether
     * the FQDN Analysis is activated or deactivated for the given edge cluster.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param siteId (required)
     * @param enforcementPointId (required)
     * @param edgeClusterId (required)
     * @return com.vmware.nsx_policy.model.FqdnAnalysisConfig
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.FqdnAnalysisConfig get(java.lang.String siteId, java.lang.String enforcementPointId, java.lang.String edgeClusterId);

    /**
     * Gets a FqdnAnalysisConfig. This returns the details of the config like whether
     * the FQDN Analysis is activated or deactivated for the given edge cluster.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param siteId (required)
     * @param enforcementPointId (required)
     * @param edgeClusterId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.FqdnAnalysisConfig
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.FqdnAnalysisConfig get(java.lang.String siteId, java.lang.String enforcementPointId, java.lang.String edgeClusterId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Gets a FqdnAnalysisConfig. This returns the details of the config like whether
     * the FQDN Analysis is activated or deactivated for the given edge cluster.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.FqdnAnalysisConfig
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param siteId (required)
     * @param enforcementPointId (required)
     * @param edgeClusterId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void get(java.lang.String siteId, java.lang.String enforcementPointId, java.lang.String edgeClusterId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.FqdnAnalysisConfig> asyncCallback);

    /**
     * Gets a FqdnAnalysisConfig. This returns the details of the config like whether
     * the FQDN Analysis is activated or deactivated for the given edge cluster.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.FqdnAnalysisConfig
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param siteId (required)
     * @param enforcementPointId (required)
     * @param edgeClusterId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void get(java.lang.String siteId, java.lang.String enforcementPointId, java.lang.String edgeClusterId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.FqdnAnalysisConfig> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Creates/Updates a FqdnAnalysisConfig object. If FqdnAnalysisConfig object does
     * not exists for the passed edge-cluster node, create a new FqdnAnalysisConfig
     * object. If it already exists, patch it.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param siteId (required)
     * @param enforcementPointId (required)
     * @param edgeClusterId (required)
     * @param fqdnAnalysisConfig (required)
     * @return com.vmware.nsx_policy.model.FqdnAnalysisConfig
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.FqdnAnalysisConfig patch(java.lang.String siteId, java.lang.String enforcementPointId, java.lang.String edgeClusterId, com.vmware.nsx_policy.model.FqdnAnalysisConfig fqdnAnalysisConfig);

    /**
     * Creates/Updates a FqdnAnalysisConfig object. If FqdnAnalysisConfig object does
     * not exists for the passed edge-cluster node, create a new FqdnAnalysisConfig
     * object. If it already exists, patch it.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param siteId (required)
     * @param enforcementPointId (required)
     * @param edgeClusterId (required)
     * @param fqdnAnalysisConfig (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.FqdnAnalysisConfig
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.FqdnAnalysisConfig patch(java.lang.String siteId, java.lang.String enforcementPointId, java.lang.String edgeClusterId, com.vmware.nsx_policy.model.FqdnAnalysisConfig fqdnAnalysisConfig, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Creates/Updates a FqdnAnalysisConfig object. If FqdnAnalysisConfig object does
     * not exists for the passed edge-cluster node, create a new FqdnAnalysisConfig
     * object. If it already exists, patch it.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.FqdnAnalysisConfig
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param siteId (required)
     * @param enforcementPointId (required)
     * @param edgeClusterId (required)
     * @param fqdnAnalysisConfig (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void patch(java.lang.String siteId, java.lang.String enforcementPointId, java.lang.String edgeClusterId, com.vmware.nsx_policy.model.FqdnAnalysisConfig fqdnAnalysisConfig, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.FqdnAnalysisConfig> asyncCallback);

    /**
     * Creates/Updates a FqdnAnalysisConfig object. If FqdnAnalysisConfig object does
     * not exists for the passed edge-cluster node, create a new FqdnAnalysisConfig
     * object. If it already exists, patch it.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.FqdnAnalysisConfig
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param siteId (required)
     * @param enforcementPointId (required)
     * @param edgeClusterId (required)
     * @param fqdnAnalysisConfig (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void patch(java.lang.String siteId, java.lang.String enforcementPointId, java.lang.String edgeClusterId, com.vmware.nsx_policy.model.FqdnAnalysisConfig fqdnAnalysisConfig, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.FqdnAnalysisConfig> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Creates/Updates FqdnAnalysisConfig Object for the given edge cluster. If
     * FqdnAnalysisConfig object is not already present, creates it. If it already
     * exists, replace with this object.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param siteId (required)
     * @param enforcementPointId (required)
     * @param edgeClusterId (required)
     * @param fqdnAnalysisConfig (required)
     * @return com.vmware.nsx_policy.model.FqdnAnalysisConfig
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.FqdnAnalysisConfig update(java.lang.String siteId, java.lang.String enforcementPointId, java.lang.String edgeClusterId, com.vmware.nsx_policy.model.FqdnAnalysisConfig fqdnAnalysisConfig);

    /**
     * Creates/Updates FqdnAnalysisConfig Object for the given edge cluster. If
     * FqdnAnalysisConfig object is not already present, creates it. If it already
     * exists, replace with this object.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param siteId (required)
     * @param enforcementPointId (required)
     * @param edgeClusterId (required)
     * @param fqdnAnalysisConfig (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.FqdnAnalysisConfig
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.FqdnAnalysisConfig update(java.lang.String siteId, java.lang.String enforcementPointId, java.lang.String edgeClusterId, com.vmware.nsx_policy.model.FqdnAnalysisConfig fqdnAnalysisConfig, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Creates/Updates FqdnAnalysisConfig Object for the given edge cluster. If
     * FqdnAnalysisConfig object is not already present, creates it. If it already
     * exists, replace with this object.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.FqdnAnalysisConfig
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param siteId (required)
     * @param enforcementPointId (required)
     * @param edgeClusterId (required)
     * @param fqdnAnalysisConfig (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void update(java.lang.String siteId, java.lang.String enforcementPointId, java.lang.String edgeClusterId, com.vmware.nsx_policy.model.FqdnAnalysisConfig fqdnAnalysisConfig, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.FqdnAnalysisConfig> asyncCallback);

    /**
     * Creates/Updates FqdnAnalysisConfig Object for the given edge cluster. If
     * FqdnAnalysisConfig object is not already present, creates it. If it already
     * exists, replace with this object.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.FqdnAnalysisConfig
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param siteId (required)
     * @param enforcementPointId (required)
     * @param edgeClusterId (required)
     * @param fqdnAnalysisConfig (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void update(java.lang.String siteId, java.lang.String enforcementPointId, java.lang.String edgeClusterId, com.vmware.nsx_policy.model.FqdnAnalysisConfig fqdnAnalysisConfig, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.FqdnAnalysisConfig> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
