/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx_policy.infra.tier_1s.segments.
 * Used by client-side stubs.
 */

package com.vmware.nsx_policy.infra.tier_1s.segments;

public interface SegmentQosProfileBindingMaps extends com.vmware.vapi.bindings.Service, com.vmware.nsx_policy.infra.tier_1s.segments.SegmentQosProfileBindingMapsTypes {

    /**
     * API will delete Segment QoS Profile Binding Profile.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param tier1Id Tier-1 ID (required)
     * @param segmentId Segment ID (required)
     * @param segmentQosProfileBindingMapId Segment QoS Profile Binding Map ID (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void delete(java.lang.String tier1Id, java.lang.String segmentId, java.lang.String segmentQosProfileBindingMapId);

    /**
     * API will delete Segment QoS Profile Binding Profile.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param tier1Id Tier-1 ID (required)
     * @param segmentId Segment ID (required)
     * @param segmentQosProfileBindingMapId Segment QoS Profile Binding Map ID (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void delete(java.lang.String tier1Id, java.lang.String segmentId, java.lang.String segmentQosProfileBindingMapId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * API will delete Segment QoS Profile Binding Profile.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param tier1Id Tier-1 ID (required)
     * @param segmentId Segment ID (required)
     * @param segmentQosProfileBindingMapId Segment QoS Profile Binding Map ID (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void delete(java.lang.String tier1Id, java.lang.String segmentId, java.lang.String segmentQosProfileBindingMapId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * API will delete Segment QoS Profile Binding Profile.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param tier1Id Tier-1 ID (required)
     * @param segmentId Segment ID (required)
     * @param segmentQosProfileBindingMapId Segment QoS Profile Binding Map ID (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void delete(java.lang.String tier1Id, java.lang.String segmentId, java.lang.String segmentQosProfileBindingMapId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * API will get Segment QoS Profile Binding Map.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param tier1Id Tier-1 ID (required)
     * @param segmentId Segment ID (required)
     * @param segmentQosProfileBindingMapId Segment QoS Profile Binding Map ID (required)
     * @return com.vmware.nsx_policy.model.SegmentQoSProfileBindingMap
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.SegmentQosProfileBindingMap get(java.lang.String tier1Id, java.lang.String segmentId, java.lang.String segmentQosProfileBindingMapId);

    /**
     * API will get Segment QoS Profile Binding Map.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param tier1Id Tier-1 ID (required)
     * @param segmentId Segment ID (required)
     * @param segmentQosProfileBindingMapId Segment QoS Profile Binding Map ID (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.SegmentQoSProfileBindingMap
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.SegmentQosProfileBindingMap get(java.lang.String tier1Id, java.lang.String segmentId, java.lang.String segmentQosProfileBindingMapId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * API will get Segment QoS Profile Binding Map.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.SegmentQoSProfileBindingMap
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param tier1Id Tier-1 ID (required)
     * @param segmentId Segment ID (required)
     * @param segmentQosProfileBindingMapId Segment QoS Profile Binding Map ID (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void get(java.lang.String tier1Id, java.lang.String segmentId, java.lang.String segmentQosProfileBindingMapId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.SegmentQosProfileBindingMap> asyncCallback);

    /**
     * API will get Segment QoS Profile Binding Map.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.SegmentQoSProfileBindingMap
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param tier1Id Tier-1 ID (required)
     * @param segmentId Segment ID (required)
     * @param segmentQosProfileBindingMapId Segment QoS Profile Binding Map ID (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void get(java.lang.String tier1Id, java.lang.String segmentId, java.lang.String segmentQosProfileBindingMapId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.SegmentQosProfileBindingMap> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * API will list all Segment QoS Profile Binding Maps in current segment id.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param tier1Id (required)
     * @param segmentId (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @return com.vmware.nsx_policy.model.SegmentQoSProfileBindingMapListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.SegmentQosProfileBindingMapListResult list(java.lang.String tier1Id, java.lang.String segmentId, java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy);

    /**
     * API will list all Segment QoS Profile Binding Maps in current segment id.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param tier1Id (required)
     * @param segmentId (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.SegmentQoSProfileBindingMapListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.SegmentQosProfileBindingMapListResult list(java.lang.String tier1Id, java.lang.String segmentId, java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * API will list all Segment QoS Profile Binding Maps in current segment id.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.SegmentQoSProfileBindingMapListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param tier1Id (required)
     * @param segmentId (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void list(java.lang.String tier1Id, java.lang.String segmentId, java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.SegmentQosProfileBindingMapListResult> asyncCallback);

    /**
     * API will list all Segment QoS Profile Binding Maps in current segment id.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.SegmentQoSProfileBindingMapListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param tier1Id (required)
     * @param segmentId (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void list(java.lang.String tier1Id, java.lang.String segmentId, java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.SegmentQosProfileBindingMapListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * API will create segment QoS profile binding map. For objects with no binding
     * maps, default profile is applied.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param tier1Id Tier-1 ID (required)
     * @param segmentId Segment ID (required)
     * @param segmentQosProfileBindingMapId Segment QoS Profile Binding Map ID (required)
     * @param segmentQosProfileBindingMap (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void patch(java.lang.String tier1Id, java.lang.String segmentId, java.lang.String segmentQosProfileBindingMapId, com.vmware.nsx_policy.model.SegmentQosProfileBindingMap segmentQosProfileBindingMap);

    /**
     * API will create segment QoS profile binding map. For objects with no binding
     * maps, default profile is applied.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param tier1Id Tier-1 ID (required)
     * @param segmentId Segment ID (required)
     * @param segmentQosProfileBindingMapId Segment QoS Profile Binding Map ID (required)
     * @param segmentQosProfileBindingMap (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void patch(java.lang.String tier1Id, java.lang.String segmentId, java.lang.String segmentQosProfileBindingMapId, com.vmware.nsx_policy.model.SegmentQosProfileBindingMap segmentQosProfileBindingMap, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * API will create segment QoS profile binding map. For objects with no binding
     * maps, default profile is applied.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param tier1Id Tier-1 ID (required)
     * @param segmentId Segment ID (required)
     * @param segmentQosProfileBindingMapId Segment QoS Profile Binding Map ID (required)
     * @param segmentQosProfileBindingMap (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void patch(java.lang.String tier1Id, java.lang.String segmentId, java.lang.String segmentQosProfileBindingMapId, com.vmware.nsx_policy.model.SegmentQosProfileBindingMap segmentQosProfileBindingMap, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * API will create segment QoS profile binding map. For objects with no binding
     * maps, default profile is applied.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param tier1Id Tier-1 ID (required)
     * @param segmentId Segment ID (required)
     * @param segmentQosProfileBindingMapId Segment QoS Profile Binding Map ID (required)
     * @param segmentQosProfileBindingMap (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void patch(java.lang.String tier1Id, java.lang.String segmentId, java.lang.String segmentQosProfileBindingMapId, com.vmware.nsx_policy.model.SegmentQosProfileBindingMap segmentQosProfileBindingMap, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * API will update Segment QoS Profile Binding Map. For objects with no binding
     * maps, default profile is applied.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param tier1Id Tier-1 ID (required)
     * @param segmentId Segment ID (required)
     * @param segmentQosProfileBindingMapId Segment QoS Profile Binding Map ID (required)
     * @param segmentQosProfileBindingMap (required)
     * @return com.vmware.nsx_policy.model.SegmentQoSProfileBindingMap
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.SegmentQosProfileBindingMap update(java.lang.String tier1Id, java.lang.String segmentId, java.lang.String segmentQosProfileBindingMapId, com.vmware.nsx_policy.model.SegmentQosProfileBindingMap segmentQosProfileBindingMap);

    /**
     * API will update Segment QoS Profile Binding Map. For objects with no binding
     * maps, default profile is applied.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param tier1Id Tier-1 ID (required)
     * @param segmentId Segment ID (required)
     * @param segmentQosProfileBindingMapId Segment QoS Profile Binding Map ID (required)
     * @param segmentQosProfileBindingMap (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.SegmentQoSProfileBindingMap
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.SegmentQosProfileBindingMap update(java.lang.String tier1Id, java.lang.String segmentId, java.lang.String segmentQosProfileBindingMapId, com.vmware.nsx_policy.model.SegmentQosProfileBindingMap segmentQosProfileBindingMap, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * API will update Segment QoS Profile Binding Map. For objects with no binding
     * maps, default profile is applied.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.SegmentQoSProfileBindingMap
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param tier1Id Tier-1 ID (required)
     * @param segmentId Segment ID (required)
     * @param segmentQosProfileBindingMapId Segment QoS Profile Binding Map ID (required)
     * @param segmentQosProfileBindingMap (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void update(java.lang.String tier1Id, java.lang.String segmentId, java.lang.String segmentQosProfileBindingMapId, com.vmware.nsx_policy.model.SegmentQosProfileBindingMap segmentQosProfileBindingMap, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.SegmentQosProfileBindingMap> asyncCallback);

    /**
     * API will update Segment QoS Profile Binding Map. For objects with no binding
     * maps, default profile is applied.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.SegmentQoSProfileBindingMap
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param tier1Id Tier-1 ID (required)
     * @param segmentId Segment ID (required)
     * @param segmentQosProfileBindingMapId Segment QoS Profile Binding Map ID (required)
     * @param segmentQosProfileBindingMap (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void update(java.lang.String tier1Id, java.lang.String segmentId, java.lang.String segmentQosProfileBindingMapId, com.vmware.nsx_policy.model.SegmentQosProfileBindingMap segmentQosProfileBindingMap, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.SegmentQosProfileBindingMap> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
