/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * The vSphere deployment configuration determines where to deploy the Advanced
 * Load Balancer controller node VM through a vCenter server. It contains settings
 * that are applied during install time. If using DHCP, the following fields must
 * be left unset - management_port_subnets, and default_gateway_addresses
 */
public final class AlbControllerVsphereClusterNodeVmDeploymentConfig implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    /**
     * Identifier denoting this class, when it is used in polymorphic context. 
     * <p>This
     * value should be assigned to the property which is used to discriminate the
     * actual type used in the polymorphic context.</p>
     */
    public static final java.lang.String _TYPE_IDENTIFIER = "AlbControllerVsphereClusterNodeVmDeploymentConfig";

    public static final java.lang.String DISK_PROVISIONING_THIN = "THIN";

    public static final java.lang.String DISK_PROVISIONING_LAZY_ZEROED_THICK = "LAZY_ZEROED_THICK";

    public static final java.lang.String DISK_PROVISIONING_EAGER_ZEROED_THICK = "EAGER_ZEROED_THICK";

    private java.lang.String computeId;

    private java.util.List<java.lang.String> defaultGatewayAddresses;

    private java.lang.String diskProvisioning;

    private java.lang.String displayName;

    private java.util.List<java.lang.String> dnsServers;

    private java.lang.String hostId;

    private java.lang.String hostname;

    private java.lang.String managementNetworkId;

    private java.util.List<com.vmware.nsx_policy.model.IPSubnet> managementPortSubnets;

    private java.util.List<java.lang.String> ntpServers;

    private java.lang.String storageId;

    private java.lang.String storagePolicyId;

    private java.lang.String vcId;

    private final java.lang.String placementType = "AlbControllerVsphereClusterNodeVmDeploymentConfig";

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public AlbControllerVsphereClusterNodeVmDeploymentConfig() {
    }

    protected AlbControllerVsphereClusterNodeVmDeploymentConfig(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * The Advanced Load Balancer controller node VM will be deployed on the specified
     * cluster or resourcepool for specified VC server.
     *
     * @return The current value of the property.
     */
    public java.lang.String getComputeId() {
        return this.computeId;
    }

    /**
     * The Advanced Load Balancer controller node VM will be deployed on the specified
     * cluster or resourcepool for specified VC server.
     *
     * @param computeId New value for the property.
     */
    public void setComputeId(java.lang.String computeId) {
        this.computeId = computeId;
    }

    /**
     * The default gateway for the VM to be deployed must be specified if all the other
     * VMs it communicates with are not in the same subnet. Do not specify this field
     * and management_port_subnets to use DHCP. Note: only single IPv4 default gateway
     * address is supported and it must belong to management network. format: ip
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getDefaultGatewayAddresses() {
        return this.defaultGatewayAddresses;
    }

    /**
     * The default gateway for the VM to be deployed must be specified if all the other
     * VMs it communicates with are not in the same subnet. Do not specify this field
     * and management_port_subnets to use DHCP. Note: only single IPv4 default gateway
     * address is supported and it must belong to management network. format: ip
     *
     * @param defaultGatewayAddresses New value for the property.
     */
    public void setDefaultGatewayAddresses(java.util.List<java.lang.String> defaultGatewayAddresses) {
        this.defaultGatewayAddresses = defaultGatewayAddresses;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.AlbControllerVsphereClusterNodeVmDeploymentConfig#DISK_PROVISIONING_THIN}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.AlbControllerVsphereClusterNodeVmDeploymentConfig#DISK_PROVISIONING_LAZY_ZEROED_THICK}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.AlbControllerVsphereClusterNodeVmDeploymentConfig#DISK_PROVISIONING_EAGER_ZEROED_THICK}</li>
     * </ul> Specifies the disk provisioning type of the VM.
     *
     * @return The current value of the property.
     */
    public java.lang.String getDiskProvisioning() {
        return this.diskProvisioning;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.AlbControllerVsphereClusterNodeVmDeploymentConfig#DISK_PROVISIONING_THIN}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.AlbControllerVsphereClusterNodeVmDeploymentConfig#DISK_PROVISIONING_LAZY_ZEROED_THICK}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.AlbControllerVsphereClusterNodeVmDeploymentConfig#DISK_PROVISIONING_EAGER_ZEROED_THICK}</li>
     * </ul> Specifies the disk provisioning type of the VM.
     *
     * @param diskProvisioning New value for the property.
     */
    public void setDiskProvisioning(java.lang.String diskProvisioning) {
        this.diskProvisioning = diskProvisioning;
    }

    /**
     * Desired display name for Advanced Load Balancer controller VM to be deployed.
     *
     * @return The current value of the property.
     */
    public java.lang.String getDisplayName() {
        return this.displayName;
    }

    /**
     * Desired display name for Advanced Load Balancer controller VM to be deployed.
     *
     * @param displayName New value for the property.
     */
    public void setDisplayName(java.lang.String displayName) {
        this.displayName = displayName;
    }

    /**
     * List of DNS servers. format: ipv4
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getDnsServers() {
        return this.dnsServers;
    }

    /**
     * List of DNS servers. format: ipv4
     *
     * @param dnsServers New value for the property.
     */
    public void setDnsServers(java.util.List<java.lang.String> dnsServers) {
        this.dnsServers = dnsServers;
    }

    /**
     * The Advanced Load Balancer controller node VM will be deployed on the specified
     * host in the specified VC server within the cluster if host_id is specified.
     * Note: User must ensure that storage and specified networks are accessible by
     * this host.
     *
     * @return The current value of the property.
     */
    public java.lang.String getHostId() {
        return this.hostId;
    }

    /**
     * The Advanced Load Balancer controller node VM will be deployed on the specified
     * host in the specified VC server within the cluster if host_id is specified.
     * Note: User must ensure that storage and specified networks are accessible by
     * this host.
     *
     * @param hostId New value for the property.
     */
    public void setHostId(java.lang.String hostId) {
        this.hostId = hostId;
    }

    /**
     * Desired host name/FQDN for the VM to be deployed. format: hostname-or-ip
     *
     * @return The current value of the property.
     */
    public java.lang.String getHostname() {
        return this.hostname;
    }

    /**
     * Desired host name/FQDN for the VM to be deployed. format: hostname-or-ip
     *
     * @param hostname New value for the property.
     */
    public void setHostname(java.lang.String hostname) {
        this.hostname = hostname;
    }

    /**
     * Distributed portgroup identifier to which the management vnic of Advanced Load
     * Balancer controller node VM will be connected.
     *
     * @return The current value of the property.
     */
    public java.lang.String getManagementNetworkId() {
        return this.managementNetworkId;
    }

    /**
     * Distributed portgroup identifier to which the management vnic of Advanced Load
     * Balancer controller node VM will be connected.
     *
     * @param managementNetworkId New value for the property.
     */
    public void setManagementNetworkId(java.lang.String managementNetworkId) {
        this.managementNetworkId = managementNetworkId;
    }

    /**
     * IP Address and subnet configuration for the management port. Do not specify this
     * field and default_gateway_addresses to use DHCP. Note: only one IPv4 address is
     * supported for the management port.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx_policy.model.IPSubnet> getManagementPortSubnets() {
        return this.managementPortSubnets;
    }

    /**
     * IP Address and subnet configuration for the management port. Do not specify this
     * field and default_gateway_addresses to use DHCP. Note: only one IPv4 address is
     * supported for the management port.
     *
     * @param managementPortSubnets New value for the property.
     */
    public void setManagementPortSubnets(java.util.List<com.vmware.nsx_policy.model.IPSubnet> managementPortSubnets) {
        this.managementPortSubnets = managementPortSubnets;
    }

    /**
     * List of NTP servers. format: hostname-or-ipv4
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getNtpServers() {
        return this.ntpServers;
    }

    /**
     * List of NTP servers. format: hostname-or-ipv4
     *
     * @param ntpServers New value for the property.
     */
    public void setNtpServers(java.util.List<java.lang.String> ntpServers) {
        this.ntpServers = ntpServers;
    }

    /**
     * The Advanced Load Balancer controller node VM will be deployed on the specified
     * datastore in the specified VC server. User must ensure that storage is
     * accessible by the specified cluster/host.
     *
     * @return The current value of the property.
     */
    public java.lang.String getStorageId() {
        return this.storageId;
    }

    /**
     * The Advanced Load Balancer controller node VM will be deployed on the specified
     * datastore in the specified VC server. User must ensure that storage is
     * accessible by the specified cluster/host.
     *
     * @param storageId New value for the property.
     */
    public void setStorageId(java.lang.String storageId) {
        this.storageId = storageId;
    }

    /**
     * The cluster node VM will be deployed with the specified storage policy on the
     * specified datastore in the specified VC server. User must ensure that the
     * storage policy is applicable on the given datastore.
     *
     * @return The current value of the property.
     */
    public java.lang.String getStoragePolicyId() {
        return this.storagePolicyId;
    }

    /**
     * The cluster node VM will be deployed with the specified storage policy on the
     * specified datastore in the specified VC server. User must ensure that the
     * storage policy is applicable on the given datastore.
     *
     * @param storagePolicyId New value for the property.
     */
    public void setStoragePolicyId(java.lang.String storagePolicyId) {
        this.storagePolicyId = storagePolicyId;
    }

    /**
     * The VC-specific identifiers will be resolved on this VC, so all other
     * identifiers specified in the config must belong to this vCenter server.
     *
     * @return The current value of the property.
     */
    public java.lang.String getVcId() {
        return this.vcId;
    }

    /**
     * The VC-specific identifiers will be resolved on this VC, so all other
     * identifiers specified in the config must belong to this vCenter server.
     *
     * @param vcId New value for the property.
     */
    public void setVcId(java.lang.String vcId) {
        this.vcId = vcId;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.ALBControllerNodeVMDeploymentConfig#PLACEMENT_TYPE_ALBCONTROLLERVSPHERECLUSTERNODEVMDEPLOYMENTCONFIG}</li>
     * </ul> Specifies the config for the platform through which to deploy the VM.
     * The value of this property is automatically populated to {@code "AlbControllerVsphereClusterNodeVmDeploymentConfig"}.
     *
     * @return The current value of the property.
     */
    public java.lang.String getPlacementType() {
        return this.placementType;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.albControllerVsphereClusterNodeVmDeploymentConfig;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("compute_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.computeId, this._getType().getField("compute_id")));
        structValue.setField("default_gateway_addresses",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.defaultGatewayAddresses, this._getType().getField("default_gateway_addresses")));
        structValue.setField("disk_provisioning",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.diskProvisioning, this._getType().getField("disk_provisioning")));
        structValue.setField("display_name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.displayName, this._getType().getField("display_name")));
        structValue.setField("dns_servers",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.dnsServers, this._getType().getField("dns_servers")));
        structValue.setField("host_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.hostId, this._getType().getField("host_id")));
        structValue.setField("hostname",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.hostname, this._getType().getField("hostname")));
        structValue.setField("management_network_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.managementNetworkId, this._getType().getField("management_network_id")));
        structValue.setField("management_port_subnets",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.managementPortSubnets, this._getType().getField("management_port_subnets")));
        structValue.setField("ntp_servers",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ntpServers, this._getType().getField("ntp_servers")));
        structValue.setField("storage_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.storageId, this._getType().getField("storage_id")));
        structValue.setField("storage_policy_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.storagePolicyId, this._getType().getField("storage_policy_id")));
        structValue.setField("vc_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.vcId, this._getType().getField("vc_id")));
        structValue.setField("placement_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.placementType, this._getType().getField("placement_type")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.albControllerVsphereClusterNodeVmDeploymentConfig;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.albControllerVsphereClusterNodeVmDeploymentConfig.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static AlbControllerVsphereClusterNodeVmDeploymentConfig _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new AlbControllerVsphereClusterNodeVmDeploymentConfig(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static AlbControllerVsphereClusterNodeVmDeploymentConfig _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new AlbControllerVsphereClusterNodeVmDeploymentConfig(structValue);
    }

    /**
     * Builder class for {@link AlbControllerVsphereClusterNodeVmDeploymentConfig}.
     */
    public static final class Builder {
        private java.lang.String computeId;
        private java.util.List<java.lang.String> defaultGatewayAddresses;
        private java.lang.String diskProvisioning;
        private java.lang.String displayName;
        private java.util.List<java.lang.String> dnsServers;
        private java.lang.String hostId;
        private java.lang.String hostname;
        private java.lang.String managementNetworkId;
        private java.util.List<com.vmware.nsx_policy.model.IPSubnet> managementPortSubnets;
        private java.util.List<java.lang.String> ntpServers;
        private java.lang.String storageId;
        private java.lang.String storagePolicyId;
        private java.lang.String vcId;

        /**
         * Constructor with parameters for the required properties of
         * {@link AlbControllerVsphereClusterNodeVmDeploymentConfig}.
         */
        public Builder() {
        }

        /**
         * The Advanced Load Balancer controller node VM will be deployed on the specified
         * cluster or resourcepool for specified VC server.
         *
         * @param computeId New value for the property.
         */
        public Builder setComputeId(java.lang.String computeId) {
            this.computeId = computeId;
            return this;
        }

        /**
         * The default gateway for the VM to be deployed must be specified if all the other
         * VMs it communicates with are not in the same subnet. Do not specify this field
         * and management_port_subnets to use DHCP. Note: only single IPv4 default gateway
         * address is supported and it must belong to management network. format: ip
         *
         * @param defaultGatewayAddresses New value for the property.
         */
        public Builder setDefaultGatewayAddresses(java.util.List<java.lang.String> defaultGatewayAddresses) {
            this.defaultGatewayAddresses = defaultGatewayAddresses;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.AlbControllerVsphereClusterNodeVmDeploymentConfig#DISK_PROVISIONING_THIN}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.AlbControllerVsphereClusterNodeVmDeploymentConfig#DISK_PROVISIONING_LAZY_ZEROED_THICK}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.AlbControllerVsphereClusterNodeVmDeploymentConfig#DISK_PROVISIONING_EAGER_ZEROED_THICK}</li>
         * </ul> Specifies the disk provisioning type of the VM.
         *
         * @param diskProvisioning New value for the property.
         */
        public Builder setDiskProvisioning(java.lang.String diskProvisioning) {
            this.diskProvisioning = diskProvisioning;
            return this;
        }

        /**
         * Desired display name for Advanced Load Balancer controller VM to be deployed.
         *
         * @param displayName New value for the property.
         */
        public Builder setDisplayName(java.lang.String displayName) {
            this.displayName = displayName;
            return this;
        }

        /**
         * List of DNS servers. format: ipv4
         *
         * @param dnsServers New value for the property.
         */
        public Builder setDnsServers(java.util.List<java.lang.String> dnsServers) {
            this.dnsServers = dnsServers;
            return this;
        }

        /**
         * The Advanced Load Balancer controller node VM will be deployed on the specified
         * host in the specified VC server within the cluster if host_id is specified.
         * Note: User must ensure that storage and specified networks are accessible by
         * this host.
         *
         * @param hostId New value for the property.
         */
        public Builder setHostId(java.lang.String hostId) {
            this.hostId = hostId;
            return this;
        }

        /**
         * Desired host name/FQDN for the VM to be deployed. format: hostname-or-ip
         *
         * @param hostname New value for the property.
         */
        public Builder setHostname(java.lang.String hostname) {
            this.hostname = hostname;
            return this;
        }

        /**
         * Distributed portgroup identifier to which the management vnic of Advanced Load
         * Balancer controller node VM will be connected.
         *
         * @param managementNetworkId New value for the property.
         */
        public Builder setManagementNetworkId(java.lang.String managementNetworkId) {
            this.managementNetworkId = managementNetworkId;
            return this;
        }

        /**
         * IP Address and subnet configuration for the management port. Do not specify this
         * field and default_gateway_addresses to use DHCP. Note: only one IPv4 address is
         * supported for the management port.
         *
         * @param managementPortSubnets New value for the property.
         */
        public Builder setManagementPortSubnets(java.util.List<com.vmware.nsx_policy.model.IPSubnet> managementPortSubnets) {
            this.managementPortSubnets = managementPortSubnets;
            return this;
        }

        /**
         * List of NTP servers. format: hostname-or-ipv4
         *
         * @param ntpServers New value for the property.
         */
        public Builder setNtpServers(java.util.List<java.lang.String> ntpServers) {
            this.ntpServers = ntpServers;
            return this;
        }

        /**
         * The Advanced Load Balancer controller node VM will be deployed on the specified
         * datastore in the specified VC server. User must ensure that storage is
         * accessible by the specified cluster/host.
         *
         * @param storageId New value for the property.
         */
        public Builder setStorageId(java.lang.String storageId) {
            this.storageId = storageId;
            return this;
        }

        /**
         * The cluster node VM will be deployed with the specified storage policy on the
         * specified datastore in the specified VC server. User must ensure that the
         * storage policy is applicable on the given datastore.
         *
         * @param storagePolicyId New value for the property.
         */
        public Builder setStoragePolicyId(java.lang.String storagePolicyId) {
            this.storagePolicyId = storagePolicyId;
            return this;
        }

        /**
         * The VC-specific identifiers will be resolved on this VC, so all other
         * identifiers specified in the config must belong to this vCenter server.
         *
         * @param vcId New value for the property.
         */
        public Builder setVcId(java.lang.String vcId) {
            this.vcId = vcId;
            return this;
        }

        public AlbControllerVsphereClusterNodeVmDeploymentConfig build() {
            AlbControllerVsphereClusterNodeVmDeploymentConfig result = new AlbControllerVsphereClusterNodeVmDeploymentConfig();
            result.setComputeId(this.computeId);
            result.setDefaultGatewayAddresses(this.defaultGatewayAddresses);
            result.setDiskProvisioning(this.diskProvisioning);
            result.setDisplayName(this.displayName);
            result.setDnsServers(this.dnsServers);
            result.setHostId(this.hostId);
            result.setHostname(this.hostname);
            result.setManagementNetworkId(this.managementNetworkId);
            result.setManagementPortSubnets(this.managementPortSubnets);
            result.setNtpServers(this.ntpServers);
            result.setStorageId(this.storageId);
            result.setStoragePolicyId(this.storagePolicyId);
            result.setVcId(this.vcId);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("compute_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("compute_id",
                                                                                "computeId",
                                                                                "getComputeId",
                                                                                "setComputeId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("default_gateway_addresses", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("default_gateway_addresses",
                                                                                "defaultGatewayAddresses",
                                                                                "getDefaultGatewayAddresses",
                                                                                "setDefaultGatewayAddresses");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("disk_provisioning", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("disk_provisioning",
                                                                                "diskProvisioning",
                                                                                "getDiskProvisioning",
                                                                                "setDiskProvisioning");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("display_name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("display_name",
                                                                                "displayName",
                                                                                "getDisplayName",
                                                                                "setDisplayName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("dns_servers", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("dns_servers",
                                                                                "dnsServers",
                                                                                "getDnsServers",
                                                                                "setDnsServers");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("host_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("host_id",
                                                                                "hostId",
                                                                                "getHostId",
                                                                                "setHostId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("hostname", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("hostname",
                                                                                "hostname",
                                                                                "getHostname",
                                                                                "setHostname");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("management_network_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("management_network_id",
                                                                                "managementNetworkId",
                                                                                "getManagementNetworkId",
                                                                                "setManagementNetworkId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("management_port_subnets", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.IPSubnet; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("management_port_subnets",
                                                                                "managementPortSubnets",
                                                                                "getManagementPortSubnets",
                                                                                "setManagementPortSubnets");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ntp_servers", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ntp_servers",
                                                                                "ntpServers",
                                                                                "getNtpServers",
                                                                                "setNtpServers");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("storage_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("storage_id",
                                                                                "storageId",
                                                                                "getStorageId",
                                                                                "setStorageId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("storage_policy_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("storage_policy_id",
                                                                                "storagePolicyId",
                                                                                "getStoragePolicyId",
                                                                                "setStoragePolicyId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("vc_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("vc_id",
                                                                                "vcId",
                                                                                "getVcId",
                                                                                "setVcId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("placement_type", new com.vmware.vapi.bindings.type.StringType());
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("placement_type",
                                                                                "placementType",
                                                                                "getPlacementType",
                                                                                null);
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.alb_controller_vsphere_cluster_node_vm_deployment_config",
                                                            fields,
                                                            com.vmware.nsx_policy.model.AlbControllerVsphereClusterNodeVmDeploymentConfig.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            "placement_type",
                                                            "AlbControllerVsphereClusterNodeVmDeploymentConfig");
    }
}

