/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * API Request Body is an Event Source that represents an API request body that is
 * being reveived as part of an API. Supported Request Bodies are those received as
 * part of a PATCH/PUT/POST request.
 */
public final class ApiRequestBody implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    /**
     * Identifier denoting this class, when it is used in polymorphic context. 
     * <p>This
     * value should be assigned to the property which is used to discriminate the
     * actual type used in the polymorphic context.</p>
     */
    public static final java.lang.String _TYPE_IDENTIFIER = "ApiRequestBody";

    private java.lang.String resourcePointer;

    private final java.lang.String resourceType = "ApiRequestBody";

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public ApiRequestBody() {
    }

    protected ApiRequestBody(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Regex path representing a regex expression on resources. This regex is used to
     * identify the request body(ies) that is/are the source of the Event. For
     * instance: specifying \"Lb* | /infra/tier-0s/vmc/ipsec-vpn-services/default\" as
     * a source means that ANY resource starting with Lb or ANY resource with
     * \"/infra/tier-0s/vmc/ipsec-vpn-services/default\" as path would be the source of
     * the event in question.
     *
     * @return The current value of the property.
     */
    public java.lang.String getResourcePointer() {
        return this.resourcePointer;
    }

    /**
     * Regex path representing a regex expression on resources. This regex is used to
     * identify the request body(ies) that is/are the source of the Event. For
     * instance: specifying \"Lb* | /infra/tier-0s/vmc/ipsec-vpn-services/default\" as
     * a source means that ANY resource starting with Lb or ANY resource with
     * \"/infra/tier-0s/vmc/ipsec-vpn-services/default\" as path would be the source of
     * the event in question.
     *
     * @param resourcePointer New value for the property.
     */
    public void setResourcePointer(java.lang.String resourcePointer) {
        this.resourcePointer = resourcePointer;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.Source#RESOURCE_TYPE_RESOURCEOPERATION}</li> <li>
     * {@link com.vmware.nsx_policy.model.Source#RESOURCE_TYPE_APIREQUESTBODY}</li>
     * </ul> Event Source resource type.
     * The value of this property is automatically populated to {@code "ApiRequestBody"}.
     *
     * @return The current value of the property.
     */
    public java.lang.String getResourceType() {
        return this.resourceType;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.apiRequestBody;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("resource_pointer",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.resourcePointer, this._getType().getField("resource_pointer")));
        structValue.setField("resource_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.resourceType, this._getType().getField("resource_type")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.apiRequestBody;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.apiRequestBody.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static ApiRequestBody _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new ApiRequestBody(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static ApiRequestBody _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new ApiRequestBody(structValue);
    }

    /**
     * Builder class for {@link ApiRequestBody}.
     */
    public static final class Builder {
        private java.lang.String resourcePointer;

        /**
         * Constructor with parameters for the required properties of
         * {@link ApiRequestBody}.
         */
        public Builder() {
        }

        /**
         * Regex path representing a regex expression on resources. This regex is used to
         * identify the request body(ies) that is/are the source of the Event. For
         * instance: specifying \"Lb* | /infra/tier-0s/vmc/ipsec-vpn-services/default\" as
         * a source means that ANY resource starting with Lb or ANY resource with
         * \"/infra/tier-0s/vmc/ipsec-vpn-services/default\" as path would be the source of
         * the event in question.
         *
         * @param resourcePointer New value for the property.
         */
        public Builder setResourcePointer(java.lang.String resourcePointer) {
            this.resourcePointer = resourcePointer;
            return this;
        }

        public ApiRequestBody build() {
            ApiRequestBody result = new ApiRequestBody();
            result.setResourcePointer(this.resourcePointer);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("resource_pointer", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("resource_pointer",
                                                                                "resourcePointer",
                                                                                "getResourcePointer",
                                                                                "setResourcePointer");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("resource_type", new com.vmware.vapi.bindings.type.StringType());
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("resource_type",
                                                                                "resourceType",
                                                                                "getResourceType",
                                                                                null);
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.api_request_body",
                                                            fields,
                                                            com.vmware.nsx_policy.model.ApiRequestBody.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            "resource_type",
                                                            "ApiRequestBody");
    }
}

