/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

public final class CapacityThreshold implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.lang.Double maxThresholdPercentage;

    private java.lang.Double minThresholdPercentage;

    private java.lang.String thresholdType;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public CapacityThreshold() {
    }

    protected CapacityThreshold(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Set the maximum threshold percentage. Specify a value between 0 and 100. Usage
     * percentage above this value is tagged as critical.
     *
     * @return The current value of the property.
     */
    public java.lang.Double getMaxThresholdPercentage() {
        return this.maxThresholdPercentage;
    }

    /**
     * Set the maximum threshold percentage. Specify a value between 0 and 100. Usage
     * percentage above this value is tagged as critical.
     *
     * @param maxThresholdPercentage New value for the property.
     */
    public void setMaxThresholdPercentage(java.lang.Double maxThresholdPercentage) {
        this.maxThresholdPercentage = maxThresholdPercentage;
    }

    /**
     * Set the minimum threshold percentage. Specify a value between 0 and 100. Usage
     * percentage above this value is tagged as warning.
     *
     * @return The current value of the property.
     */
    public java.lang.Double getMinThresholdPercentage() {
        return this.minThresholdPercentage;
    }

    /**
     * Set the minimum threshold percentage. Specify a value between 0 and 100. Usage
     * percentage above this value is tagged as warning.
     *
     * @param minThresholdPercentage New value for the property.
     */
    public void setMinThresholdPercentage(java.lang.Double minThresholdPercentage) {
        this.minThresholdPercentage = minThresholdPercentage;
    }

    /**
     * Indicate the object type for which threshold is to be set.
     *
     * @return The current value of the property.
     */
    public java.lang.String getThresholdType() {
        return this.thresholdType;
    }

    /**
     * Indicate the object type for which threshold is to be set.
     *
     * @param thresholdType New value for the property.
     */
    public void setThresholdType(java.lang.String thresholdType) {
        this.thresholdType = thresholdType;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.capacityThreshold;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("max_threshold_percentage",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.maxThresholdPercentage, this._getType().getField("max_threshold_percentage")));
        structValue.setField("min_threshold_percentage",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.minThresholdPercentage, this._getType().getField("min_threshold_percentage")));
        structValue.setField("threshold_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.thresholdType, this._getType().getField("threshold_type")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.capacityThreshold;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.capacityThreshold.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static CapacityThreshold _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new CapacityThreshold(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static CapacityThreshold _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new CapacityThreshold(structValue);
    }

    /**
     * Builder class for {@link CapacityThreshold}.
     */
    public static final class Builder {
        private java.lang.Double maxThresholdPercentage;
        private java.lang.Double minThresholdPercentage;
        private java.lang.String thresholdType;

        /**
         * Constructor with parameters for the required properties of
         * {@link CapacityThreshold}.
         */
        public Builder() {
        }

        /**
         * Set the maximum threshold percentage. Specify a value between 0 and 100. Usage
         * percentage above this value is tagged as critical.
         *
         * @param maxThresholdPercentage New value for the property.
         */
        public Builder setMaxThresholdPercentage(java.lang.Double maxThresholdPercentage) {
            this.maxThresholdPercentage = maxThresholdPercentage;
            return this;
        }

        /**
         * Set the minimum threshold percentage. Specify a value between 0 and 100. Usage
         * percentage above this value is tagged as warning.
         *
         * @param minThresholdPercentage New value for the property.
         */
        public Builder setMinThresholdPercentage(java.lang.Double minThresholdPercentage) {
            this.minThresholdPercentage = minThresholdPercentage;
            return this;
        }

        /**
         * Indicate the object type for which threshold is to be set.
         *
         * @param thresholdType New value for the property.
         */
        public Builder setThresholdType(java.lang.String thresholdType) {
            this.thresholdType = thresholdType;
            return this;
        }

        public CapacityThreshold build() {
            CapacityThreshold result = new CapacityThreshold();
            result.setMaxThresholdPercentage(this.maxThresholdPercentage);
            result.setMinThresholdPercentage(this.minThresholdPercentage);
            result.setThresholdType(this.thresholdType);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("max_threshold_percentage", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.DoubleType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("max_threshold_percentage",
                                                                                "maxThresholdPercentage",
                                                                                "getMaxThresholdPercentage",
                                                                                "setMaxThresholdPercentage");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("min_threshold_percentage", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.DoubleType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("min_threshold_percentage",
                                                                                "minThresholdPercentage",
                                                                                "getMinThresholdPercentage",
                                                                                "setMinThresholdPercentage");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("threshold_type", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("threshold_type",
                                                                                "thresholdType",
                                                                                "getThresholdType",
                                                                                "setThresholdType");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.capacity_threshold",
                                                            fields,
                                                            com.vmware.nsx_policy.model.CapacityThreshold.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

