/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * Cluster restore status
 */
public final class ClusterRestoreStatus implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String NOT_ALLOWED_ACTIONS_UPDATES = "VC_UPDATES";

    private java.util.List<java.lang.String> allowedActions;

    private java.lang.Long backupTimestamp;

    private java.util.List<com.vmware.nsx_policy.model.ResourceLink> endpoints;

    private java.lang.String id;

    private java.util.List<com.vmware.nsx_policy.model.InstructionInfo> instructions;

    private java.util.List<java.lang.String> notAllowedActions;

    private java.lang.Long restoreEndTime;

    private java.lang.Long restoreStartTime;

    private com.vmware.nsx_policy.model.GlobalRestoreStatus status;

    private com.vmware.nsx_policy.model.RestoreStep step;

    private java.lang.Long totalSteps;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public ClusterRestoreStatus() {
    }

    protected ClusterRestoreStatus(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * List of actions that are allowed.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getAllowedActions() {
        return this.allowedActions;
    }

    /**
     * List of actions that are allowed.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param allowedActions New value for the property.
     */
    public void setAllowedActions(java.util.List<java.lang.String> allowedActions) {
        this.allowedActions = allowedActions;
    }

    /**
     * Timestamp when backup was initiated in epoch millisecond format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getBackupTimestamp() {
        return this.backupTimestamp;
    }

    /**
     * Timestamp when backup was initiated in epoch millisecond format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param backupTimestamp New value for the property.
     */
    public void setBackupTimestamp(java.lang.Long backupTimestamp) {
        this.backupTimestamp = backupTimestamp;
    }

    /**
     * The list of allowed endpoints, based on the current state of the restore process
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx_policy.model.ResourceLink> getEndpoints() {
        return this.endpoints;
    }

    /**
     * The list of allowed endpoints, based on the current state of the restore process
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param endpoints New value for the property.
     */
    public void setEndpoints(java.util.List<com.vmware.nsx_policy.model.ResourceLink> endpoints) {
        this.endpoints = endpoints;
    }

    /**
     * Unique id for backup request
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getId() {
        return this.id;
    }

    /**
     * Unique id for backup request
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param id New value for the property.
     */
    public void setId(java.lang.String id) {
        this.id = id;
    }

    /**
     * Instructions for users to reconcile Restore operations
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx_policy.model.InstructionInfo> getInstructions() {
        return this.instructions;
    }

    /**
     * Instructions for users to reconcile Restore operations
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param instructions New value for the property.
     */
    public void setInstructions(java.util.List<com.vmware.nsx_policy.model.InstructionInfo> instructions) {
        this.instructions = instructions;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.ClusterRestoreStatus#NOT_ALLOWED_ACTIONS_UPDATES}</li>
     * </ul> List of actions that are not allowed
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getNotAllowedActions() {
        return this.notAllowedActions;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.ClusterRestoreStatus#NOT_ALLOWED_ACTIONS_UPDATES}</li>
     * </ul> List of actions that are not allowed
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param notAllowedActions New value for the property.
     */
    public void setNotAllowedActions(java.util.List<java.lang.String> notAllowedActions) {
        this.notAllowedActions = notAllowedActions;
    }

    /**
     * Timestamp when restore was completed in epoch millisecond format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getRestoreEndTime() {
        return this.restoreEndTime;
    }

    /**
     * Timestamp when restore was completed in epoch millisecond format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param restoreEndTime New value for the property.
     */
    public void setRestoreEndTime(java.lang.Long restoreEndTime) {
        this.restoreEndTime = restoreEndTime;
    }

    /**
     * Timestamp when restore was started in epoch millisecond format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getRestoreStartTime() {
        return this.restoreStartTime;
    }

    /**
     * Timestamp when restore was started in epoch millisecond format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param restoreStartTime New value for the property.
     */
    public void setRestoreStartTime(java.lang.Long restoreStartTime) {
        this.restoreStartTime = restoreStartTime;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx_policy.model.GlobalRestoreStatus getStatus() {
        return this.status;
    }

    /**
     *
     *
     * @param status New value for the property.
     */
    public void setStatus(com.vmware.nsx_policy.model.GlobalRestoreStatus status) {
        this.status = status;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx_policy.model.RestoreStep getStep() {
        return this.step;
    }

    /**
     *
     *
     * @param step New value for the property.
     */
    public void setStep(com.vmware.nsx_policy.model.RestoreStep step) {
        this.step = step;
    }

    /**
     * Total number of steps in the entire restore process format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getTotalSteps() {
        return this.totalSteps;
    }

    /**
     * Total number of steps in the entire restore process format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param totalSteps New value for the property.
     */
    public void setTotalSteps(java.lang.Long totalSteps) {
        this.totalSteps = totalSteps;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.clusterRestoreStatus;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("allowed_actions",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.allowedActions, this._getType().getField("allowed_actions")));
        structValue.setField("backup_timestamp",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.backupTimestamp, this._getType().getField("backup_timestamp")));
        structValue.setField("endpoints",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.endpoints, this._getType().getField("endpoints")));
        structValue.setField("id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.id, this._getType().getField("id")));
        structValue.setField("instructions",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.instructions, this._getType().getField("instructions")));
        structValue.setField("not_allowed_actions",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.notAllowedActions, this._getType().getField("not_allowed_actions")));
        structValue.setField("restore_end_time",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.restoreEndTime, this._getType().getField("restore_end_time")));
        structValue.setField("restore_start_time",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.restoreStartTime, this._getType().getField("restore_start_time")));
        structValue.setField("status",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.status, this._getType().getField("status")));
        structValue.setField("step",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.step, this._getType().getField("step")));
        structValue.setField("total_steps",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.totalSteps, this._getType().getField("total_steps")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.clusterRestoreStatus;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.clusterRestoreStatus.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static ClusterRestoreStatus _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new ClusterRestoreStatus(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static ClusterRestoreStatus _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new ClusterRestoreStatus(structValue);
    }

    /**
     * Builder class for {@link ClusterRestoreStatus}.
     */
    public static final class Builder {
        private java.util.List<java.lang.String> allowedActions;
        private java.lang.Long backupTimestamp;
        private java.util.List<com.vmware.nsx_policy.model.ResourceLink> endpoints;
        private java.lang.String id;
        private java.util.List<com.vmware.nsx_policy.model.InstructionInfo> instructions;
        private java.util.List<java.lang.String> notAllowedActions;
        private java.lang.Long restoreEndTime;
        private java.lang.Long restoreStartTime;
        private com.vmware.nsx_policy.model.GlobalRestoreStatus status;
        private com.vmware.nsx_policy.model.RestoreStep step;
        private java.lang.Long totalSteps;

        /**
         * Constructor with parameters for the required properties of
         * {@link ClusterRestoreStatus}.
         */
        public Builder() {
        }

        /**
         * List of actions that are allowed.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param allowedActions New value for the property.
         */
        public Builder setAllowedActions(java.util.List<java.lang.String> allowedActions) {
            this.allowedActions = allowedActions;
            return this;
        }

        /**
         * Timestamp when backup was initiated in epoch millisecond format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param backupTimestamp New value for the property.
         */
        public Builder setBackupTimestamp(java.lang.Long backupTimestamp) {
            this.backupTimestamp = backupTimestamp;
            return this;
        }

        /**
         * The list of allowed endpoints, based on the current state of the restore process
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param endpoints New value for the property.
         */
        public Builder setEndpoints(java.util.List<com.vmware.nsx_policy.model.ResourceLink> endpoints) {
            this.endpoints = endpoints;
            return this;
        }

        /**
         * Unique id for backup request
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param id New value for the property.
         */
        public Builder setId(java.lang.String id) {
            this.id = id;
            return this;
        }

        /**
         * Instructions for users to reconcile Restore operations
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param instructions New value for the property.
         */
        public Builder setInstructions(java.util.List<com.vmware.nsx_policy.model.InstructionInfo> instructions) {
            this.instructions = instructions;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.ClusterRestoreStatus#NOT_ALLOWED_ACTIONS_UPDATES}</li>
         * </ul> List of actions that are not allowed
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param notAllowedActions New value for the property.
         */
        public Builder setNotAllowedActions(java.util.List<java.lang.String> notAllowedActions) {
            this.notAllowedActions = notAllowedActions;
            return this;
        }

        /**
         * Timestamp when restore was completed in epoch millisecond format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param restoreEndTime New value for the property.
         */
        public Builder setRestoreEndTime(java.lang.Long restoreEndTime) {
            this.restoreEndTime = restoreEndTime;
            return this;
        }

        /**
         * Timestamp when restore was started in epoch millisecond format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param restoreStartTime New value for the property.
         */
        public Builder setRestoreStartTime(java.lang.Long restoreStartTime) {
            this.restoreStartTime = restoreStartTime;
            return this;
        }

        /**
         *
         *
         * @param status New value for the property.
         */
        public Builder setStatus(com.vmware.nsx_policy.model.GlobalRestoreStatus status) {
            this.status = status;
            return this;
        }

        /**
         *
         *
         * @param step New value for the property.
         */
        public Builder setStep(com.vmware.nsx_policy.model.RestoreStep step) {
            this.step = step;
            return this;
        }

        /**
         * Total number of steps in the entire restore process format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param totalSteps New value for the property.
         */
        public Builder setTotalSteps(java.lang.Long totalSteps) {
            this.totalSteps = totalSteps;
            return this;
        }

        public ClusterRestoreStatus build() {
            ClusterRestoreStatus result = new ClusterRestoreStatus();
            result.setAllowedActions(this.allowedActions);
            result.setBackupTimestamp(this.backupTimestamp);
            result.setEndpoints(this.endpoints);
            result.setId(this.id);
            result.setInstructions(this.instructions);
            result.setNotAllowedActions(this.notAllowedActions);
            result.setRestoreEndTime(this.restoreEndTime);
            result.setRestoreStartTime(this.restoreStartTime);
            result.setStatus(this.status);
            result.setStep(this.step);
            result.setTotalSteps(this.totalSteps);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("allowed_actions", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("allowed_actions",
                                                                                "allowedActions",
                                                                                "getAllowedActions",
                                                                                "setAllowedActions");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("backup_timestamp", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("backup_timestamp",
                                                                                "backupTimestamp",
                                                                                "getBackupTimestamp",
                                                                                "setBackupTimestamp");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("endpoints", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.resourceLink; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("endpoints",
                                                                                "endpoints",
                                                                                "getEndpoints",
                                                                                "setEndpoints");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("id",
                                                                                "id",
                                                                                "getId",
                                                                                "setId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("instructions", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.instructionInfo; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("instructions",
                                                                                "instructions",
                                                                                "getInstructions",
                                                                                "setInstructions");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("not_allowed_actions", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("not_allowed_actions",
                                                                                "notAllowedActions",
                                                                                "getNotAllowedActions",
                                                                                "setNotAllowedActions");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("restore_end_time", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("restore_end_time",
                                                                                "restoreEndTime",
                                                                                "getRestoreEndTime",
                                                                                "setRestoreEndTime");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("restore_start_time", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("restore_start_time",
                                                                                "restoreStartTime",
                                                                                "getRestoreStartTime",
                                                                                "setRestoreStartTime");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("status", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.globalRestoreStatus; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("status",
                                                                                "status",
                                                                                "getStatus",
                                                                                "setStatus");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("step", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.restoreStep; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("step",
                                                                                "step",
                                                                                "getStep",
                                                                                "setStep");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("total_steps", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("total_steps",
                                                                                "totalSteps",
                                                                                "getTotalSteps",
                                                                                "setTotalSteps");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.cluster_restore_status",
                                                            fields,
                                                            com.vmware.nsx_policy.model.ClusterRestoreStatus.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

