/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * CPU usage of DPDK and non-DPDK cores
 */
public final class CpuUsage implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.lang.Double avgCpuCoreUsageDpdk;

    private java.lang.Double avgCpuCoreUsageNonDpdk;

    private java.lang.Double highestCpuCoreUsageDpdk;

    private java.lang.Double highestCpuCoreUsageNonDpdk;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public CpuUsage() {
    }

    protected CpuUsage(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Indicates the average usage of all DPDK cores in percentage.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Double getAvgCpuCoreUsageDpdk() {
        return this.avgCpuCoreUsageDpdk;
    }

    /**
     * Indicates the average usage of all DPDK cores in percentage.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param avgCpuCoreUsageDpdk New value for the property.
     */
    public void setAvgCpuCoreUsageDpdk(java.lang.Double avgCpuCoreUsageDpdk) {
        this.avgCpuCoreUsageDpdk = avgCpuCoreUsageDpdk;
    }

    /**
     * Indicates the average usage of all non-DPDK cores in percentage.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Double getAvgCpuCoreUsageNonDpdk() {
        return this.avgCpuCoreUsageNonDpdk;
    }

    /**
     * Indicates the average usage of all non-DPDK cores in percentage.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param avgCpuCoreUsageNonDpdk New value for the property.
     */
    public void setAvgCpuCoreUsageNonDpdk(java.lang.Double avgCpuCoreUsageNonDpdk) {
        this.avgCpuCoreUsageNonDpdk = avgCpuCoreUsageNonDpdk;
    }

    /**
     * Indicates the highest CPU utilization value among DPDK cores in percentage.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Double getHighestCpuCoreUsageDpdk() {
        return this.highestCpuCoreUsageDpdk;
    }

    /**
     * Indicates the highest CPU utilization value among DPDK cores in percentage.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param highestCpuCoreUsageDpdk New value for the property.
     */
    public void setHighestCpuCoreUsageDpdk(java.lang.Double highestCpuCoreUsageDpdk) {
        this.highestCpuCoreUsageDpdk = highestCpuCoreUsageDpdk;
    }

    /**
     * Indicates the highest cpu utilization value among non_dpdk cores in percentage.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Double getHighestCpuCoreUsageNonDpdk() {
        return this.highestCpuCoreUsageNonDpdk;
    }

    /**
     * Indicates the highest cpu utilization value among non_dpdk cores in percentage.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param highestCpuCoreUsageNonDpdk New value for the property.
     */
    public void setHighestCpuCoreUsageNonDpdk(java.lang.Double highestCpuCoreUsageNonDpdk) {
        this.highestCpuCoreUsageNonDpdk = highestCpuCoreUsageNonDpdk;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.cpuUsage;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("avg_cpu_core_usage_dpdk",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.avgCpuCoreUsageDpdk, this._getType().getField("avg_cpu_core_usage_dpdk")));
        structValue.setField("avg_cpu_core_usage_non_dpdk",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.avgCpuCoreUsageNonDpdk, this._getType().getField("avg_cpu_core_usage_non_dpdk")));
        structValue.setField("highest_cpu_core_usage_dpdk",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.highestCpuCoreUsageDpdk, this._getType().getField("highest_cpu_core_usage_dpdk")));
        structValue.setField("highest_cpu_core_usage_non_dpdk",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.highestCpuCoreUsageNonDpdk, this._getType().getField("highest_cpu_core_usage_non_dpdk")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.cpuUsage;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.cpuUsage.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static CpuUsage _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new CpuUsage(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static CpuUsage _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new CpuUsage(structValue);
    }

    /**
     * Builder class for {@link CpuUsage}.
     */
    public static final class Builder {
        private java.lang.Double avgCpuCoreUsageDpdk;
        private java.lang.Double avgCpuCoreUsageNonDpdk;
        private java.lang.Double highestCpuCoreUsageDpdk;
        private java.lang.Double highestCpuCoreUsageNonDpdk;

        /**
         * Constructor with parameters for the required properties of
         * {@link CpuUsage}.
         */
        public Builder() {
        }

        /**
         * Indicates the average usage of all DPDK cores in percentage.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param avgCpuCoreUsageDpdk New value for the property.
         */
        public Builder setAvgCpuCoreUsageDpdk(java.lang.Double avgCpuCoreUsageDpdk) {
            this.avgCpuCoreUsageDpdk = avgCpuCoreUsageDpdk;
            return this;
        }

        /**
         * Indicates the average usage of all non-DPDK cores in percentage.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param avgCpuCoreUsageNonDpdk New value for the property.
         */
        public Builder setAvgCpuCoreUsageNonDpdk(java.lang.Double avgCpuCoreUsageNonDpdk) {
            this.avgCpuCoreUsageNonDpdk = avgCpuCoreUsageNonDpdk;
            return this;
        }

        /**
         * Indicates the highest CPU utilization value among DPDK cores in percentage.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param highestCpuCoreUsageDpdk New value for the property.
         */
        public Builder setHighestCpuCoreUsageDpdk(java.lang.Double highestCpuCoreUsageDpdk) {
            this.highestCpuCoreUsageDpdk = highestCpuCoreUsageDpdk;
            return this;
        }

        /**
         * Indicates the highest cpu utilization value among non_dpdk cores in percentage.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param highestCpuCoreUsageNonDpdk New value for the property.
         */
        public Builder setHighestCpuCoreUsageNonDpdk(java.lang.Double highestCpuCoreUsageNonDpdk) {
            this.highestCpuCoreUsageNonDpdk = highestCpuCoreUsageNonDpdk;
            return this;
        }

        public CpuUsage build() {
            CpuUsage result = new CpuUsage();
            result.setAvgCpuCoreUsageDpdk(this.avgCpuCoreUsageDpdk);
            result.setAvgCpuCoreUsageNonDpdk(this.avgCpuCoreUsageNonDpdk);
            result.setHighestCpuCoreUsageDpdk(this.highestCpuCoreUsageDpdk);
            result.setHighestCpuCoreUsageNonDpdk(this.highestCpuCoreUsageNonDpdk);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("avg_cpu_core_usage_dpdk", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.DoubleType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("avg_cpu_core_usage_dpdk",
                                                                                "avgCpuCoreUsageDpdk",
                                                                                "getAvgCpuCoreUsageDpdk",
                                                                                "setAvgCpuCoreUsageDpdk");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("avg_cpu_core_usage_non_dpdk", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.DoubleType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("avg_cpu_core_usage_non_dpdk",
                                                                                "avgCpuCoreUsageNonDpdk",
                                                                                "getAvgCpuCoreUsageNonDpdk",
                                                                                "setAvgCpuCoreUsageNonDpdk");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("highest_cpu_core_usage_dpdk", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.DoubleType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("highest_cpu_core_usage_dpdk",
                                                                                "highestCpuCoreUsageDpdk",
                                                                                "getHighestCpuCoreUsageDpdk",
                                                                                "setHighestCpuCoreUsageDpdk");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("highest_cpu_core_usage_non_dpdk", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.DoubleType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("highest_cpu_core_usage_non_dpdk",
                                                                                "highestCpuCoreUsageNonDpdk",
                                                                                "getHighestCpuCoreUsageNonDpdk",
                                                                                "setHighestCpuCoreUsageNonDpdk");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.cpu_usage",
                                                            fields,
                                                            com.vmware.nsx_policy.model.CpuUsage.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

