/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * Represents details of the config flow between sites. Federation has the
 * following flows - Global Manager to Local Manager (GM -> LM) - Local Manager to
 * Glocal Manager (LM -> GM) - Global Manager Active to Glocal Manager Standby (GM
 * -> GM) - Local Manager to Local Manager (LM -> LM)
 */
public final class CrossSiteFlowInfo implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String STATUS_GOOD = "GOOD";

    public static final java.lang.String STATUS_DISCONNECTED = "DISCONNECTED";

    public static final java.lang.String STATUS_RECOVERY = "RECOVERY";

    public static final java.lang.String STATUS_ERROR = "ERROR";

    public static final java.lang.String STATUS_UNKNOWN = "UNKNOWN";

    public static final java.lang.String STATUS_NOT_READY = "NOT_READY";

    private java.lang.String fromSiteId;

    private java.lang.String fromSitePath;

    private com.vmware.nsx_policy.model.FullSyncInfo fullSyncInfo;

    private java.lang.Long latencyMeasuredTs;

    private java.lang.Long latencyMillis;

    private java.lang.String leaderNodeId;

    private java.lang.String status;

    private java.lang.String toSiteId;

    private java.lang.String toSitePath;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public CrossSiteFlowInfo() {
    }

    protected CrossSiteFlowInfo(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Site id of the source
     *
     * @return The current value of the property.
     */
    public java.lang.String getFromSiteId() {
        return this.fromSiteId;
    }

    /**
     * Site id of the source
     *
     * @param fromSiteId New value for the property.
     */
    public void setFromSiteId(java.lang.String fromSiteId) {
        this.fromSiteId = fromSiteId;
    }

    /**
     * Source site policy path
     *
     * @return The current value of the property.
     */
    public java.lang.String getFromSitePath() {
        return this.fromSitePath;
    }

    /**
     * Source site policy path
     *
     * @param fromSitePath New value for the property.
     */
    public void setFromSitePath(java.lang.String fromSitePath) {
        this.fromSitePath = fromSitePath;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx_policy.model.FullSyncInfo getFullSyncInfo() {
        return this.fullSyncInfo;
    }

    /**
     *
     *
     * @param fullSyncInfo New value for the property.
     */
    public void setFullSyncInfo(com.vmware.nsx_policy.model.FullSyncInfo fullSyncInfo) {
        this.fullSyncInfo = fullSyncInfo;
    }

    /**
     * Timestamp of latency measurement format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getLatencyMeasuredTs() {
        return this.latencyMeasuredTs;
    }

    /**
     * Timestamp of latency measurement format: int64
     *
     * @param latencyMeasuredTs New value for the property.
     */
    public void setLatencyMeasuredTs(java.lang.Long latencyMeasuredTs) {
        this.latencyMeasuredTs = latencyMeasuredTs;
    }

    /**
     * Latency from source to destination site in milli seconds format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getLatencyMillis() {
        return this.latencyMillis;
    }

    /**
     * Latency from source to destination site in milli seconds format: int64
     *
     * @param latencyMillis New value for the property.
     */
    public void setLatencyMillis(java.lang.Long latencyMillis) {
        this.latencyMillis = latencyMillis;
    }

    /**
     * Local leader node id sharded for this remote site.
     *
     * @return The current value of the property.
     */
    public java.lang.String getLeaderNodeId() {
        return this.leaderNodeId;
    }

    /**
     * Local leader node id sharded for this remote site.
     *
     * @param leaderNodeId New value for the property.
     */
    public void setLeaderNodeId(java.lang.String leaderNodeId) {
        this.leaderNodeId = leaderNodeId;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.CrossSiteFlowInfo#STATUS_GOOD}</li> <li> {@link
     * com.vmware.nsx_policy.model.CrossSiteFlowInfo#STATUS_DISCONNECTED}</li> <li>
     * {@link com.vmware.nsx_policy.model.CrossSiteFlowInfo#STATUS_RECOVERY}</li> <li>
     * {@link com.vmware.nsx_policy.model.CrossSiteFlowInfo#STATUS_ERROR}</li> <li>
     * {@link com.vmware.nsx_policy.model.CrossSiteFlowInfo#STATUS_UNKNOWN}</li> <li>
     * {@link com.vmware.nsx_policy.model.CrossSiteFlowInfo#STATUS_NOT_READY}</li>
     * </ul> Overall status of the flow
     *
     * @return The current value of the property.
     */
    public java.lang.String getStatus() {
        return this.status;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.CrossSiteFlowInfo#STATUS_GOOD}</li> <li> {@link
     * com.vmware.nsx_policy.model.CrossSiteFlowInfo#STATUS_DISCONNECTED}</li> <li>
     * {@link com.vmware.nsx_policy.model.CrossSiteFlowInfo#STATUS_RECOVERY}</li> <li>
     * {@link com.vmware.nsx_policy.model.CrossSiteFlowInfo#STATUS_ERROR}</li> <li>
     * {@link com.vmware.nsx_policy.model.CrossSiteFlowInfo#STATUS_UNKNOWN}</li> <li>
     * {@link com.vmware.nsx_policy.model.CrossSiteFlowInfo#STATUS_NOT_READY}</li>
     * </ul> Overall status of the flow
     *
     * @param status New value for the property.
     */
    public void setStatus(java.lang.String status) {
        this.status = status;
    }

    /**
     * Site id of the destination
     *
     * @return The current value of the property.
     */
    public java.lang.String getToSiteId() {
        return this.toSiteId;
    }

    /**
     * Site id of the destination
     *
     * @param toSiteId New value for the property.
     */
    public void setToSiteId(java.lang.String toSiteId) {
        this.toSiteId = toSiteId;
    }

    /**
     * Destination site policy path
     *
     * @return The current value of the property.
     */
    public java.lang.String getToSitePath() {
        return this.toSitePath;
    }

    /**
     * Destination site policy path
     *
     * @param toSitePath New value for the property.
     */
    public void setToSitePath(java.lang.String toSitePath) {
        this.toSitePath = toSitePath;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.crossSiteFlowInfo;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("from_site_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.fromSiteId, this._getType().getField("from_site_id")));
        structValue.setField("from_site_path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.fromSitePath, this._getType().getField("from_site_path")));
        structValue.setField("full_sync_info",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.fullSyncInfo, this._getType().getField("full_sync_info")));
        structValue.setField("latency_measured_ts",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.latencyMeasuredTs, this._getType().getField("latency_measured_ts")));
        structValue.setField("latency_millis",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.latencyMillis, this._getType().getField("latency_millis")));
        structValue.setField("leader_node_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.leaderNodeId, this._getType().getField("leader_node_id")));
        structValue.setField("status",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.status, this._getType().getField("status")));
        structValue.setField("to_site_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.toSiteId, this._getType().getField("to_site_id")));
        structValue.setField("to_site_path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.toSitePath, this._getType().getField("to_site_path")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.crossSiteFlowInfo;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.crossSiteFlowInfo.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static CrossSiteFlowInfo _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new CrossSiteFlowInfo(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static CrossSiteFlowInfo _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new CrossSiteFlowInfo(structValue);
    }

    /**
     * Builder class for {@link CrossSiteFlowInfo}.
     */
    public static final class Builder {
        private java.lang.String fromSiteId;
        private java.lang.String fromSitePath;
        private com.vmware.nsx_policy.model.FullSyncInfo fullSyncInfo;
        private java.lang.Long latencyMeasuredTs;
        private java.lang.Long latencyMillis;
        private java.lang.String leaderNodeId;
        private java.lang.String status;
        private java.lang.String toSiteId;
        private java.lang.String toSitePath;

        /**
         * Constructor with parameters for the required properties of
         * {@link CrossSiteFlowInfo}.
         */
        public Builder() {
        }

        /**
         * Site id of the source
         *
         * @param fromSiteId New value for the property.
         */
        public Builder setFromSiteId(java.lang.String fromSiteId) {
            this.fromSiteId = fromSiteId;
            return this;
        }

        /**
         * Source site policy path
         *
         * @param fromSitePath New value for the property.
         */
        public Builder setFromSitePath(java.lang.String fromSitePath) {
            this.fromSitePath = fromSitePath;
            return this;
        }

        /**
         *
         *
         * @param fullSyncInfo New value for the property.
         */
        public Builder setFullSyncInfo(com.vmware.nsx_policy.model.FullSyncInfo fullSyncInfo) {
            this.fullSyncInfo = fullSyncInfo;
            return this;
        }

        /**
         * Timestamp of latency measurement format: int64
         *
         * @param latencyMeasuredTs New value for the property.
         */
        public Builder setLatencyMeasuredTs(java.lang.Long latencyMeasuredTs) {
            this.latencyMeasuredTs = latencyMeasuredTs;
            return this;
        }

        /**
         * Latency from source to destination site in milli seconds format: int64
         *
         * @param latencyMillis New value for the property.
         */
        public Builder setLatencyMillis(java.lang.Long latencyMillis) {
            this.latencyMillis = latencyMillis;
            return this;
        }

        /**
         * Local leader node id sharded for this remote site.
         *
         * @param leaderNodeId New value for the property.
         */
        public Builder setLeaderNodeId(java.lang.String leaderNodeId) {
            this.leaderNodeId = leaderNodeId;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.CrossSiteFlowInfo#STATUS_GOOD}</li> <li> {@link
         * com.vmware.nsx_policy.model.CrossSiteFlowInfo#STATUS_DISCONNECTED}</li> <li>
         * {@link com.vmware.nsx_policy.model.CrossSiteFlowInfo#STATUS_RECOVERY}</li> <li>
         * {@link com.vmware.nsx_policy.model.CrossSiteFlowInfo#STATUS_ERROR}</li> <li>
         * {@link com.vmware.nsx_policy.model.CrossSiteFlowInfo#STATUS_UNKNOWN}</li> <li>
         * {@link com.vmware.nsx_policy.model.CrossSiteFlowInfo#STATUS_NOT_READY}</li>
         * </ul> Overall status of the flow
         *
         * @param status New value for the property.
         */
        public Builder setStatus(java.lang.String status) {
            this.status = status;
            return this;
        }

        /**
         * Site id of the destination
         *
         * @param toSiteId New value for the property.
         */
        public Builder setToSiteId(java.lang.String toSiteId) {
            this.toSiteId = toSiteId;
            return this;
        }

        /**
         * Destination site policy path
         *
         * @param toSitePath New value for the property.
         */
        public Builder setToSitePath(java.lang.String toSitePath) {
            this.toSitePath = toSitePath;
            return this;
        }

        public CrossSiteFlowInfo build() {
            CrossSiteFlowInfo result = new CrossSiteFlowInfo();
            result.setFromSiteId(this.fromSiteId);
            result.setFromSitePath(this.fromSitePath);
            result.setFullSyncInfo(this.fullSyncInfo);
            result.setLatencyMeasuredTs(this.latencyMeasuredTs);
            result.setLatencyMillis(this.latencyMillis);
            result.setLeaderNodeId(this.leaderNodeId);
            result.setStatus(this.status);
            result.setToSiteId(this.toSiteId);
            result.setToSitePath(this.toSitePath);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("from_site_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("from_site_id",
                                                                                "fromSiteId",
                                                                                "getFromSiteId",
                                                                                "setFromSiteId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("from_site_path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("from_site_path",
                                                                                "fromSitePath",
                                                                                "getFromSitePath",
                                                                                "setFromSitePath");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("full_sync_info", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.fullSyncInfo; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("full_sync_info",
                                                                                "fullSyncInfo",
                                                                                "getFullSyncInfo",
                                                                                "setFullSyncInfo");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("latency_measured_ts", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("latency_measured_ts",
                                                                                "latencyMeasuredTs",
                                                                                "getLatencyMeasuredTs",
                                                                                "setLatencyMeasuredTs");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("latency_millis", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("latency_millis",
                                                                                "latencyMillis",
                                                                                "getLatencyMillis",
                                                                                "setLatencyMillis");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("leader_node_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("leader_node_id",
                                                                                "leaderNodeId",
                                                                                "getLeaderNodeId",
                                                                                "setLeaderNodeId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("status", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("status",
                                                                                "status",
                                                                                "getStatus",
                                                                                "setStatus");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("to_site_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("to_site_id",
                                                                                "toSiteId",
                                                                                "getToSiteId",
                                                                                "setToSiteId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("to_site_path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("to_site_path",
                                                                                "toSitePath",
                                                                                "getToSitePath",
                                                                                "setToSitePath");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.cross_site_flow_info",
                                                            fields,
                                                            com.vmware.nsx_policy.model.CrossSiteFlowInfo.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

