/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * Host Switch State
 */
public final class HostSwitchState implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String HOST_SWITCH_TYPE_NVDS = "NVDS";

    public static final java.lang.String HOST_SWITCH_TYPE_VDS = "VDS";

    private java.util.List<com.vmware.nsx_policy.model.Endpoint> endpoints;

    private java.lang.String hostSwitchId;

    private java.lang.String hostSwitchName;

    private java.lang.String hostSwitchType;

    private java.util.List<java.lang.String> transportZoneIds;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public HostSwitchState() {
    }

    protected HostSwitchState(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * List of virtual tunnel endpoints which are configured on this switch
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx_policy.model.Endpoint> getEndpoints() {
        return this.endpoints;
    }

    /**
     * List of virtual tunnel endpoints which are configured on this switch
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param endpoints New value for the property.
     */
    public void setEndpoints(java.util.List<com.vmware.nsx_policy.model.Endpoint> endpoints) {
        this.endpoints = endpoints;
    }

    /**
     * External ID of the HostSwitch
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getHostSwitchId() {
        return this.hostSwitchId;
    }

    /**
     * External ID of the HostSwitch
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param hostSwitchId New value for the property.
     */
    public void setHostSwitchId(java.lang.String hostSwitchId) {
        this.hostSwitchId = hostSwitchId;
    }

    /**
     * The name must be unique among all host switches specified in a given Transport
     * Node.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getHostSwitchName() {
        return this.hostSwitchName;
    }

    /**
     * The name must be unique among all host switches specified in a given Transport
     * Node.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param hostSwitchName New value for the property.
     */
    public void setHostSwitchName(java.lang.String hostSwitchName) {
        this.hostSwitchName = hostSwitchName;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.HostSwitchState#HOST_SWITCH_TYPE_NVDS}</li> <li>
     * {@link com.vmware.nsx_policy.model.HostSwitchState#HOST_SWITCH_TYPE_VDS}</li>
     * </ul> VDS represents VMware vSphere Distributed Switch from vSphere that is used
     * as HostSwitch through TransportNode or TransportNodeProfile configuration. When
     * VDS is used as a HostSwitch, Hosts have to be added to VDS from vSphere and VDS
     * instance is created on Hosts. To configure NSX on such hosts, you can use this
     * VDS as a HostSwitch from NSX manager. vCenter has the ownership of MTU, LAG,
     * NIOC and LLDP configuration of such VDS backed HostSwitch. Remaining
     * configuration (e.g. UplinkHostswitchProfile) will be managed by NSX. NVDS
     * represents NSX Virtual Switch which is NSX native HostSwitch. All configurations
     * of NVDS will be managed by NSX.
     *
     * @return The current value of the property.
     */
    public java.lang.String getHostSwitchType() {
        return this.hostSwitchType;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.HostSwitchState#HOST_SWITCH_TYPE_NVDS}</li> <li>
     * {@link com.vmware.nsx_policy.model.HostSwitchState#HOST_SWITCH_TYPE_VDS}</li>
     * </ul> VDS represents VMware vSphere Distributed Switch from vSphere that is used
     * as HostSwitch through TransportNode or TransportNodeProfile configuration. When
     * VDS is used as a HostSwitch, Hosts have to be added to VDS from vSphere and VDS
     * instance is created on Hosts. To configure NSX on such hosts, you can use this
     * VDS as a HostSwitch from NSX manager. vCenter has the ownership of MTU, LAG,
     * NIOC and LLDP configuration of such VDS backed HostSwitch. Remaining
     * configuration (e.g. UplinkHostswitchProfile) will be managed by NSX. NVDS
     * represents NSX Virtual Switch which is NSX native HostSwitch. All configurations
     * of NVDS will be managed by NSX.
     *
     * @param hostSwitchType New value for the property.
     */
    public void setHostSwitchType(java.lang.String hostSwitchType) {
        this.hostSwitchType = hostSwitchType;
    }

    /**
     * List of Ids of TransportZones this HostSwitch belongs to
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getTransportZoneIds() {
        return this.transportZoneIds;
    }

    /**
     * List of Ids of TransportZones this HostSwitch belongs to
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param transportZoneIds New value for the property.
     */
    public void setTransportZoneIds(java.util.List<java.lang.String> transportZoneIds) {
        this.transportZoneIds = transportZoneIds;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.hostSwitchState;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("endpoints",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.endpoints, this._getType().getField("endpoints")));
        structValue.setField("host_switch_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.hostSwitchId, this._getType().getField("host_switch_id")));
        structValue.setField("host_switch_name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.hostSwitchName, this._getType().getField("host_switch_name")));
        structValue.setField("host_switch_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.hostSwitchType, this._getType().getField("host_switch_type")));
        structValue.setField("transport_zone_ids",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.transportZoneIds, this._getType().getField("transport_zone_ids")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.hostSwitchState;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.hostSwitchState.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static HostSwitchState _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new HostSwitchState(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static HostSwitchState _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new HostSwitchState(structValue);
    }

    /**
     * Builder class for {@link HostSwitchState}.
     */
    public static final class Builder {
        private java.util.List<com.vmware.nsx_policy.model.Endpoint> endpoints;
        private java.lang.String hostSwitchId;
        private java.lang.String hostSwitchName;
        private java.lang.String hostSwitchType;
        private java.util.List<java.lang.String> transportZoneIds;

        /**
         * Constructor with parameters for the required properties of
         * {@link HostSwitchState}.
         */
        public Builder() {
        }

        /**
         * List of virtual tunnel endpoints which are configured on this switch
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param endpoints New value for the property.
         */
        public Builder setEndpoints(java.util.List<com.vmware.nsx_policy.model.Endpoint> endpoints) {
            this.endpoints = endpoints;
            return this;
        }

        /**
         * External ID of the HostSwitch
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param hostSwitchId New value for the property.
         */
        public Builder setHostSwitchId(java.lang.String hostSwitchId) {
            this.hostSwitchId = hostSwitchId;
            return this;
        }

        /**
         * The name must be unique among all host switches specified in a given Transport
         * Node.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param hostSwitchName New value for the property.
         */
        public Builder setHostSwitchName(java.lang.String hostSwitchName) {
            this.hostSwitchName = hostSwitchName;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.HostSwitchState#HOST_SWITCH_TYPE_NVDS}</li> <li>
         * {@link com.vmware.nsx_policy.model.HostSwitchState#HOST_SWITCH_TYPE_VDS}</li>
         * </ul> VDS represents VMware vSphere Distributed Switch from vSphere that is used
         * as HostSwitch through TransportNode or TransportNodeProfile configuration. When
         * VDS is used as a HostSwitch, Hosts have to be added to VDS from vSphere and VDS
         * instance is created on Hosts. To configure NSX on such hosts, you can use this
         * VDS as a HostSwitch from NSX manager. vCenter has the ownership of MTU, LAG,
         * NIOC and LLDP configuration of such VDS backed HostSwitch. Remaining
         * configuration (e.g. UplinkHostswitchProfile) will be managed by NSX. NVDS
         * represents NSX Virtual Switch which is NSX native HostSwitch. All configurations
         * of NVDS will be managed by NSX.
         *
         * @param hostSwitchType New value for the property.
         */
        public Builder setHostSwitchType(java.lang.String hostSwitchType) {
            this.hostSwitchType = hostSwitchType;
            return this;
        }

        /**
         * List of Ids of TransportZones this HostSwitch belongs to
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param transportZoneIds New value for the property.
         */
        public Builder setTransportZoneIds(java.util.List<java.lang.String> transportZoneIds) {
            this.transportZoneIds = transportZoneIds;
            return this;
        }

        public HostSwitchState build() {
            HostSwitchState result = new HostSwitchState();
            result.setEndpoints(this.endpoints);
            result.setHostSwitchId(this.hostSwitchId);
            result.setHostSwitchName(this.hostSwitchName);
            result.setHostSwitchType(this.hostSwitchType);
            result.setTransportZoneIds(this.transportZoneIds);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("endpoints", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.endpoint; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("endpoints",
                                                                                "endpoints",
                                                                                "getEndpoints",
                                                                                "setEndpoints");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("host_switch_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("host_switch_id",
                                                                                "hostSwitchId",
                                                                                "getHostSwitchId",
                                                                                "setHostSwitchId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("host_switch_name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("host_switch_name",
                                                                                "hostSwitchName",
                                                                                "getHostSwitchName",
                                                                                "setHostSwitchName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("host_switch_type", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("host_switch_type",
                                                                                "hostSwitchType",
                                                                                "getHostSwitchType",
                                                                                "setHostSwitchType");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("transport_zone_ids", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("transport_zone_ids",
                                                                                "transportZoneIds",
                                                                                "getTransportZoneIds",
                                                                                "setTransportZoneIds");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.host_switch_state",
                                                            fields,
                                                            com.vmware.nsx_policy.model.HostSwitchState.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

