/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * IPv6 virtual tunnel end point
 */
public final class IPv6EndPoint implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.lang.String defaultGateway;

    private java.lang.String ipv6;

    private java.lang.String prefixLength;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public IPv6EndPoint() {
    }

    protected IPv6EndPoint(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Default gateway for IPv6 format: ip
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getDefaultGateway() {
        return this.defaultGateway;
    }

    /**
     * Default gateway for IPv6 format: ip
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param defaultGateway New value for the property.
     */
    public void setDefaultGateway(java.lang.String defaultGateway) {
        this.defaultGateway = defaultGateway;
    }

    /**
     * Depending upon the EndpointIpConfig used in HostSwitch, IP could be allocated
     * either from DHCP (default) or from Static IP Pool. format: ip
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getIpv6() {
        return this.ipv6;
    }

    /**
     * Depending upon the EndpointIpConfig used in HostSwitch, IP could be allocated
     * either from DHCP (default) or from Static IP Pool. format: ip
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param ipv6 New value for the property.
     */
    public void setIpv6(java.lang.String ipv6) {
        this.ipv6 = ipv6;
    }

    /**
     * Prefix length for IPv6
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getPrefixLength() {
        return this.prefixLength;
    }

    /**
     * Prefix length for IPv6
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param prefixLength New value for the property.
     */
    public void setPrefixLength(java.lang.String prefixLength) {
        this.prefixLength = prefixLength;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.IPv6EndPoint;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("default_gateway",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.defaultGateway, this._getType().getField("default_gateway")));
        structValue.setField("ipv6",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ipv6, this._getType().getField("ipv6")));
        structValue.setField("prefix_length",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.prefixLength, this._getType().getField("prefix_length")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.IPv6EndPoint;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.IPv6EndPoint.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static IPv6EndPoint _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new IPv6EndPoint(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static IPv6EndPoint _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new IPv6EndPoint(structValue);
    }

    /**
     * Builder class for {@link IPv6EndPoint}.
     */
    public static final class Builder {
        private java.lang.String defaultGateway;
        private java.lang.String ipv6;
        private java.lang.String prefixLength;

        /**
         * Constructor with parameters for the required properties of
         * {@link IPv6EndPoint}.
         */
        public Builder() {
        }

        /**
         * Default gateway for IPv6 format: ip
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param defaultGateway New value for the property.
         */
        public Builder setDefaultGateway(java.lang.String defaultGateway) {
            this.defaultGateway = defaultGateway;
            return this;
        }

        /**
         * Depending upon the EndpointIpConfig used in HostSwitch, IP could be allocated
         * either from DHCP (default) or from Static IP Pool. format: ip
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param ipv6 New value for the property.
         */
        public Builder setIpv6(java.lang.String ipv6) {
            this.ipv6 = ipv6;
            return this;
        }

        /**
         * Prefix length for IPv6
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param prefixLength New value for the property.
         */
        public Builder setPrefixLength(java.lang.String prefixLength) {
            this.prefixLength = prefixLength;
            return this;
        }

        public IPv6EndPoint build() {
            IPv6EndPoint result = new IPv6EndPoint();
            result.setDefaultGateway(this.defaultGateway);
            result.setIpv6(this.ipv6);
            result.setPrefixLength(this.prefixLength);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("default_gateway", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("default_gateway",
                                                                                "defaultGateway",
                                                                                "getDefaultGateway",
                                                                                "setDefaultGateway");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ipv6", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ipv6",
                                                                                "ipv6",
                                                                                "getIpv6",
                                                                                "setIpv6");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("prefix_length", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("prefix_length",
                                                                                "prefixLength",
                                                                                "getPrefixLength",
                                                                                "setPrefixLength");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.I_pv6_end_point",
                                                            fields,
                                                            com.vmware.nsx_policy.model.IPv6EndPoint.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

