/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * L2VPN Session Status represents status on an NSX-T type of enforcement point.
 */
public final class L2VPNSessionStatusNsxt implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    /**
     * Identifier denoting this class, when it is used in polymorphic context. 
     * <p>This
     * value should be assigned to the property which is used to discriminate the
     * actual type used in the polymorphic context.</p>
     */
    public static final java.lang.String _TYPE_IDENTIFIER = "L2VPNSessionStatusNsxT";

    public static final java.lang.String RUNTIME_STATUS_UP = "UP";

    public static final java.lang.String RUNTIME_STATUS_DOWN = "DOWN";

    private java.lang.String displayName;

    private java.lang.String runtimeStatus;

    private java.util.List<com.vmware.vapi.bindings.Structure> transportTunnels;

    private com.vmware.nsx_policy.model.PolicyRuntimeAlarm alarm;

    private java.lang.String enforcementPointPath;

    private final java.lang.String resourceType = "L2VPNSessionStatusNsxT";

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public L2VPNSessionStatusNsxt() {
    }

    protected L2VPNSessionStatusNsxt(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Display name of l2vpn session.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getDisplayName() {
        return this.displayName;
    }

    /**
     * Display name of l2vpn session.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param displayName New value for the property.
     */
    public void setDisplayName(java.lang.String displayName) {
        this.displayName = displayName;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.L2VPNSessionStatusNsxt#RUNTIME_STATUS_UP}</li> <li>
     * {@link
     * com.vmware.nsx_policy.model.L2VPNSessionStatusNsxt#RUNTIME_STATUS_DOWN}</li>
     * </ul> L2 VPN session status, specifies UP/DOWN.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getRuntimeStatus() {
        return this.runtimeStatus;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.L2VPNSessionStatusNsxt#RUNTIME_STATUS_UP}</li> <li>
     * {@link
     * com.vmware.nsx_policy.model.L2VPNSessionStatusNsxt#RUNTIME_STATUS_DOWN}</li>
     * </ul> L2 VPN session status, specifies UP/DOWN.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param runtimeStatus New value for the property.
     */
    public void setRuntimeStatus(java.lang.String runtimeStatus) {
        this.runtimeStatus = runtimeStatus;
    }

    /**
     * Transport tunnels status.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     * When clients pass a value of this class as a parameter, the property must
     * contain all the properties defined in {@link
     * com.vmware.nsx_policy.model.L2VPNSessionTransportTunnelStatus}. When methods
     * return a value of this class as a return value, the property will contain all
     * the properties defined in {@link
     * com.vmware.nsx_policy.model.L2VPNSessionTransportTunnelStatus}.
     */
    public java.util.List<com.vmware.vapi.bindings.Structure> getTransportTunnels() {
        return this.transportTunnels;
    }

    /**
     * Transport tunnels status.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param transportTunnels New value for the property.
     * When clients pass a value of this class as a parameter, the property must
     * contain all the properties defined in {@link
     * com.vmware.nsx_policy.model.L2VPNSessionTransportTunnelStatus}. When methods
     * return a value of this class as a return value, the property will contain all
     * the properties defined in {@link
     * com.vmware.nsx_policy.model.L2VPNSessionTransportTunnelStatus}.
     */
    public void setTransportTunnels(java.util.List<com.vmware.vapi.bindings.Structure> transportTunnels) {
        this.transportTunnels = transportTunnels;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx_policy.model.PolicyRuntimeAlarm getAlarm() {
        return this.alarm;
    }

    /**
     *
     *
     * @param alarm New value for the property.
     */
    public void setAlarm(com.vmware.nsx_policy.model.PolicyRuntimeAlarm alarm) {
        this.alarm = alarm;
    }

    /**
     * Policy Path referencing the enforcement point where the info is fetched.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getEnforcementPointPath() {
        return this.enforcementPointPath;
    }

    /**
     * Policy Path referencing the enforcement point where the info is fetched.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param enforcementPointPath New value for the property.
     */
    public void setEnforcementPointPath(java.lang.String enforcementPointPath) {
        this.enforcementPointPath = enforcementPointPath;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.L2VPNSessionStatusPerEP#RESOURCE_TYPE_L2VPNSESSIONSTATUSNSXT}</li>
     * </ul>
     * The value of this property is automatically populated to {@code "L2VPNSessionStatusNsxT"}.
     *
     * @return The current value of the property.
     */
    public java.lang.String getResourceType() {
        return this.resourceType;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.l2VPNSessionStatusNsxt;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("display_name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.displayName, this._getType().getField("display_name")));
        structValue.setField("runtime_status",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.runtimeStatus, this._getType().getField("runtime_status")));
        structValue.setField("transport_tunnels",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.transportTunnels, this._getType().getField("transport_tunnels")));
        structValue.setField("alarm",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.alarm, this._getType().getField("alarm")));
        structValue.setField("enforcement_point_path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.enforcementPointPath, this._getType().getField("enforcement_point_path")));
        structValue.setField("resource_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.resourceType, this._getType().getField("resource_type")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.l2VPNSessionStatusNsxt;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.l2VPNSessionStatusNsxt.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static L2VPNSessionStatusNsxt _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new L2VPNSessionStatusNsxt(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static L2VPNSessionStatusNsxt _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new L2VPNSessionStatusNsxt(structValue);
    }

    /**
     * Builder class for {@link L2VPNSessionStatusNsxt}.
     */
    public static final class Builder {
        private java.lang.String displayName;
        private java.lang.String runtimeStatus;
        private java.util.List<com.vmware.vapi.bindings.Structure> transportTunnels;
        private com.vmware.nsx_policy.model.PolicyRuntimeAlarm alarm;
        private java.lang.String enforcementPointPath;

        /**
         * Constructor with parameters for the required properties of
         * {@link L2VPNSessionStatusNsxt}.
         */
        public Builder() {
        }

        /**
         * Display name of l2vpn session.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param displayName New value for the property.
         */
        public Builder setDisplayName(java.lang.String displayName) {
            this.displayName = displayName;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.L2VPNSessionStatusNsxt#RUNTIME_STATUS_UP}</li> <li>
         * {@link
         * com.vmware.nsx_policy.model.L2VPNSessionStatusNsxt#RUNTIME_STATUS_DOWN}</li>
         * </ul> L2 VPN session status, specifies UP/DOWN.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param runtimeStatus New value for the property.
         */
        public Builder setRuntimeStatus(java.lang.String runtimeStatus) {
            this.runtimeStatus = runtimeStatus;
            return this;
        }

        /**
         * Transport tunnels status.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param transportTunnels New value for the property.
         * When clients pass a value of this class as a parameter, the property must
         * contain all the properties defined in {@link
         * com.vmware.nsx_policy.model.L2VPNSessionTransportTunnelStatus}. When methods
         * return a value of this class as a return value, the property will contain all
         * the properties defined in {@link
         * com.vmware.nsx_policy.model.L2VPNSessionTransportTunnelStatus}.
         */
        public Builder setTransportTunnels(java.util.List<com.vmware.vapi.bindings.Structure> transportTunnels) {
            this.transportTunnels = transportTunnels;
            return this;
        }

        /**
         *
         *
         * @param alarm New value for the property.
         */
        public Builder setAlarm(com.vmware.nsx_policy.model.PolicyRuntimeAlarm alarm) {
            this.alarm = alarm;
            return this;
        }

        /**
         * Policy Path referencing the enforcement point where the info is fetched.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param enforcementPointPath New value for the property.
         */
        public Builder setEnforcementPointPath(java.lang.String enforcementPointPath) {
            this.enforcementPointPath = enforcementPointPath;
            return this;
        }

        public L2VPNSessionStatusNsxt build() {
            L2VPNSessionStatusNsxt result = new L2VPNSessionStatusNsxt();
            result.setDisplayName(this.displayName);
            result.setRuntimeStatus(this.runtimeStatus);
            result.setTransportTunnels(this.transportTunnels);
            result.setAlarm(this.alarm);
            result.setEnforcementPointPath(this.enforcementPointPath);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("display_name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("display_name",
                                                                                "displayName",
                                                                                "getDisplayName",
                                                                                "setDisplayName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("runtime_status", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("runtime_status",
                                                                                "runtimeStatus",
                                                                                "getRuntimeStatus",
                                                                                "setRuntimeStatus");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("transport_tunnels", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.DynamicStructType(java.util.Arrays.<com.vmware.vapi.internal.data.ConstraintValidator>asList(new com.vmware.vapi.internal.bindings.HasFieldsOfValidator(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.l2VPNSessionTransportTunnelStatus; } }))))));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("transport_tunnels",
                                                                                "transportTunnels",
                                                                                "getTransportTunnels",
                                                                                "setTransportTunnels");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("alarm", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.policyRuntimeAlarm; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("alarm",
                                                                                "alarm",
                                                                                "getAlarm",
                                                                                "setAlarm");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("enforcement_point_path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("enforcement_point_path",
                                                                                "enforcementPointPath",
                                                                                "getEnforcementPointPath",
                                                                                "setEnforcementPointPath");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("resource_type", new com.vmware.vapi.bindings.type.StringType());
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("resource_type",
                                                                                "resourceType",
                                                                                "getResourceType",
                                                                                null);
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.l2_VPN_session_status_nsxt",
                                                            fields,
                                                            com.vmware.nsx_policy.model.L2VPNSessionStatusNsxt.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            "resource_type",
                                                            "L2VPNSessionStatusNsxT");
    }
}

