/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * Client SSL profile binding. LBClientSslProfileBinding is deprecated as NSX-T
 * Load Balancer is deprecated.
 */
public final class LBClientSslProfileBinding implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String CLIENT_AUTH_REQUIRED = "REQUIRED";

    public static final java.lang.String CLIENT_AUTH_IGNORE = "IGNORE";

    private java.lang.Long certificateChainDepth;

    private java.lang.String clientAuth;

    private java.util.List<java.lang.String> clientAuthCaPaths;

    private java.util.List<java.lang.String> clientAuthCrlPaths;

    private java.lang.String defaultCertificatePath;

    private java.util.List<java.lang.String> sniCertificatePaths;

    private java.lang.String sslProfilePath;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public LBClientSslProfileBinding() {
    }

    protected LBClientSslProfileBinding(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Authentication depth is used to set the verification depth in the client
     * certificates chain. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getCertificateChainDepth() {
        return this.certificateChainDepth;
    }

    /**
     * Authentication depth is used to set the verification depth in the client
     * certificates chain. format: int64
     *
     * @param certificateChainDepth New value for the property.
     */
    public void setCertificateChainDepth(java.lang.Long certificateChainDepth) {
        this.certificateChainDepth = certificateChainDepth;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.LBClientSslProfileBinding#CLIENT_AUTH_REQUIRED}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LBClientSslProfileBinding#CLIENT_AUTH_IGNORE}</li>
     * </ul> Client authentication mode.
     *
     * @return The current value of the property.
     */
    public java.lang.String getClientAuth() {
        return this.clientAuth;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.LBClientSslProfileBinding#CLIENT_AUTH_REQUIRED}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LBClientSslProfileBinding#CLIENT_AUTH_IGNORE}</li>
     * </ul> Client authentication mode.
     *
     * @param clientAuth New value for the property.
     */
    public void setClientAuth(java.lang.String clientAuth) {
        this.clientAuth = clientAuth;
    }

    /**
     * If client auth type is REQUIRED, client certificate must be signed by one of the
     * trusted Certificate Authorities (CAs), also referred to as root CAs, whose self
     * signed certificates are specified.
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getClientAuthCaPaths() {
        return this.clientAuthCaPaths;
    }

    /**
     * If client auth type is REQUIRED, client certificate must be signed by one of the
     * trusted Certificate Authorities (CAs), also referred to as root CAs, whose self
     * signed certificates are specified.
     *
     * @param clientAuthCaPaths New value for the property.
     */
    public void setClientAuthCaPaths(java.util.List<java.lang.String> clientAuthCaPaths) {
        this.clientAuthCaPaths = clientAuthCaPaths;
    }

    /**
     * A Certificate Revocation List (CRL) can be specified in the client-side SSL
     * profile binding to disallow compromised client certificates.
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getClientAuthCrlPaths() {
        return this.clientAuthCrlPaths;
    }

    /**
     * A Certificate Revocation List (CRL) can be specified in the client-side SSL
     * profile binding to disallow compromised client certificates.
     *
     * @param clientAuthCrlPaths New value for the property.
     */
    public void setClientAuthCrlPaths(java.util.List<java.lang.String> clientAuthCrlPaths) {
        this.clientAuthCrlPaths = clientAuthCrlPaths;
    }

    /**
     * A default certificate should be specified which will be used if the server does
     * not host multiple hostnames on the same IP address or if the client does not
     * support SNI extension.
     *
     * @return The current value of the property.
     */
    public java.lang.String getDefaultCertificatePath() {
        return this.defaultCertificatePath;
    }

    /**
     * A default certificate should be specified which will be used if the server does
     * not host multiple hostnames on the same IP address or if the client does not
     * support SNI extension.
     *
     * @param defaultCertificatePath New value for the property.
     */
    public void setDefaultCertificatePath(java.lang.String defaultCertificatePath) {
        this.defaultCertificatePath = defaultCertificatePath;
    }

    /**
     * Client-side SSL profile binding allows multiple certificates, for different
     * hostnames, to be bound to the same virtual server.
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getSniCertificatePaths() {
        return this.sniCertificatePaths;
    }

    /**
     * Client-side SSL profile binding allows multiple certificates, for different
     * hostnames, to be bound to the same virtual server.
     *
     * @param sniCertificatePaths New value for the property.
     */
    public void setSniCertificatePaths(java.util.List<java.lang.String> sniCertificatePaths) {
        this.sniCertificatePaths = sniCertificatePaths;
    }

    /**
     * Client SSL profile defines reusable, application-independent client side SSL
     * properties.
     *
     * @return The current value of the property.
     */
    public java.lang.String getSslProfilePath() {
        return this.sslProfilePath;
    }

    /**
     * Client SSL profile defines reusable, application-independent client side SSL
     * properties.
     *
     * @param sslProfilePath New value for the property.
     */
    public void setSslProfilePath(java.lang.String sslProfilePath) {
        this.sslProfilePath = sslProfilePath;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.LBClientSslProfileBinding;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("certificate_chain_depth",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.certificateChainDepth, this._getType().getField("certificate_chain_depth")));
        structValue.setField("client_auth",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.clientAuth, this._getType().getField("client_auth")));
        structValue.setField("client_auth_ca_paths",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.clientAuthCaPaths, this._getType().getField("client_auth_ca_paths")));
        structValue.setField("client_auth_crl_paths",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.clientAuthCrlPaths, this._getType().getField("client_auth_crl_paths")));
        structValue.setField("default_certificate_path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.defaultCertificatePath, this._getType().getField("default_certificate_path")));
        structValue.setField("sni_certificate_paths",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.sniCertificatePaths, this._getType().getField("sni_certificate_paths")));
        structValue.setField("ssl_profile_path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.sslProfilePath, this._getType().getField("ssl_profile_path")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.LBClientSslProfileBinding;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.LBClientSslProfileBinding.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static LBClientSslProfileBinding _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new LBClientSslProfileBinding(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static LBClientSslProfileBinding _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new LBClientSslProfileBinding(structValue);
    }

    /**
     * Builder class for {@link LBClientSslProfileBinding}.
     */
    public static final class Builder {
        private java.lang.Long certificateChainDepth;
        private java.lang.String clientAuth;
        private java.util.List<java.lang.String> clientAuthCaPaths;
        private java.util.List<java.lang.String> clientAuthCrlPaths;
        private java.lang.String defaultCertificatePath;
        private java.util.List<java.lang.String> sniCertificatePaths;
        private java.lang.String sslProfilePath;

        /**
         * Constructor with parameters for the required properties of
         * {@link LBClientSslProfileBinding}.
         */
        public Builder() {
        }

        /**
         * Authentication depth is used to set the verification depth in the client
         * certificates chain. format: int64
         *
         * @param certificateChainDepth New value for the property.
         */
        public Builder setCertificateChainDepth(java.lang.Long certificateChainDepth) {
            this.certificateChainDepth = certificateChainDepth;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.LBClientSslProfileBinding#CLIENT_AUTH_REQUIRED}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.LBClientSslProfileBinding#CLIENT_AUTH_IGNORE}</li>
         * </ul> Client authentication mode.
         *
         * @param clientAuth New value for the property.
         */
        public Builder setClientAuth(java.lang.String clientAuth) {
            this.clientAuth = clientAuth;
            return this;
        }

        /**
         * If client auth type is REQUIRED, client certificate must be signed by one of the
         * trusted Certificate Authorities (CAs), also referred to as root CAs, whose self
         * signed certificates are specified.
         *
         * @param clientAuthCaPaths New value for the property.
         */
        public Builder setClientAuthCaPaths(java.util.List<java.lang.String> clientAuthCaPaths) {
            this.clientAuthCaPaths = clientAuthCaPaths;
            return this;
        }

        /**
         * A Certificate Revocation List (CRL) can be specified in the client-side SSL
         * profile binding to disallow compromised client certificates.
         *
         * @param clientAuthCrlPaths New value for the property.
         */
        public Builder setClientAuthCrlPaths(java.util.List<java.lang.String> clientAuthCrlPaths) {
            this.clientAuthCrlPaths = clientAuthCrlPaths;
            return this;
        }

        /**
         * A default certificate should be specified which will be used if the server does
         * not host multiple hostnames on the same IP address or if the client does not
         * support SNI extension.
         *
         * @param defaultCertificatePath New value for the property.
         */
        public Builder setDefaultCertificatePath(java.lang.String defaultCertificatePath) {
            this.defaultCertificatePath = defaultCertificatePath;
            return this;
        }

        /**
         * Client-side SSL profile binding allows multiple certificates, for different
         * hostnames, to be bound to the same virtual server.
         *
         * @param sniCertificatePaths New value for the property.
         */
        public Builder setSniCertificatePaths(java.util.List<java.lang.String> sniCertificatePaths) {
            this.sniCertificatePaths = sniCertificatePaths;
            return this;
        }

        /**
         * Client SSL profile defines reusable, application-independent client side SSL
         * properties.
         *
         * @param sslProfilePath New value for the property.
         */
        public Builder setSslProfilePath(java.lang.String sslProfilePath) {
            this.sslProfilePath = sslProfilePath;
            return this;
        }

        public LBClientSslProfileBinding build() {
            LBClientSslProfileBinding result = new LBClientSslProfileBinding();
            result.setCertificateChainDepth(this.certificateChainDepth);
            result.setClientAuth(this.clientAuth);
            result.setClientAuthCaPaths(this.clientAuthCaPaths);
            result.setClientAuthCrlPaths(this.clientAuthCrlPaths);
            result.setDefaultCertificatePath(this.defaultCertificatePath);
            result.setSniCertificatePaths(this.sniCertificatePaths);
            result.setSslProfilePath(this.sslProfilePath);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("certificate_chain_depth", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("certificate_chain_depth",
                                                                                "certificateChainDepth",
                                                                                "getCertificateChainDepth",
                                                                                "setCertificateChainDepth");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("client_auth", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("client_auth",
                                                                                "clientAuth",
                                                                                "getClientAuth",
                                                                                "setClientAuth");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("client_auth_ca_paths", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("client_auth_ca_paths",
                                                                                "clientAuthCaPaths",
                                                                                "getClientAuthCaPaths",
                                                                                "setClientAuthCaPaths");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("client_auth_crl_paths", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("client_auth_crl_paths",
                                                                                "clientAuthCrlPaths",
                                                                                "getClientAuthCrlPaths",
                                                                                "setClientAuthCrlPaths");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("default_certificate_path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("default_certificate_path",
                                                                                "defaultCertificatePath",
                                                                                "getDefaultCertificatePath",
                                                                                "setDefaultCertificatePath");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("sni_certificate_paths", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("sni_certificate_paths",
                                                                                "sniCertificatePaths",
                                                                                "getSniCertificatePaths",
                                                                                "setSniCertificatePaths");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ssl_profile_path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ssl_profile_path",
                                                                                "sslProfilePath",
                                                                                "getSslProfilePath",
                                                                                "setSslProfilePath");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.LB_client_ssl_profile_binding",
                                                            fields,
                                                            com.vmware.nsx_policy.model.LBClientSslProfileBinding.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

