/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * This condition is used to match IP header fields of HTTP messages. Either
 * source_address or group_id should be specified.
 */
public final class LBIpHeaderCondition implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    /**
     * Identifier denoting this class, when it is used in polymorphic context. 
     * <p>This
     * value should be assigned to the property which is used to discriminate the
     * actual type used in the polymorphic context.</p>
     */
    public static final java.lang.String _TYPE_IDENTIFIER = "LBIpHeaderCondition";

    private java.lang.String groupPath;

    private java.lang.String sourceAddress;

    private java.lang.Boolean inverse;

    private final java.lang.String type = "LBIpHeaderCondition";

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public LBIpHeaderCondition() {
    }

    protected LBIpHeaderCondition(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Source IP address of HTTP message should match IP addresses which are configured
     * in Group in order to perform actions.
     *
     * @return The current value of the property.
     */
    public java.lang.String getGroupPath() {
        return this.groupPath;
    }

    /**
     * Source IP address of HTTP message should match IP addresses which are configured
     * in Group in order to perform actions.
     *
     * @param groupPath New value for the property.
     */
    public void setGroupPath(java.lang.String groupPath) {
        this.groupPath = groupPath;
    }

    /**
     * Source IP address of HTTP message. IP Address can be expressed as a single IP
     * address like 10.1.1.1, or a range of IP addresses like 10.1.1.101-10.1.1.160.
     * Both IPv4 and IPv6 addresses are supported. format: address-or-block-or-range
     *
     * @return The current value of the property.
     */
    public java.lang.String getSourceAddress() {
        return this.sourceAddress;
    }

    /**
     * Source IP address of HTTP message. IP Address can be expressed as a single IP
     * address like 10.1.1.1, or a range of IP addresses like 10.1.1.101-10.1.1.160.
     * Both IPv4 and IPv6 addresses are supported. format: address-or-block-or-range
     *
     * @param sourceAddress New value for the property.
     */
    public void setSourceAddress(java.lang.String sourceAddress) {
        this.sourceAddress = sourceAddress;
    }

    /**
     * A flag to indicate whether reverse the match result of this condition
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getInverse() {
        return this.inverse;
    }

    /**
     * A flag to indicate whether reverse the match result of this condition
     *
     * @param inverse New value for the property.
     */
    public void setInverse(java.lang.Boolean inverse) {
        this.inverse = inverse;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.LBRuleCondition#TYPE_LBHTTPREQUESTURICONDITION}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LBRuleCondition#TYPE_LBHTTPREQUESTHEADERCONDITION}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LBRuleCondition#TYPE_LBHTTPREQUESTMETHODCONDITION}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LBRuleCondition#TYPE_LBHTTPREQUESTURIARGUMENTSCONDITION}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LBRuleCondition#TYPE_LBHTTPREQUESTVERSIONCONDITION}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LBRuleCondition#TYPE_LBHTTPREQUESTCOOKIECONDITION}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LBRuleCondition#TYPE_LBHTTPREQUESTBODYCONDITION}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LBRuleCondition#TYPE_LBHTTPRESPONSEHEADERCONDITION}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LBRuleCondition#TYPE_LBTCPHEADERCONDITION}</li> <li>
     * {@link
     * com.vmware.nsx_policy.model.LBRuleCondition#TYPE_LBIPHEADERCONDITION}</li> <li>
     * {@link
     * com.vmware.nsx_policy.model.LBRuleCondition#TYPE_LBVARIABLECONDITION}</li> <li>
     * {@link com.vmware.nsx_policy.model.LBRuleCondition#TYPE_LBHTTPSSLCONDITION}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LBRuleCondition#TYPE_LBSSLSNICONDITION}</li> </ul>
     * Type of load balancer rule condition
     * The value of this property is automatically populated to {@code "LBIpHeaderCondition"}.
     *
     * @return The current value of the property.
     */
    public java.lang.String getType() {
        return this.type;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.LBIpHeaderCondition;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("group_path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.groupPath, this._getType().getField("group_path")));
        structValue.setField("source_address",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.sourceAddress, this._getType().getField("source_address")));
        structValue.setField("inverse",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.inverse, this._getType().getField("inverse")));
        structValue.setField("type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.type, this._getType().getField("type")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.LBIpHeaderCondition;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.LBIpHeaderCondition.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static LBIpHeaderCondition _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new LBIpHeaderCondition(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static LBIpHeaderCondition _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new LBIpHeaderCondition(structValue);
    }

    /**
     * Builder class for {@link LBIpHeaderCondition}.
     */
    public static final class Builder {
        private java.lang.String groupPath;
        private java.lang.String sourceAddress;
        private java.lang.Boolean inverse;

        /**
         * Constructor with parameters for the required properties of
         * {@link LBIpHeaderCondition}.
         */
        public Builder() {
        }

        /**
         * Source IP address of HTTP message should match IP addresses which are configured
         * in Group in order to perform actions.
         *
         * @param groupPath New value for the property.
         */
        public Builder setGroupPath(java.lang.String groupPath) {
            this.groupPath = groupPath;
            return this;
        }

        /**
         * Source IP address of HTTP message. IP Address can be expressed as a single IP
         * address like 10.1.1.1, or a range of IP addresses like 10.1.1.101-10.1.1.160.
         * Both IPv4 and IPv6 addresses are supported. format: address-or-block-or-range
         *
         * @param sourceAddress New value for the property.
         */
        public Builder setSourceAddress(java.lang.String sourceAddress) {
            this.sourceAddress = sourceAddress;
            return this;
        }

        /**
         * A flag to indicate whether reverse the match result of this condition
         *
         * @param inverse New value for the property.
         */
        public Builder setInverse(java.lang.Boolean inverse) {
            this.inverse = inverse;
            return this;
        }

        public LBIpHeaderCondition build() {
            LBIpHeaderCondition result = new LBIpHeaderCondition();
            result.setGroupPath(this.groupPath);
            result.setSourceAddress(this.sourceAddress);
            result.setInverse(this.inverse);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("group_path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("group_path",
                                                                                "groupPath",
                                                                                "getGroupPath",
                                                                                "setGroupPath");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("source_address", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("source_address",
                                                                                "sourceAddress",
                                                                                "getSourceAddress",
                                                                                "setSourceAddress");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("inverse", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("inverse",
                                                                                "inverse",
                                                                                "getInverse",
                                                                                "setInverse");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("type", new com.vmware.vapi.bindings.type.StringType());
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("type",
                                                                                "type",
                                                                                "getType",
                                                                                null);
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.LB_ip_header_condition",
                                                            fields,
                                                            com.vmware.nsx_policy.model.LBIpHeaderCondition.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            "type",
                                                            "LBIpHeaderCondition");
    }
}

