/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * The node count for specific load balancer usage severity.
 */
public final class LBNodeCountPerSeverity implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String SEVERITY_GREEN = "GREEN";

    public static final java.lang.String SEVERITY_ORANGE = "ORANGE";

    public static final java.lang.String SEVERITY_RED = "RED";

    private java.lang.Long nodeCount;

    private java.lang.String severity;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public LBNodeCountPerSeverity() {
    }

    protected LBNodeCountPerSeverity(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Node count for specific serverity. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getNodeCount() {
        return this.nodeCount;
    }

    /**
     * Node count for specific serverity. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param nodeCount New value for the property.
     */
    public void setNodeCount(java.lang.Long nodeCount) {
        this.nodeCount = nodeCount;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.LBNodeCountPerSeverity#SEVERITY_GREEN}</li> <li>
     * {@link com.vmware.nsx_policy.model.LBNodeCountPerSeverity#SEVERITY_ORANGE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LBNodeCountPerSeverity#SEVERITY_RED}</li> </ul> The
     * severity calculation is based on current credit usage percentage of load
     * balancer for one node.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getSeverity() {
        return this.severity;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.LBNodeCountPerSeverity#SEVERITY_GREEN}</li> <li>
     * {@link com.vmware.nsx_policy.model.LBNodeCountPerSeverity#SEVERITY_ORANGE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LBNodeCountPerSeverity#SEVERITY_RED}</li> </ul> The
     * severity calculation is based on current credit usage percentage of load
     * balancer for one node.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param severity New value for the property.
     */
    public void setSeverity(java.lang.String severity) {
        this.severity = severity;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.LBNodeCountPerSeverity;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("node_count",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.nodeCount, this._getType().getField("node_count")));
        structValue.setField("severity",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.severity, this._getType().getField("severity")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.LBNodeCountPerSeverity;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.LBNodeCountPerSeverity.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static LBNodeCountPerSeverity _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new LBNodeCountPerSeverity(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static LBNodeCountPerSeverity _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new LBNodeCountPerSeverity(structValue);
    }

    /**
     * Builder class for {@link LBNodeCountPerSeverity}.
     */
    public static final class Builder {
        private java.lang.Long nodeCount;
        private java.lang.String severity;

        /**
         * Constructor with parameters for the required properties of
         * {@link LBNodeCountPerSeverity}.
         */
        public Builder() {
        }

        /**
         * Node count for specific serverity. format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param nodeCount New value for the property.
         */
        public Builder setNodeCount(java.lang.Long nodeCount) {
            this.nodeCount = nodeCount;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.LBNodeCountPerSeverity#SEVERITY_GREEN}</li> <li>
         * {@link com.vmware.nsx_policy.model.LBNodeCountPerSeverity#SEVERITY_ORANGE}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.LBNodeCountPerSeverity#SEVERITY_RED}</li> </ul> The
         * severity calculation is based on current credit usage percentage of load
         * balancer for one node.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param severity New value for the property.
         */
        public Builder setSeverity(java.lang.String severity) {
            this.severity = severity;
            return this;
        }

        public LBNodeCountPerSeverity build() {
            LBNodeCountPerSeverity result = new LBNodeCountPerSeverity();
            result.setNodeCount(this.nodeCount);
            result.setSeverity(this.severity);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("node_count", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("node_count",
                                                                                "nodeCount",
                                                                                "getNodeCount",
                                                                                "setNodeCount");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("severity", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("severity",
                                                                                "severity",
                                                                                "getSeverity",
                                                                                "setSeverity");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.LB_node_count_per_severity",
                                                            fields,
                                                            com.vmware.nsx_policy.model.LBNodeCountPerSeverity.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

