/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * The load balancer node usage summary for all nodes from specific enforcement
 * point. Only edge node is supported. The summary contains all edge nodes which
 * are configured in edge clusters.
 */
public final class LBNodeUsageSummary implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String SEVERITY_GREEN = "GREEN";

    public static final java.lang.String SEVERITY_ORANGE = "ORANGE";

    public static final java.lang.String SEVERITY_RED = "RED";

    private com.vmware.nsx_policy.model.PolicyRuntimeAlarm alarm;

    private java.lang.String enforcementPointPath;

    private java.lang.Long currentLoadBalancerCredits;

    private java.lang.Long currentPoolMemberCount;

    private java.lang.Long loadBalancerCreditCapacity;

    private java.util.List<com.vmware.nsx_policy.model.LBNodeCountPerSeverity> nodeCounts;

    private java.util.List<com.vmware.vapi.bindings.Structure> nodeUsages;

    private java.lang.Long poolMemberCapacity;

    private java.lang.String severity;

    private java.lang.Double usagePercentage;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public LBNodeUsageSummary() {
    }

    protected LBNodeUsageSummary(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx_policy.model.PolicyRuntimeAlarm getAlarm() {
        return this.alarm;
    }

    /**
     *
     *
     * @param alarm New value for the property.
     */
    public void setAlarm(com.vmware.nsx_policy.model.PolicyRuntimeAlarm alarm) {
        this.alarm = alarm;
    }

    /**
     * Policy Path referencing the enforcement point where the info is fetched.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getEnforcementPointPath() {
        return this.enforcementPointPath;
    }

    /**
     * Policy Path referencing the enforcement point where the info is fetched.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param enforcementPointPath New value for the property.
     */
    public void setEnforcementPointPath(java.lang.String enforcementPointPath) {
        this.enforcementPointPath = enforcementPointPath;
    }

    /**
     * Current load balancer credits in use for all nodes. For example, configuring a
     * medium load balancer on a node consumes 10 credits. If there are 2 medium
     * instances configured, the current load balancer credit number is 2 * 10 = 20.
     * format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getCurrentLoadBalancerCredits() {
        return this.currentLoadBalancerCredits;
    }

    /**
     * Current load balancer credits in use for all nodes. For example, configuring a
     * medium load balancer on a node consumes 10 credits. If there are 2 medium
     * instances configured, the current load balancer credit number is 2 * 10 = 20.
     * format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param currentLoadBalancerCredits New value for the property.
     */
    public void setCurrentLoadBalancerCredits(java.lang.Long currentLoadBalancerCredits) {
        this.currentLoadBalancerCredits = currentLoadBalancerCredits;
    }

    /**
     * The overall count of pool members configured on all nodes. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getCurrentPoolMemberCount() {
        return this.currentPoolMemberCount;
    }

    /**
     * The overall count of pool members configured on all nodes. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param currentPoolMemberCount New value for the property.
     */
    public void setCurrentPoolMemberCount(java.lang.Long currentPoolMemberCount) {
        this.currentPoolMemberCount = currentPoolMemberCount;
    }

    /**
     * The load balancer credit capacity means the maximum credits which can be used
     * for load balancer service configuration for all nodes. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getLoadBalancerCreditCapacity() {
        return this.loadBalancerCreditCapacity;
    }

    /**
     * The load balancer credit capacity means the maximum credits which can be used
     * for load balancer service configuration for all nodes. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param loadBalancerCreditCapacity New value for the property.
     */
    public void setLoadBalancerCreditCapacity(java.lang.Long loadBalancerCreditCapacity) {
        this.loadBalancerCreditCapacity = loadBalancerCreditCapacity;
    }

    /**
     * The property identifies array of node count for each severity.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx_policy.model.LBNodeCountPerSeverity> getNodeCounts() {
        return this.nodeCounts;
    }

    /**
     * The property identifies array of node count for each severity.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param nodeCounts New value for the property.
     */
    public void setNodeCounts(java.util.List<com.vmware.nsx_policy.model.LBNodeCountPerSeverity> nodeCounts) {
        this.nodeCounts = nodeCounts;
    }

    /**
     * The property identifies all LB node usages. By default, it is not included in
     * response. It exists when parameter ?include_usages=true.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     * When clients pass a value of this class as a parameter, the property must
     * contain all the properties defined in {@link
     * com.vmware.nsx_policy.model.LBNodeUsage}. When methods return a value of this
     * class as a return value, the property will contain all the properties defined in
     * {@link com.vmware.nsx_policy.model.LBNodeUsage}.
     */
    public java.util.List<com.vmware.vapi.bindings.Structure> getNodeUsages() {
        return this.nodeUsages;
    }

    /**
     * The property identifies all LB node usages. By default, it is not included in
     * response. It exists when parameter ?include_usages=true.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param nodeUsages New value for the property.
     * When clients pass a value of this class as a parameter, the property must
     * contain all the properties defined in {@link
     * com.vmware.nsx_policy.model.LBNodeUsage}. When methods return a value of this
     * class as a return value, the property will contain all the properties defined in
     * {@link com.vmware.nsx_policy.model.LBNodeUsage}.
     */
    public void setNodeUsages(java.util.List<com.vmware.vapi.bindings.Structure> nodeUsages) {
        this.nodeUsages = nodeUsages;
    }

    /**
     * Pool member capacity means maximum number of pool members which can be
     * configured on all nodes. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getPoolMemberCapacity() {
        return this.poolMemberCapacity;
    }

    /**
     * Pool member capacity means maximum number of pool members which can be
     * configured on all nodes. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param poolMemberCapacity New value for the property.
     */
    public void setPoolMemberCapacity(java.lang.Long poolMemberCapacity) {
        this.poolMemberCapacity = poolMemberCapacity;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.LBNodeUsageSummary#SEVERITY_GREEN}</li> <li> {@link
     * com.vmware.nsx_policy.model.LBNodeUsageSummary#SEVERITY_ORANGE}</li> <li> {@link
     * com.vmware.nsx_policy.model.LBNodeUsageSummary#SEVERITY_RED}</li> </ul> The
     * severity calculation is based on overall credit usage percentage of load
     * balancer for all nodes.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getSeverity() {
        return this.severity;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.LBNodeUsageSummary#SEVERITY_GREEN}</li> <li> {@link
     * com.vmware.nsx_policy.model.LBNodeUsageSummary#SEVERITY_ORANGE}</li> <li> {@link
     * com.vmware.nsx_policy.model.LBNodeUsageSummary#SEVERITY_RED}</li> </ul> The
     * severity calculation is based on overall credit usage percentage of load
     * balancer for all nodes.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param severity New value for the property.
     */
    public void setSeverity(java.lang.String severity) {
        this.severity = severity;
    }

    /**
     * The overall usage percentage of all nodes for load balancer. The value is the
     * larger value between overall pool member usage percentage and overall load
     * balancer credit usage percentage.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Double getUsagePercentage() {
        return this.usagePercentage;
    }

    /**
     * The overall usage percentage of all nodes for load balancer. The value is the
     * larger value between overall pool member usage percentage and overall load
     * balancer credit usage percentage.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param usagePercentage New value for the property.
     */
    public void setUsagePercentage(java.lang.Double usagePercentage) {
        this.usagePercentage = usagePercentage;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.LBNodeUsageSummary;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("alarm",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.alarm, this._getType().getField("alarm")));
        structValue.setField("enforcement_point_path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.enforcementPointPath, this._getType().getField("enforcement_point_path")));
        structValue.setField("current_load_balancer_credits",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.currentLoadBalancerCredits, this._getType().getField("current_load_balancer_credits")));
        structValue.setField("current_pool_member_count",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.currentPoolMemberCount, this._getType().getField("current_pool_member_count")));
        structValue.setField("load_balancer_credit_capacity",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.loadBalancerCreditCapacity, this._getType().getField("load_balancer_credit_capacity")));
        structValue.setField("node_counts",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.nodeCounts, this._getType().getField("node_counts")));
        structValue.setField("node_usages",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.nodeUsages, this._getType().getField("node_usages")));
        structValue.setField("pool_member_capacity",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.poolMemberCapacity, this._getType().getField("pool_member_capacity")));
        structValue.setField("severity",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.severity, this._getType().getField("severity")));
        structValue.setField("usage_percentage",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.usagePercentage, this._getType().getField("usage_percentage")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.LBNodeUsageSummary;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.LBNodeUsageSummary.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static LBNodeUsageSummary _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new LBNodeUsageSummary(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static LBNodeUsageSummary _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new LBNodeUsageSummary(structValue);
    }

    /**
     * Builder class for {@link LBNodeUsageSummary}.
     */
    public static final class Builder {
        private com.vmware.nsx_policy.model.PolicyRuntimeAlarm alarm;
        private java.lang.String enforcementPointPath;
        private java.lang.Long currentLoadBalancerCredits;
        private java.lang.Long currentPoolMemberCount;
        private java.lang.Long loadBalancerCreditCapacity;
        private java.util.List<com.vmware.nsx_policy.model.LBNodeCountPerSeverity> nodeCounts;
        private java.util.List<com.vmware.vapi.bindings.Structure> nodeUsages;
        private java.lang.Long poolMemberCapacity;
        private java.lang.String severity;
        private java.lang.Double usagePercentage;

        /**
         * Constructor with parameters for the required properties of
         * {@link LBNodeUsageSummary}.
         */
        public Builder() {
        }

        /**
         *
         *
         * @param alarm New value for the property.
         */
        public Builder setAlarm(com.vmware.nsx_policy.model.PolicyRuntimeAlarm alarm) {
            this.alarm = alarm;
            return this;
        }

        /**
         * Policy Path referencing the enforcement point where the info is fetched.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param enforcementPointPath New value for the property.
         */
        public Builder setEnforcementPointPath(java.lang.String enforcementPointPath) {
            this.enforcementPointPath = enforcementPointPath;
            return this;
        }

        /**
         * Current load balancer credits in use for all nodes. For example, configuring a
         * medium load balancer on a node consumes 10 credits. If there are 2 medium
         * instances configured, the current load balancer credit number is 2 * 10 = 20.
         * format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param currentLoadBalancerCredits New value for the property.
         */
        public Builder setCurrentLoadBalancerCredits(java.lang.Long currentLoadBalancerCredits) {
            this.currentLoadBalancerCredits = currentLoadBalancerCredits;
            return this;
        }

        /**
         * The overall count of pool members configured on all nodes. format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param currentPoolMemberCount New value for the property.
         */
        public Builder setCurrentPoolMemberCount(java.lang.Long currentPoolMemberCount) {
            this.currentPoolMemberCount = currentPoolMemberCount;
            return this;
        }

        /**
         * The load balancer credit capacity means the maximum credits which can be used
         * for load balancer service configuration for all nodes. format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param loadBalancerCreditCapacity New value for the property.
         */
        public Builder setLoadBalancerCreditCapacity(java.lang.Long loadBalancerCreditCapacity) {
            this.loadBalancerCreditCapacity = loadBalancerCreditCapacity;
            return this;
        }

        /**
         * The property identifies array of node count for each severity.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param nodeCounts New value for the property.
         */
        public Builder setNodeCounts(java.util.List<com.vmware.nsx_policy.model.LBNodeCountPerSeverity> nodeCounts) {
            this.nodeCounts = nodeCounts;
            return this;
        }

        /**
         * The property identifies all LB node usages. By default, it is not included in
         * response. It exists when parameter ?include_usages=true.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param nodeUsages New value for the property.
         * When clients pass a value of this class as a parameter, the property must
         * contain all the properties defined in {@link
         * com.vmware.nsx_policy.model.LBNodeUsage}. When methods return a value of this
         * class as a return value, the property will contain all the properties defined in
         * {@link com.vmware.nsx_policy.model.LBNodeUsage}.
         */
        public Builder setNodeUsages(java.util.List<com.vmware.vapi.bindings.Structure> nodeUsages) {
            this.nodeUsages = nodeUsages;
            return this;
        }

        /**
         * Pool member capacity means maximum number of pool members which can be
         * configured on all nodes. format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param poolMemberCapacity New value for the property.
         */
        public Builder setPoolMemberCapacity(java.lang.Long poolMemberCapacity) {
            this.poolMemberCapacity = poolMemberCapacity;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.LBNodeUsageSummary#SEVERITY_GREEN}</li> <li> {@link
         * com.vmware.nsx_policy.model.LBNodeUsageSummary#SEVERITY_ORANGE}</li> <li> {@link
         * com.vmware.nsx_policy.model.LBNodeUsageSummary#SEVERITY_RED}</li> </ul> The
         * severity calculation is based on overall credit usage percentage of load
         * balancer for all nodes.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param severity New value for the property.
         */
        public Builder setSeverity(java.lang.String severity) {
            this.severity = severity;
            return this;
        }

        /**
         * The overall usage percentage of all nodes for load balancer. The value is the
         * larger value between overall pool member usage percentage and overall load
         * balancer credit usage percentage.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param usagePercentage New value for the property.
         */
        public Builder setUsagePercentage(java.lang.Double usagePercentage) {
            this.usagePercentage = usagePercentage;
            return this;
        }

        public LBNodeUsageSummary build() {
            LBNodeUsageSummary result = new LBNodeUsageSummary();
            result.setAlarm(this.alarm);
            result.setEnforcementPointPath(this.enforcementPointPath);
            result.setCurrentLoadBalancerCredits(this.currentLoadBalancerCredits);
            result.setCurrentPoolMemberCount(this.currentPoolMemberCount);
            result.setLoadBalancerCreditCapacity(this.loadBalancerCreditCapacity);
            result.setNodeCounts(this.nodeCounts);
            result.setNodeUsages(this.nodeUsages);
            result.setPoolMemberCapacity(this.poolMemberCapacity);
            result.setSeverity(this.severity);
            result.setUsagePercentage(this.usagePercentage);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("alarm", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.policyRuntimeAlarm; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("alarm",
                                                                                "alarm",
                                                                                "getAlarm",
                                                                                "setAlarm");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("enforcement_point_path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("enforcement_point_path",
                                                                                "enforcementPointPath",
                                                                                "getEnforcementPointPath",
                                                                                "setEnforcementPointPath");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("current_load_balancer_credits", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("current_load_balancer_credits",
                                                                                "currentLoadBalancerCredits",
                                                                                "getCurrentLoadBalancerCredits",
                                                                                "setCurrentLoadBalancerCredits");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("current_pool_member_count", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("current_pool_member_count",
                                                                                "currentPoolMemberCount",
                                                                                "getCurrentPoolMemberCount",
                                                                                "setCurrentPoolMemberCount");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("load_balancer_credit_capacity", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("load_balancer_credit_capacity",
                                                                                "loadBalancerCreditCapacity",
                                                                                "getLoadBalancerCreditCapacity",
                                                                                "setLoadBalancerCreditCapacity");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("node_counts", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.LBNodeCountPerSeverity; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("node_counts",
                                                                                "nodeCounts",
                                                                                "getNodeCounts",
                                                                                "setNodeCounts");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("node_usages", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.DynamicStructType(java.util.Arrays.<com.vmware.vapi.internal.data.ConstraintValidator>asList(new com.vmware.vapi.internal.bindings.HasFieldsOfValidator(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.LBNodeUsage; } }))))));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("node_usages",
                                                                                "nodeUsages",
                                                                                "getNodeUsages",
                                                                                "setNodeUsages");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("pool_member_capacity", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("pool_member_capacity",
                                                                                "poolMemberCapacity",
                                                                                "getPoolMemberCapacity",
                                                                                "setPoolMemberCapacity");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("severity", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("severity",
                                                                                "severity",
                                                                                "getSeverity",
                                                                                "setSeverity");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("usage_percentage", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.DoubleType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("usage_percentage",
                                                                                "usagePercentage",
                                                                                "getUsagePercentage",
                                                                                "setUsagePercentage");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.LB_node_usage_summary",
                                                            fields,
                                                            com.vmware.nsx_policy.model.LBNodeUsageSummary.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

