/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * This action is performed in HTTP response rewrite phase. It is used to learn the
 * value of variable from the HTTP response, and insert an entry into the
 * persistence table if the entry doesn't exist.
 */
public final class LBVariablePersistenceLearnAction implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    /**
     * Identifier denoting this class, when it is used in polymorphic context. 
     * <p>This
     * value should be assigned to the property which is used to discriminate the
     * actual type used in the polymorphic context.</p>
     */
    public static final java.lang.String _TYPE_IDENTIFIER = "LBVariablePersistenceLearnAction";

    private java.lang.String persistenceProfilePath;

    private java.lang.Boolean variableHashEnabled;

    private java.lang.String variableName;

    private final java.lang.String type = "LBVariablePersistenceLearnAction";

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public LBVariablePersistenceLearnAction() {
    }

    protected LBVariablePersistenceLearnAction(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * If the persistence profile path is not specified, a default persistence table is
     * created per virtual server. Currently, only LBGenericPersistenceProfile is
     * supported.
     *
     * @return The current value of the property.
     */
    public java.lang.String getPersistenceProfilePath() {
        return this.persistenceProfilePath;
    }

    /**
     * If the persistence profile path is not specified, a default persistence table is
     * created per virtual server. Currently, only LBGenericPersistenceProfile is
     * supported.
     *
     * @param persistenceProfilePath New value for the property.
     */
    public void setPersistenceProfilePath(java.lang.String persistenceProfilePath) {
        this.persistenceProfilePath = persistenceProfilePath;
    }

    /**
     * The property is used to enable a hash operation for variable value when
     * composing the persistence key.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getVariableHashEnabled() {
        return this.variableHashEnabled;
    }

    /**
     * The property is used to enable a hash operation for variable value when
     * composing the persistence key.
     *
     * @param variableHashEnabled New value for the property.
     */
    public void setVariableHashEnabled(java.lang.Boolean variableHashEnabled) {
        this.variableHashEnabled = variableHashEnabled;
    }

    /**
     * The property is the name of variable to be learnt. It is used to identify which
     * variable's value is learnt from HTTP response. The variable can be a built-in
     * variable such as \"_cookie_JSESSIONID\", a customized variable defined in
     * LBVariableAssignmentAction or a captured variable in regular expression such as
     * \"article\". For the full list of built-in variables, please reference the NSX-T
     * Administrator's Guide.
     *
     * @return The current value of the property.
     */
    public java.lang.String getVariableName() {
        return this.variableName;
    }

    /**
     * The property is the name of variable to be learnt. It is used to identify which
     * variable's value is learnt from HTTP response. The variable can be a built-in
     * variable such as \"_cookie_JSESSIONID\", a customized variable defined in
     * LBVariableAssignmentAction or a captured variable in regular expression such as
     * \"article\". For the full list of built-in variables, please reference the NSX-T
     * Administrator's Guide.
     *
     * @param variableName New value for the property.
     */
    public void setVariableName(java.lang.String variableName) {
        this.variableName = variableName;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.LBRuleAction#TYPE_LBSELECTPOOLACTION}</li> <li>
     * {@link
     * com.vmware.nsx_policy.model.LBRuleAction#TYPE_LBHTTPREQUESTURIREWRITEACTION}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LBRuleAction#TYPE_LBHTTPREQUESTHEADERREWRITEACTION}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LBRuleAction#TYPE_LBHTTPREJECTACTION}</li> <li>
     * {@link com.vmware.nsx_policy.model.LBRuleAction#TYPE_LBHTTPREDIRECTACTION}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LBRuleAction#TYPE_LBHTTPRESPONSEHEADERREWRITEACTION}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LBRuleAction#TYPE_LBHTTPREQUESTHEADERDELETEACTION}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LBRuleAction#TYPE_LBHTTPRESPONSEHEADERDELETEACTION}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LBRuleAction#TYPE_LBVARIABLEASSIGNMENTACTION}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LBRuleAction#TYPE_LBVARIABLEPERSISTENCEONACTION}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LBRuleAction#TYPE_LBVARIABLEPERSISTENCELEARNACTION}</li>
     * <li> {@link com.vmware.nsx_policy.model.LBRuleAction#TYPE_LBJWTAUTHACTION}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LBRuleAction#TYPE_LBSSLMODESELECTIONACTION}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LBRuleAction#TYPE_LBCONNECTIONDROPACTION}</li> </ul>
     * The property identifies the load balancer rule action type.
     * The value of this property is automatically populated to {@code "LBVariablePersistenceLearnAction"}.
     *
     * @return The current value of the property.
     */
    public java.lang.String getType() {
        return this.type;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.LBVariablePersistenceLearnAction;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("persistence_profile_path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.persistenceProfilePath, this._getType().getField("persistence_profile_path")));
        structValue.setField("variable_hash_enabled",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.variableHashEnabled, this._getType().getField("variable_hash_enabled")));
        structValue.setField("variable_name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.variableName, this._getType().getField("variable_name")));
        structValue.setField("type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.type, this._getType().getField("type")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.LBVariablePersistenceLearnAction;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.LBVariablePersistenceLearnAction.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static LBVariablePersistenceLearnAction _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new LBVariablePersistenceLearnAction(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static LBVariablePersistenceLearnAction _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new LBVariablePersistenceLearnAction(structValue);
    }

    /**
     * Builder class for {@link LBVariablePersistenceLearnAction}.
     */
    public static final class Builder {
        private java.lang.String persistenceProfilePath;
        private java.lang.Boolean variableHashEnabled;
        private java.lang.String variableName;

        /**
         * Constructor with parameters for the required properties of
         * {@link LBVariablePersistenceLearnAction}.
         */
        public Builder() {
        }

        /**
         * If the persistence profile path is not specified, a default persistence table is
         * created per virtual server. Currently, only LBGenericPersistenceProfile is
         * supported.
         *
         * @param persistenceProfilePath New value for the property.
         */
        public Builder setPersistenceProfilePath(java.lang.String persistenceProfilePath) {
            this.persistenceProfilePath = persistenceProfilePath;
            return this;
        }

        /**
         * The property is used to enable a hash operation for variable value when
         * composing the persistence key.
         *
         * @param variableHashEnabled New value for the property.
         */
        public Builder setVariableHashEnabled(java.lang.Boolean variableHashEnabled) {
            this.variableHashEnabled = variableHashEnabled;
            return this;
        }

        /**
         * The property is the name of variable to be learnt. It is used to identify which
         * variable's value is learnt from HTTP response. The variable can be a built-in
         * variable such as \"_cookie_JSESSIONID\", a customized variable defined in
         * LBVariableAssignmentAction or a captured variable in regular expression such as
         * \"article\". For the full list of built-in variables, please reference the NSX-T
         * Administrator's Guide.
         *
         * @param variableName New value for the property.
         */
        public Builder setVariableName(java.lang.String variableName) {
            this.variableName = variableName;
            return this;
        }

        public LBVariablePersistenceLearnAction build() {
            LBVariablePersistenceLearnAction result = new LBVariablePersistenceLearnAction();
            result.setPersistenceProfilePath(this.persistenceProfilePath);
            result.setVariableHashEnabled(this.variableHashEnabled);
            result.setVariableName(this.variableName);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("persistence_profile_path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("persistence_profile_path",
                                                                                "persistenceProfilePath",
                                                                                "getPersistenceProfilePath",
                                                                                "setPersistenceProfilePath");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("variable_hash_enabled", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("variable_hash_enabled",
                                                                                "variableHashEnabled",
                                                                                "getVariableHashEnabled",
                                                                                "setVariableHashEnabled");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("variable_name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("variable_name",
                                                                                "variableName",
                                                                                "getVariableName",
                                                                                "setVariableName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("type", new com.vmware.vapi.bindings.type.StringType());
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("type",
                                                                                "type",
                                                                                "getType",
                                                                                null);
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.LB_variable_persistence_learn_action",
                                                            fields,
                                                            com.vmware.nsx_policy.model.LBVariablePersistenceLearnAction.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            "type",
                                                            "LBVariablePersistenceLearnAction");
    }
}

