/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * Label that will be displayed for a UI element.
 */
public final class Label implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.lang.String condition;

    private java.lang.Boolean hover;

    private java.util.List<com.vmware.nsx_policy.model.Icon> icons;

    private java.lang.String navigation;

    private java.lang.String text;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public Label() {
    }

    protected Label(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * If the condition is met then the label will be applied. Examples of expression
     * syntax are provided under example_request section of CreateWidgetConfiguration
     * API.
     *
     * @return The current value of the property.
     */
    public java.lang.String getCondition() {
        return this.condition;
    }

    /**
     * If the condition is met then the label will be applied. Examples of expression
     * syntax are provided under example_request section of CreateWidgetConfiguration
     * API.
     *
     * @param condition New value for the property.
     */
    public void setCondition(java.lang.String condition) {
        this.condition = condition;
    }

    /**
     * If true, displays the label only on hover
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getHover() {
        return this.hover;
    }

    /**
     * If true, displays the label only on hover
     *
     * @param hover New value for the property.
     */
    public void setHover(java.lang.Boolean hover) {
        this.hover = hover;
    }

    /**
     * Icons to be applied at dashboard for the label
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx_policy.model.Icon> getIcons() {
        return this.icons;
    }

    /**
     * Icons to be applied at dashboard for the label
     *
     * @param icons New value for the property.
     */
    public void setIcons(java.util.List<com.vmware.nsx_policy.model.Icon> icons) {
        this.icons = icons;
    }

    /**
     * Hyperlink of the specified UI page that provides details.
     *
     * @return The current value of the property.
     */
    public java.lang.String getNavigation() {
        return this.navigation;
    }

    /**
     * Hyperlink of the specified UI page that provides details.
     *
     * @param navigation New value for the property.
     */
    public void setNavigation(java.lang.String navigation) {
        this.navigation = navigation;
    }

    /**
     * Text to be displayed at the label.
     *
     * @return The current value of the property.
     */
    public java.lang.String getText() {
        return this.text;
    }

    /**
     * Text to be displayed at the label.
     *
     * @param text New value for the property.
     */
    public void setText(java.lang.String text) {
        this.text = text;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.label;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("condition",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.condition, this._getType().getField("condition")));
        structValue.setField("hover",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.hover, this._getType().getField("hover")));
        structValue.setField("icons",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.icons, this._getType().getField("icons")));
        structValue.setField("navigation",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.navigation, this._getType().getField("navigation")));
        structValue.setField("text",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.text, this._getType().getField("text")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.label;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.label.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static Label _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new Label(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static Label _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new Label(structValue);
    }

    /**
     * Builder class for {@link Label}.
     */
    public static final class Builder {
        private java.lang.String condition;
        private java.lang.Boolean hover;
        private java.util.List<com.vmware.nsx_policy.model.Icon> icons;
        private java.lang.String navigation;
        private java.lang.String text;

        /**
         * Constructor with parameters for the required properties of
         * {@link Label}.
         */
        public Builder() {
        }

        /**
         * If the condition is met then the label will be applied. Examples of expression
         * syntax are provided under example_request section of CreateWidgetConfiguration
         * API.
         *
         * @param condition New value for the property.
         */
        public Builder setCondition(java.lang.String condition) {
            this.condition = condition;
            return this;
        }

        /**
         * If true, displays the label only on hover
         *
         * @param hover New value for the property.
         */
        public Builder setHover(java.lang.Boolean hover) {
            this.hover = hover;
            return this;
        }

        /**
         * Icons to be applied at dashboard for the label
         *
         * @param icons New value for the property.
         */
        public Builder setIcons(java.util.List<com.vmware.nsx_policy.model.Icon> icons) {
            this.icons = icons;
            return this;
        }

        /**
         * Hyperlink of the specified UI page that provides details.
         *
         * @param navigation New value for the property.
         */
        public Builder setNavigation(java.lang.String navigation) {
            this.navigation = navigation;
            return this;
        }

        /**
         * Text to be displayed at the label.
         *
         * @param text New value for the property.
         */
        public Builder setText(java.lang.String text) {
            this.text = text;
            return this;
        }

        public Label build() {
            Label result = new Label();
            result.setCondition(this.condition);
            result.setHover(this.hover);
            result.setIcons(this.icons);
            result.setNavigation(this.navigation);
            result.setText(this.text);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("condition", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("condition",
                                                                                "condition",
                                                                                "getCondition",
                                                                                "setCondition");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("hover", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("hover",
                                                                                "hover",
                                                                                "getHover",
                                                                                "setHover");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("icons", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.icon; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("icons",
                                                                                "icons",
                                                                                "getIcons",
                                                                                "setIcons");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("navigation", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("navigation",
                                                                                "navigation",
                                                                                "getNavigation",
                                                                                "setNavigation");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("text", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("text",
                                                                                "text",
                                                                                "getText",
                                                                                "setText");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.label",
                                                            fields,
                                                            com.vmware.nsx_policy.model.Label.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

