/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * Contains Neighbor Discovery Protocol (ND) snooping related configuration.
 */
public final class NdSnoopingConfig implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.lang.Boolean ndSnoopingEnabled;

    private java.lang.Long ndSnoopingLimit;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public NdSnoopingConfig() {
    }

    protected NdSnoopingConfig(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Enable this method will snoop the NS (Neighbor Solicitation) and NA (Neighbor
     * Advertisement) messages in the ND (Neighbor Discovery Protocol) family of
     * messages which are transmitted by a VM. From the NS messages, we will learn
     * about the source which sent this NS message. From the NA message, we will learn
     * the resolved address in the message which the VM is a recipient of. Addresses
     * snooped by this method are subject to TOFU (Trust on First Use) policies as
     * enforced by the system.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getNdSnoopingEnabled() {
        return this.ndSnoopingEnabled;
    }

    /**
     * Enable this method will snoop the NS (Neighbor Solicitation) and NA (Neighbor
     * Advertisement) messages in the ND (Neighbor Discovery Protocol) family of
     * messages which are transmitted by a VM. From the NS messages, we will learn
     * about the source which sent this NS message. From the NA message, we will learn
     * the resolved address in the message which the VM is a recipient of. Addresses
     * snooped by this method are subject to TOFU (Trust on First Use) policies as
     * enforced by the system.
     *
     * @param ndSnoopingEnabled New value for the property.
     */
    public void setNdSnoopingEnabled(java.lang.Boolean ndSnoopingEnabled) {
        this.ndSnoopingEnabled = ndSnoopingEnabled;
    }

    /**
     * Maximum number of ND (Neighbor Discovery Protocol) snooped IPv6 addresses
     * format: int32
     *
     * @return The current value of the property.
     */
    public java.lang.Long getNdSnoopingLimit() {
        return this.ndSnoopingLimit;
    }

    /**
     * Maximum number of ND (Neighbor Discovery Protocol) snooped IPv6 addresses
     * format: int32
     *
     * @param ndSnoopingLimit New value for the property.
     */
    public void setNdSnoopingLimit(java.lang.Long ndSnoopingLimit) {
        this.ndSnoopingLimit = ndSnoopingLimit;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.ndSnoopingConfig;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("nd_snooping_enabled",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ndSnoopingEnabled, this._getType().getField("nd_snooping_enabled")));
        structValue.setField("nd_snooping_limit",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ndSnoopingLimit, this._getType().getField("nd_snooping_limit")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.ndSnoopingConfig;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.ndSnoopingConfig.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static NdSnoopingConfig _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new NdSnoopingConfig(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static NdSnoopingConfig _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new NdSnoopingConfig(structValue);
    }

    /**
     * Builder class for {@link NdSnoopingConfig}.
     */
    public static final class Builder {
        private java.lang.Boolean ndSnoopingEnabled;
        private java.lang.Long ndSnoopingLimit;

        /**
         * Constructor with parameters for the required properties of
         * {@link NdSnoopingConfig}.
         */
        public Builder() {
        }

        /**
         * Enable this method will snoop the NS (Neighbor Solicitation) and NA (Neighbor
         * Advertisement) messages in the ND (Neighbor Discovery Protocol) family of
         * messages which are transmitted by a VM. From the NS messages, we will learn
         * about the source which sent this NS message. From the NA message, we will learn
         * the resolved address in the message which the VM is a recipient of. Addresses
         * snooped by this method are subject to TOFU (Trust on First Use) policies as
         * enforced by the system.
         *
         * @param ndSnoopingEnabled New value for the property.
         */
        public Builder setNdSnoopingEnabled(java.lang.Boolean ndSnoopingEnabled) {
            this.ndSnoopingEnabled = ndSnoopingEnabled;
            return this;
        }

        /**
         * Maximum number of ND (Neighbor Discovery Protocol) snooped IPv6 addresses
         * format: int32
         *
         * @param ndSnoopingLimit New value for the property.
         */
        public Builder setNdSnoopingLimit(java.lang.Long ndSnoopingLimit) {
            this.ndSnoopingLimit = ndSnoopingLimit;
            return this;
        }

        public NdSnoopingConfig build() {
            NdSnoopingConfig result = new NdSnoopingConfig();
            result.setNdSnoopingEnabled(this.ndSnoopingEnabled);
            result.setNdSnoopingLimit(this.ndSnoopingLimit);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("nd_snooping_enabled", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("nd_snooping_enabled",
                                                                                "ndSnoopingEnabled",
                                                                                "getNdSnoopingEnabled",
                                                                                "setNdSnoopingEnabled");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("nd_snooping_limit", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("nd_snooping_limit",
                                                                                "ndSnoopingLimit",
                                                                                "getNdSnoopingLimit",
                                                                                "setNdSnoopingLimit");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.nd_snooping_config",
                                                            fields,
                                                            com.vmware.nsx_policy.model.NdSnoopingConfig.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

