/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * Enables OSPF authentication with specified mode and password.
 */
public final class OspfAuthenticationConfig implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String MODE_NONE = "NONE";

    public static final java.lang.String MODE_PASSWORD = "PASSWORD";

    public static final java.lang.String MODE_MD5 = "MD5";

    private java.lang.Long keyId;

    private java.lang.String mode;

    private java.lang.String secretKey;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public OspfAuthenticationConfig() {
    }

    protected OspfAuthenticationConfig(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Authentication secret key id is mandatory for type md5 with min value of 1 and
     * max value 255. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getKeyId() {
        return this.keyId;
    }

    /**
     * Authentication secret key id is mandatory for type md5 with min value of 1 and
     * max value 255. format: int64
     *
     * @param keyId New value for the property.
     */
    public void setKeyId(java.lang.Long keyId) {
        this.keyId = keyId;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.OspfAuthenticationConfig#MODE_NONE}</li> <li> {@link
     * com.vmware.nsx_policy.model.OspfAuthenticationConfig#MODE_PASSWORD}</li> <li>
     * {@link com.vmware.nsx_policy.model.OspfAuthenticationConfig#MODE_MD5}</li> </ul>
     * If mode is MD5 or PASSWORD, Authentication secret key is mandatory if mode is
     * NONE, then authentication is deactivated.
     *
     * @return The current value of the property.
     */
    public java.lang.String getMode() {
        return this.mode;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.OspfAuthenticationConfig#MODE_NONE}</li> <li> {@link
     * com.vmware.nsx_policy.model.OspfAuthenticationConfig#MODE_PASSWORD}</li> <li>
     * {@link com.vmware.nsx_policy.model.OspfAuthenticationConfig#MODE_MD5}</li> </ul>
     * If mode is MD5 or PASSWORD, Authentication secret key is mandatory if mode is
     * NONE, then authentication is deactivated.
     *
     * @param mode New value for the property.
     */
    public void setMode(java.lang.String mode) {
        this.mode = mode;
    }

    /**
     * Authentication secret is mandatory for type password and md5 with min length of
     * 1 and max length 8.
     *
     * @return The current value of the property.
     */
    public java.lang.String getSecretKey() {
        return this.secretKey;
    }

    /**
     * Authentication secret is mandatory for type password and md5 with min length of
     * 1 and max length 8.
     *
     * @param secretKey New value for the property.
     */
    public void setSecretKey(java.lang.String secretKey) {
        this.secretKey = secretKey;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.ospfAuthenticationConfig;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("key_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.keyId, this._getType().getField("key_id")));
        structValue.setField("mode",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.mode, this._getType().getField("mode")));
        structValue.setField("secret_key",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.secretKey, this._getType().getField("secret_key")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.ospfAuthenticationConfig;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.ospfAuthenticationConfig.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static OspfAuthenticationConfig _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new OspfAuthenticationConfig(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static OspfAuthenticationConfig _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new OspfAuthenticationConfig(structValue);
    }

    /**
     * Builder class for {@link OspfAuthenticationConfig}.
     */
    public static final class Builder {
        private java.lang.Long keyId;
        private java.lang.String mode;
        private java.lang.String secretKey;

        /**
         * Constructor with parameters for the required properties of
         * {@link OspfAuthenticationConfig}.
         */
        public Builder() {
        }

        /**
         * Authentication secret key id is mandatory for type md5 with min value of 1 and
         * max value 255. format: int64
         *
         * @param keyId New value for the property.
         */
        public Builder setKeyId(java.lang.Long keyId) {
            this.keyId = keyId;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.OspfAuthenticationConfig#MODE_NONE}</li> <li> {@link
         * com.vmware.nsx_policy.model.OspfAuthenticationConfig#MODE_PASSWORD}</li> <li>
         * {@link com.vmware.nsx_policy.model.OspfAuthenticationConfig#MODE_MD5}</li> </ul>
         * If mode is MD5 or PASSWORD, Authentication secret key is mandatory if mode is
         * NONE, then authentication is deactivated.
         *
         * @param mode New value for the property.
         */
        public Builder setMode(java.lang.String mode) {
            this.mode = mode;
            return this;
        }

        /**
         * Authentication secret is mandatory for type password and md5 with min length of
         * 1 and max length 8.
         *
         * @param secretKey New value for the property.
         */
        public Builder setSecretKey(java.lang.String secretKey) {
            this.secretKey = secretKey;
            return this;
        }

        public OspfAuthenticationConfig build() {
            OspfAuthenticationConfig result = new OspfAuthenticationConfig();
            result.setKeyId(this.keyId);
            result.setMode(this.mode);
            result.setSecretKey(this.secretKey);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("key_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("key_id",
                                                                                "keyId",
                                                                                "getKeyId",
                                                                                "setKeyId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("mode", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("mode",
                                                                                "mode",
                                                                                "getMode",
                                                                                "setMode");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("secret_key", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("secret_key",
                                                                                "secretKey",
                                                                                "getSecretKey",
                                                                                "setSecretKey");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.ospf_authentication_config",
                                                            fields,
                                                            com.vmware.nsx_policy.model.OspfAuthenticationConfig.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

