/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * OSPF summary address configuration to summarize external routes
 */
public final class OspfSummaryAddressConfig implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.lang.Boolean advertise;

    private java.lang.String prefix;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public OspfSummaryAddressConfig() {
    }

    protected OspfSummaryAddressConfig(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Used to filter the advertisement of external routes into the OSPF domain.
     * Setting this field to \"TRUE\" will enable the summarization of external routes
     * that are covered by ip_prefix configuration. Setting this field to \"FALSE\"
     * will filter the advertisement of external routes that are covered by ip_prefix
     * configuration.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getAdvertise() {
        return this.advertise;
    }

    /**
     * Used to filter the advertisement of external routes into the OSPF domain.
     * Setting this field to \"TRUE\" will enable the summarization of external routes
     * that are covered by ip_prefix configuration. Setting this field to \"FALSE\"
     * will filter the advertisement of external routes that are covered by ip_prefix
     * configuration.
     *
     * @param advertise New value for the property.
     */
    public void setAdvertise(java.lang.Boolean advertise) {
        this.advertise = advertise;
    }

    /**
     * OSPF Summary address in CIDR format format: ip-cidr-block
     *
     * @return The current value of the property.
     */
    public java.lang.String getPrefix() {
        return this.prefix;
    }

    /**
     * OSPF Summary address in CIDR format format: ip-cidr-block
     *
     * @param prefix New value for the property.
     */
    public void setPrefix(java.lang.String prefix) {
        this.prefix = prefix;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.ospfSummaryAddressConfig;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("advertise",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.advertise, this._getType().getField("advertise")));
        structValue.setField("prefix",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.prefix, this._getType().getField("prefix")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.ospfSummaryAddressConfig;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.ospfSummaryAddressConfig.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static OspfSummaryAddressConfig _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new OspfSummaryAddressConfig(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static OspfSummaryAddressConfig _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new OspfSummaryAddressConfig(structValue);
    }

    /**
     * Builder class for {@link OspfSummaryAddressConfig}.
     */
    public static final class Builder {
        private java.lang.Boolean advertise;
        private java.lang.String prefix;

        /**
         * Constructor with parameters for the required properties of
         * {@link OspfSummaryAddressConfig}.
         */
        public Builder() {
        }

        /**
         * Used to filter the advertisement of external routes into the OSPF domain.
         * Setting this field to \"TRUE\" will enable the summarization of external routes
         * that are covered by ip_prefix configuration. Setting this field to \"FALSE\"
         * will filter the advertisement of external routes that are covered by ip_prefix
         * configuration.
         *
         * @param advertise New value for the property.
         */
        public Builder setAdvertise(java.lang.Boolean advertise) {
            this.advertise = advertise;
            return this;
        }

        /**
         * OSPF Summary address in CIDR format format: ip-cidr-block
         *
         * @param prefix New value for the property.
         */
        public Builder setPrefix(java.lang.String prefix) {
            this.prefix = prefix;
            return this;
        }

        public OspfSummaryAddressConfig build() {
            OspfSummaryAddressConfig result = new OspfSummaryAddressConfig();
            result.setAdvertise(this.advertise);
            result.setPrefix(this.prefix);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("advertise", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("advertise",
                                                                                "advertise",
                                                                                "getAdvertise",
                                                                                "setAdvertise");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("prefix", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("prefix",
                                                                                "prefix",
                                                                                "getPrefix",
                                                                                "setPrefix");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.ospf_summary_address_config",
                                                            fields,
                                                            com.vmware.nsx_policy.model.OspfSummaryAddressConfig.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

