/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

public final class PolicyBgpNeighborStatus implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String CONNECTION_STATE_INVALID = "INVALID";

    public static final java.lang.String CONNECTION_STATE_IDLE = "IDLE";

    public static final java.lang.String CONNECTION_STATE_CONNECT = "CONNECT";

    public static final java.lang.String CONNECTION_STATE_ACTIVE = "ACTIVE";

    public static final java.lang.String CONNECTION_STATE_OPEN_SENT = "OPEN_SENT";

    public static final java.lang.String CONNECTION_STATE_OPEN_CONFIRM = "OPEN_CONFIRM";

    public static final java.lang.String CONNECTION_STATE_ESTABLISHED = "ESTABLISHED";

    public static final java.lang.String CONNECTION_STATE_UNKNOWN = "UNKNOWN";

    public static final java.lang.String TYPE_INTER_SR = "INTER_SR";

    public static final java.lang.String TYPE_USER = "USER";

    private java.util.List<com.vmware.nsx_policy.model.BgpAddressFamily> addressFamilies;

    private java.util.List<java.lang.String> announcedCapabilities;

    private java.lang.Long connectionDropCount;

    private java.lang.String connectionState;

    private java.lang.String edgePath;

    private java.lang.Long establishedConnectionCount;

    private java.lang.String gracefulRestartMode;

    private java.lang.Long holdTime;

    private java.lang.Long keepAliveInterval;

    private java.lang.Long lastUpdateTimestamp;

    private java.lang.Long localPort;

    private java.lang.Long messagesReceived;

    private java.lang.Long messagesSent;

    private java.util.List<java.lang.String> negotiatedCapability;

    private java.lang.String neighborAddress;

    private java.lang.String neighborRouterId;

    private java.lang.String remoteAsNumber;

    private java.lang.Long remotePort;

    private com.vmware.nsx_policy.model.ResourceReference remoteSite;

    private java.lang.String sourceAddress;

    private java.lang.String tier0Path;

    private java.lang.Long timeSinceEstablished;

    private java.lang.Long totalInPrefixCount;

    private java.lang.Long totalOutPrefixCount;

    private java.lang.String type;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public PolicyBgpNeighborStatus() {
    }

    protected PolicyBgpNeighborStatus(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Address families of BGP neighbor
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx_policy.model.BgpAddressFamily> getAddressFamilies() {
        return this.addressFamilies;
    }

    /**
     * Address families of BGP neighbor
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param addressFamilies New value for the property.
     */
    public void setAddressFamilies(java.util.List<com.vmware.nsx_policy.model.BgpAddressFamily> addressFamilies) {
        this.addressFamilies = addressFamilies;
    }

    /**
     * BGP capabilities sent to BGP neighbor.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getAnnouncedCapabilities() {
        return this.announcedCapabilities;
    }

    /**
     * BGP capabilities sent to BGP neighbor.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param announcedCapabilities New value for the property.
     */
    public void setAnnouncedCapabilities(java.util.List<java.lang.String> announcedCapabilities) {
        this.announcedCapabilities = announcedCapabilities;
    }

    /**
     * Count of connection drop format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getConnectionDropCount() {
        return this.connectionDropCount;
    }

    /**
     * Count of connection drop format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param connectionDropCount New value for the property.
     */
    public void setConnectionDropCount(java.lang.Long connectionDropCount) {
        this.connectionDropCount = connectionDropCount;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.PolicyBgpNeighborStatus#CONNECTION_STATE_INVALID}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.PolicyBgpNeighborStatus#CONNECTION_STATE_IDLE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.PolicyBgpNeighborStatus#CONNECTION_STATE_CONNECT}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.PolicyBgpNeighborStatus#CONNECTION_STATE_ACTIVE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.PolicyBgpNeighborStatus#CONNECTION_STATE_OPEN_SENT}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.PolicyBgpNeighborStatus#CONNECTION_STATE_OPEN_CONFIRM}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.PolicyBgpNeighborStatus#CONNECTION_STATE_ESTABLISHED}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.PolicyBgpNeighborStatus#CONNECTION_STATE_UNKNOWN}</li>
     * </ul> Current state of the BGP session.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getConnectionState() {
        return this.connectionState;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.PolicyBgpNeighborStatus#CONNECTION_STATE_INVALID}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.PolicyBgpNeighborStatus#CONNECTION_STATE_IDLE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.PolicyBgpNeighborStatus#CONNECTION_STATE_CONNECT}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.PolicyBgpNeighborStatus#CONNECTION_STATE_ACTIVE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.PolicyBgpNeighborStatus#CONNECTION_STATE_OPEN_SENT}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.PolicyBgpNeighborStatus#CONNECTION_STATE_OPEN_CONFIRM}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.PolicyBgpNeighborStatus#CONNECTION_STATE_ESTABLISHED}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.PolicyBgpNeighborStatus#CONNECTION_STATE_UNKNOWN}</li>
     * </ul> Current state of the BGP session.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param connectionState New value for the property.
     */
    public void setConnectionState(java.lang.String connectionState) {
        this.connectionState = connectionState;
    }

    /**
     * Transport node policy path
     *
     * @return The current value of the property.
     */
    public java.lang.String getEdgePath() {
        return this.edgePath;
    }

    /**
     * Transport node policy path
     *
     * @param edgePath New value for the property.
     */
    public void setEdgePath(java.lang.String edgePath) {
        this.edgePath = edgePath;
    }

    /**
     * Count of connections established format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getEstablishedConnectionCount() {
        return this.establishedConnectionCount;
    }

    /**
     * Count of connections established format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param establishedConnectionCount New value for the property.
     */
    public void setEstablishedConnectionCount(java.lang.Long establishedConnectionCount) {
        this.establishedConnectionCount = establishedConnectionCount;
    }

    /**
     * Current state of graceful restart of BGP neighbor. Possible values are - 1.
     * GR_AND_HELPER - Graceful restart with Helper 2. HELPER_ONLY - Helper only 3.
     * DISABLE - Disabled
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getGracefulRestartMode() {
        return this.gracefulRestartMode;
    }

    /**
     * Current state of graceful restart of BGP neighbor. Possible values are - 1.
     * GR_AND_HELPER - Graceful restart with Helper 2. HELPER_ONLY - Helper only 3.
     * DISABLE - Disabled
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param gracefulRestartMode New value for the property.
     */
    public void setGracefulRestartMode(java.lang.String gracefulRestartMode) {
        this.gracefulRestartMode = gracefulRestartMode;
    }

    /**
     * If a HELLO packet is not seen from BGP Peer withing hold_time then BGP neighbor
     * will be marked as down. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getHoldTime() {
        return this.holdTime;
    }

    /**
     * If a HELLO packet is not seen from BGP Peer withing hold_time then BGP neighbor
     * will be marked as down. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param holdTime New value for the property.
     */
    public void setHoldTime(java.lang.Long holdTime) {
        this.holdTime = holdTime;
    }

    /**
     * Time in ms to wait for HELLO packet from BGP peer format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getKeepAliveInterval() {
        return this.keepAliveInterval;
    }

    /**
     * Time in ms to wait for HELLO packet from BGP peer format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param keepAliveInterval New value for the property.
     */
    public void setKeepAliveInterval(java.lang.Long keepAliveInterval) {
        this.keepAliveInterval = keepAliveInterval;
    }

    /**
     * Timestamp when the data was last updated, unset if data source has never updated
     * the data. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getLastUpdateTimestamp() {
        return this.lastUpdateTimestamp;
    }

    /**
     * Timestamp when the data was last updated, unset if data source has never updated
     * the data. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param lastUpdateTimestamp New value for the property.
     */
    public void setLastUpdateTimestamp(java.lang.Long lastUpdateTimestamp) {
        this.lastUpdateTimestamp = lastUpdateTimestamp;
    }

    /**
     * TCP port number of Local BGP connection format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getLocalPort() {
        return this.localPort;
    }

    /**
     * TCP port number of Local BGP connection format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param localPort New value for the property.
     */
    public void setLocalPort(java.lang.Long localPort) {
        this.localPort = localPort;
    }

    /**
     * Count of messages received from the neighbor format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getMessagesReceived() {
        return this.messagesReceived;
    }

    /**
     * Count of messages received from the neighbor format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param messagesReceived New value for the property.
     */
    public void setMessagesReceived(java.lang.Long messagesReceived) {
        this.messagesReceived = messagesReceived;
    }

    /**
     * Count of messages sent to the neighbor format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getMessagesSent() {
        return this.messagesSent;
    }

    /**
     * Count of messages sent to the neighbor format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param messagesSent New value for the property.
     */
    public void setMessagesSent(java.lang.Long messagesSent) {
        this.messagesSent = messagesSent;
    }

    /**
     * BGP capabilities negotiated with BGP neighbor.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getNegotiatedCapability() {
        return this.negotiatedCapability;
    }

    /**
     * BGP capabilities negotiated with BGP neighbor.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param negotiatedCapability New value for the property.
     */
    public void setNegotiatedCapability(java.util.List<java.lang.String> negotiatedCapability) {
        this.negotiatedCapability = negotiatedCapability;
    }

    /**
     * The IP of the BGP neighbor format: ip
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getNeighborAddress() {
        return this.neighborAddress;
    }

    /**
     * The IP of the BGP neighbor format: ip
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param neighborAddress New value for the property.
     */
    public void setNeighborAddress(java.lang.String neighborAddress) {
        this.neighborAddress = neighborAddress;
    }

    /**
     * Router ID of the BGP neighbor.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getNeighborRouterId() {
        return this.neighborRouterId;
    }

    /**
     * Router ID of the BGP neighbor.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param neighborRouterId New value for the property.
     */
    public void setNeighborRouterId(java.lang.String neighborRouterId) {
        this.neighborRouterId = neighborRouterId;
    }

    /**
     * AS number of the BGP neighbor
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getRemoteAsNumber() {
        return this.remoteAsNumber;
    }

    /**
     * AS number of the BGP neighbor
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param remoteAsNumber New value for the property.
     */
    public void setRemoteAsNumber(java.lang.String remoteAsNumber) {
        this.remoteAsNumber = remoteAsNumber;
    }

    /**
     * TCP port number of remote BGP Connection format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getRemotePort() {
        return this.remotePort;
    }

    /**
     * TCP port number of remote BGP Connection format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param remotePort New value for the property.
     */
    public void setRemotePort(java.lang.Long remotePort) {
        this.remotePort = remotePort;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx_policy.model.ResourceReference getRemoteSite() {
        return this.remoteSite;
    }

    /**
     *
     *
     * @param remoteSite New value for the property.
     */
    public void setRemoteSite(com.vmware.nsx_policy.model.ResourceReference remoteSite) {
        this.remoteSite = remoteSite;
    }

    /**
     * The Ip address of logical port format: ip
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getSourceAddress() {
        return this.sourceAddress;
    }

    /**
     * The Ip address of logical port format: ip
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param sourceAddress New value for the property.
     */
    public void setSourceAddress(java.lang.String sourceAddress) {
        this.sourceAddress = sourceAddress;
    }

    /**
     * Policy path to Tier0
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getTier0Path() {
        return this.tier0Path;
    }

    /**
     * Policy path to Tier0
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param tier0Path New value for the property.
     */
    public void setTier0Path(java.lang.String tier0Path) {
        this.tier0Path = tier0Path;
    }

    /**
     * Time(in seconds) since connection was established. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getTimeSinceEstablished() {
        return this.timeSinceEstablished;
    }

    /**
     * Time(in seconds) since connection was established. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param timeSinceEstablished New value for the property.
     */
    public void setTimeSinceEstablished(java.lang.Long timeSinceEstablished) {
        this.timeSinceEstablished = timeSinceEstablished;
    }

    /**
     * Sum of in prefixes counts across all address families. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getTotalInPrefixCount() {
        return this.totalInPrefixCount;
    }

    /**
     * Sum of in prefixes counts across all address families. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param totalInPrefixCount New value for the property.
     */
    public void setTotalInPrefixCount(java.lang.Long totalInPrefixCount) {
        this.totalInPrefixCount = totalInPrefixCount;
    }

    /**
     * Sum of out prefixes counts across all address families. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getTotalOutPrefixCount() {
        return this.totalOutPrefixCount;
    }

    /**
     * Sum of out prefixes counts across all address families. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param totalOutPrefixCount New value for the property.
     */
    public void setTotalOutPrefixCount(java.lang.Long totalOutPrefixCount) {
        this.totalOutPrefixCount = totalOutPrefixCount;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.PolicyBgpNeighborStatus#TYPE_INTER_SR}</li> <li>
     * {@link com.vmware.nsx_policy.model.PolicyBgpNeighborStatus#TYPE_USER}</li> </ul>
     * BGP neighbor type
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getType() {
        return this.type;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.PolicyBgpNeighborStatus#TYPE_INTER_SR}</li> <li>
     * {@link com.vmware.nsx_policy.model.PolicyBgpNeighborStatus#TYPE_USER}</li> </ul>
     * BGP neighbor type
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param type New value for the property.
     */
    public void setType(java.lang.String type) {
        this.type = type;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.policyBgpNeighborStatus;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("address_families",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.addressFamilies, this._getType().getField("address_families")));
        structValue.setField("announced_capabilities",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.announcedCapabilities, this._getType().getField("announced_capabilities")));
        structValue.setField("connection_drop_count",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.connectionDropCount, this._getType().getField("connection_drop_count")));
        structValue.setField("connection_state",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.connectionState, this._getType().getField("connection_state")));
        structValue.setField("edge_path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.edgePath, this._getType().getField("edge_path")));
        structValue.setField("established_connection_count",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.establishedConnectionCount, this._getType().getField("established_connection_count")));
        structValue.setField("graceful_restart_mode",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.gracefulRestartMode, this._getType().getField("graceful_restart_mode")));
        structValue.setField("hold_time",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.holdTime, this._getType().getField("hold_time")));
        structValue.setField("keep_alive_interval",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.keepAliveInterval, this._getType().getField("keep_alive_interval")));
        structValue.setField("last_update_timestamp",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.lastUpdateTimestamp, this._getType().getField("last_update_timestamp")));
        structValue.setField("local_port",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.localPort, this._getType().getField("local_port")));
        structValue.setField("messages_received",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.messagesReceived, this._getType().getField("messages_received")));
        structValue.setField("messages_sent",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.messagesSent, this._getType().getField("messages_sent")));
        structValue.setField("negotiated_capability",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.negotiatedCapability, this._getType().getField("negotiated_capability")));
        structValue.setField("neighbor_address",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.neighborAddress, this._getType().getField("neighbor_address")));
        structValue.setField("neighbor_router_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.neighborRouterId, this._getType().getField("neighbor_router_id")));
        structValue.setField("remote_as_number",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.remoteAsNumber, this._getType().getField("remote_as_number")));
        structValue.setField("remote_port",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.remotePort, this._getType().getField("remote_port")));
        structValue.setField("remote_site",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.remoteSite, this._getType().getField("remote_site")));
        structValue.setField("source_address",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.sourceAddress, this._getType().getField("source_address")));
        structValue.setField("tier0_path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.tier0Path, this._getType().getField("tier0_path")));
        structValue.setField("time_since_established",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.timeSinceEstablished, this._getType().getField("time_since_established")));
        structValue.setField("total_in_prefix_count",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.totalInPrefixCount, this._getType().getField("total_in_prefix_count")));
        structValue.setField("total_out_prefix_count",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.totalOutPrefixCount, this._getType().getField("total_out_prefix_count")));
        structValue.setField("type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.type, this._getType().getField("type")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.policyBgpNeighborStatus;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.policyBgpNeighborStatus.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static PolicyBgpNeighborStatus _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new PolicyBgpNeighborStatus(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static PolicyBgpNeighborStatus _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new PolicyBgpNeighborStatus(structValue);
    }

    /**
     * Builder class for {@link PolicyBgpNeighborStatus}.
     */
    public static final class Builder {
        private java.util.List<com.vmware.nsx_policy.model.BgpAddressFamily> addressFamilies;
        private java.util.List<java.lang.String> announcedCapabilities;
        private java.lang.Long connectionDropCount;
        private java.lang.String connectionState;
        private java.lang.String edgePath;
        private java.lang.Long establishedConnectionCount;
        private java.lang.String gracefulRestartMode;
        private java.lang.Long holdTime;
        private java.lang.Long keepAliveInterval;
        private java.lang.Long lastUpdateTimestamp;
        private java.lang.Long localPort;
        private java.lang.Long messagesReceived;
        private java.lang.Long messagesSent;
        private java.util.List<java.lang.String> negotiatedCapability;
        private java.lang.String neighborAddress;
        private java.lang.String neighborRouterId;
        private java.lang.String remoteAsNumber;
        private java.lang.Long remotePort;
        private com.vmware.nsx_policy.model.ResourceReference remoteSite;
        private java.lang.String sourceAddress;
        private java.lang.String tier0Path;
        private java.lang.Long timeSinceEstablished;
        private java.lang.Long totalInPrefixCount;
        private java.lang.Long totalOutPrefixCount;
        private java.lang.String type;

        /**
         * Constructor with parameters for the required properties of
         * {@link PolicyBgpNeighborStatus}.
         */
        public Builder() {
        }

        /**
         * Address families of BGP neighbor
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param addressFamilies New value for the property.
         */
        public Builder setAddressFamilies(java.util.List<com.vmware.nsx_policy.model.BgpAddressFamily> addressFamilies) {
            this.addressFamilies = addressFamilies;
            return this;
        }

        /**
         * BGP capabilities sent to BGP neighbor.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param announcedCapabilities New value for the property.
         */
        public Builder setAnnouncedCapabilities(java.util.List<java.lang.String> announcedCapabilities) {
            this.announcedCapabilities = announcedCapabilities;
            return this;
        }

        /**
         * Count of connection drop format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param connectionDropCount New value for the property.
         */
        public Builder setConnectionDropCount(java.lang.Long connectionDropCount) {
            this.connectionDropCount = connectionDropCount;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.PolicyBgpNeighborStatus#CONNECTION_STATE_INVALID}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.PolicyBgpNeighborStatus#CONNECTION_STATE_IDLE}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.PolicyBgpNeighborStatus#CONNECTION_STATE_CONNECT}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.PolicyBgpNeighborStatus#CONNECTION_STATE_ACTIVE}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.PolicyBgpNeighborStatus#CONNECTION_STATE_OPEN_SENT}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.PolicyBgpNeighborStatus#CONNECTION_STATE_OPEN_CONFIRM}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.PolicyBgpNeighborStatus#CONNECTION_STATE_ESTABLISHED}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.PolicyBgpNeighborStatus#CONNECTION_STATE_UNKNOWN}</li>
         * </ul> Current state of the BGP session.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param connectionState New value for the property.
         */
        public Builder setConnectionState(java.lang.String connectionState) {
            this.connectionState = connectionState;
            return this;
        }

        /**
         * Transport node policy path
         *
         * @param edgePath New value for the property.
         */
        public Builder setEdgePath(java.lang.String edgePath) {
            this.edgePath = edgePath;
            return this;
        }

        /**
         * Count of connections established format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param establishedConnectionCount New value for the property.
         */
        public Builder setEstablishedConnectionCount(java.lang.Long establishedConnectionCount) {
            this.establishedConnectionCount = establishedConnectionCount;
            return this;
        }

        /**
         * Current state of graceful restart of BGP neighbor. Possible values are - 1.
         * GR_AND_HELPER - Graceful restart with Helper 2. HELPER_ONLY - Helper only 3.
         * DISABLE - Disabled
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param gracefulRestartMode New value for the property.
         */
        public Builder setGracefulRestartMode(java.lang.String gracefulRestartMode) {
            this.gracefulRestartMode = gracefulRestartMode;
            return this;
        }

        /**
         * If a HELLO packet is not seen from BGP Peer withing hold_time then BGP neighbor
         * will be marked as down. format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param holdTime New value for the property.
         */
        public Builder setHoldTime(java.lang.Long holdTime) {
            this.holdTime = holdTime;
            return this;
        }

        /**
         * Time in ms to wait for HELLO packet from BGP peer format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param keepAliveInterval New value for the property.
         */
        public Builder setKeepAliveInterval(java.lang.Long keepAliveInterval) {
            this.keepAliveInterval = keepAliveInterval;
            return this;
        }

        /**
         * Timestamp when the data was last updated, unset if data source has never updated
         * the data. format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param lastUpdateTimestamp New value for the property.
         */
        public Builder setLastUpdateTimestamp(java.lang.Long lastUpdateTimestamp) {
            this.lastUpdateTimestamp = lastUpdateTimestamp;
            return this;
        }

        /**
         * TCP port number of Local BGP connection format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param localPort New value for the property.
         */
        public Builder setLocalPort(java.lang.Long localPort) {
            this.localPort = localPort;
            return this;
        }

        /**
         * Count of messages received from the neighbor format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param messagesReceived New value for the property.
         */
        public Builder setMessagesReceived(java.lang.Long messagesReceived) {
            this.messagesReceived = messagesReceived;
            return this;
        }

        /**
         * Count of messages sent to the neighbor format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param messagesSent New value for the property.
         */
        public Builder setMessagesSent(java.lang.Long messagesSent) {
            this.messagesSent = messagesSent;
            return this;
        }

        /**
         * BGP capabilities negotiated with BGP neighbor.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param negotiatedCapability New value for the property.
         */
        public Builder setNegotiatedCapability(java.util.List<java.lang.String> negotiatedCapability) {
            this.negotiatedCapability = negotiatedCapability;
            return this;
        }

        /**
         * The IP of the BGP neighbor format: ip
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param neighborAddress New value for the property.
         */
        public Builder setNeighborAddress(java.lang.String neighborAddress) {
            this.neighborAddress = neighborAddress;
            return this;
        }

        /**
         * Router ID of the BGP neighbor.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param neighborRouterId New value for the property.
         */
        public Builder setNeighborRouterId(java.lang.String neighborRouterId) {
            this.neighborRouterId = neighborRouterId;
            return this;
        }

        /**
         * AS number of the BGP neighbor
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param remoteAsNumber New value for the property.
         */
        public Builder setRemoteAsNumber(java.lang.String remoteAsNumber) {
            this.remoteAsNumber = remoteAsNumber;
            return this;
        }

        /**
         * TCP port number of remote BGP Connection format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param remotePort New value for the property.
         */
        public Builder setRemotePort(java.lang.Long remotePort) {
            this.remotePort = remotePort;
            return this;
        }

        /**
         *
         *
         * @param remoteSite New value for the property.
         */
        public Builder setRemoteSite(com.vmware.nsx_policy.model.ResourceReference remoteSite) {
            this.remoteSite = remoteSite;
            return this;
        }

        /**
         * The Ip address of logical port format: ip
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param sourceAddress New value for the property.
         */
        public Builder setSourceAddress(java.lang.String sourceAddress) {
            this.sourceAddress = sourceAddress;
            return this;
        }

        /**
         * Policy path to Tier0
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param tier0Path New value for the property.
         */
        public Builder setTier0Path(java.lang.String tier0Path) {
            this.tier0Path = tier0Path;
            return this;
        }

        /**
         * Time(in seconds) since connection was established. format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param timeSinceEstablished New value for the property.
         */
        public Builder setTimeSinceEstablished(java.lang.Long timeSinceEstablished) {
            this.timeSinceEstablished = timeSinceEstablished;
            return this;
        }

        /**
         * Sum of in prefixes counts across all address families. format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param totalInPrefixCount New value for the property.
         */
        public Builder setTotalInPrefixCount(java.lang.Long totalInPrefixCount) {
            this.totalInPrefixCount = totalInPrefixCount;
            return this;
        }

        /**
         * Sum of out prefixes counts across all address families. format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param totalOutPrefixCount New value for the property.
         */
        public Builder setTotalOutPrefixCount(java.lang.Long totalOutPrefixCount) {
            this.totalOutPrefixCount = totalOutPrefixCount;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.PolicyBgpNeighborStatus#TYPE_INTER_SR}</li> <li>
         * {@link com.vmware.nsx_policy.model.PolicyBgpNeighborStatus#TYPE_USER}</li> </ul>
         * BGP neighbor type
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param type New value for the property.
         */
        public Builder setType(java.lang.String type) {
            this.type = type;
            return this;
        }

        public PolicyBgpNeighborStatus build() {
            PolicyBgpNeighborStatus result = new PolicyBgpNeighborStatus();
            result.setAddressFamilies(this.addressFamilies);
            result.setAnnouncedCapabilities(this.announcedCapabilities);
            result.setConnectionDropCount(this.connectionDropCount);
            result.setConnectionState(this.connectionState);
            result.setEdgePath(this.edgePath);
            result.setEstablishedConnectionCount(this.establishedConnectionCount);
            result.setGracefulRestartMode(this.gracefulRestartMode);
            result.setHoldTime(this.holdTime);
            result.setKeepAliveInterval(this.keepAliveInterval);
            result.setLastUpdateTimestamp(this.lastUpdateTimestamp);
            result.setLocalPort(this.localPort);
            result.setMessagesReceived(this.messagesReceived);
            result.setMessagesSent(this.messagesSent);
            result.setNegotiatedCapability(this.negotiatedCapability);
            result.setNeighborAddress(this.neighborAddress);
            result.setNeighborRouterId(this.neighborRouterId);
            result.setRemoteAsNumber(this.remoteAsNumber);
            result.setRemotePort(this.remotePort);
            result.setRemoteSite(this.remoteSite);
            result.setSourceAddress(this.sourceAddress);
            result.setTier0Path(this.tier0Path);
            result.setTimeSinceEstablished(this.timeSinceEstablished);
            result.setTotalInPrefixCount(this.totalInPrefixCount);
            result.setTotalOutPrefixCount(this.totalOutPrefixCount);
            result.setType(this.type);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("address_families", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.bgpAddressFamily; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("address_families",
                                                                                "addressFamilies",
                                                                                "getAddressFamilies",
                                                                                "setAddressFamilies");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("announced_capabilities", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("announced_capabilities",
                                                                                "announcedCapabilities",
                                                                                "getAnnouncedCapabilities",
                                                                                "setAnnouncedCapabilities");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("connection_drop_count", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("connection_drop_count",
                                                                                "connectionDropCount",
                                                                                "getConnectionDropCount",
                                                                                "setConnectionDropCount");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("connection_state", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("connection_state",
                                                                                "connectionState",
                                                                                "getConnectionState",
                                                                                "setConnectionState");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("edge_path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("edge_path",
                                                                                "edgePath",
                                                                                "getEdgePath",
                                                                                "setEdgePath");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("established_connection_count", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("established_connection_count",
                                                                                "establishedConnectionCount",
                                                                                "getEstablishedConnectionCount",
                                                                                "setEstablishedConnectionCount");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("graceful_restart_mode", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("graceful_restart_mode",
                                                                                "gracefulRestartMode",
                                                                                "getGracefulRestartMode",
                                                                                "setGracefulRestartMode");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("hold_time", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("hold_time",
                                                                                "holdTime",
                                                                                "getHoldTime",
                                                                                "setHoldTime");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("keep_alive_interval", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("keep_alive_interval",
                                                                                "keepAliveInterval",
                                                                                "getKeepAliveInterval",
                                                                                "setKeepAliveInterval");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("last_update_timestamp", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("last_update_timestamp",
                                                                                "lastUpdateTimestamp",
                                                                                "getLastUpdateTimestamp",
                                                                                "setLastUpdateTimestamp");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("local_port", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("local_port",
                                                                                "localPort",
                                                                                "getLocalPort",
                                                                                "setLocalPort");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("messages_received", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("messages_received",
                                                                                "messagesReceived",
                                                                                "getMessagesReceived",
                                                                                "setMessagesReceived");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("messages_sent", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("messages_sent",
                                                                                "messagesSent",
                                                                                "getMessagesSent",
                                                                                "setMessagesSent");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("negotiated_capability", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("negotiated_capability",
                                                                                "negotiatedCapability",
                                                                                "getNegotiatedCapability",
                                                                                "setNegotiatedCapability");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("neighbor_address", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("neighbor_address",
                                                                                "neighborAddress",
                                                                                "getNeighborAddress",
                                                                                "setNeighborAddress");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("neighbor_router_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("neighbor_router_id",
                                                                                "neighborRouterId",
                                                                                "getNeighborRouterId",
                                                                                "setNeighborRouterId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("remote_as_number", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("remote_as_number",
                                                                                "remoteAsNumber",
                                                                                "getRemoteAsNumber",
                                                                                "setRemoteAsNumber");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("remote_port", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("remote_port",
                                                                                "remotePort",
                                                                                "getRemotePort",
                                                                                "setRemotePort");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("remote_site", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.resourceReference; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("remote_site",
                                                                                "remoteSite",
                                                                                "getRemoteSite",
                                                                                "setRemoteSite");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("source_address", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("source_address",
                                                                                "sourceAddress",
                                                                                "getSourceAddress",
                                                                                "setSourceAddress");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("tier0_path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("tier0_path",
                                                                                "tier0Path",
                                                                                "getTier0Path",
                                                                                "setTier0Path");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("time_since_established", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("time_since_established",
                                                                                "timeSinceEstablished",
                                                                                "getTimeSinceEstablished",
                                                                                "setTimeSinceEstablished");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("total_in_prefix_count", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("total_in_prefix_count",
                                                                                "totalInPrefixCount",
                                                                                "getTotalInPrefixCount",
                                                                                "setTotalInPrefixCount");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("total_out_prefix_count", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("total_out_prefix_count",
                                                                                "totalOutPrefixCount",
                                                                                "getTotalOutPrefixCount",
                                                                                "setTotalOutPrefixCount");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("type", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("type",
                                                                                "type",
                                                                                "getType",
                                                                                "setType");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.policy_bgp_neighbor_status",
                                                            fields,
                                                            com.vmware.nsx_policy.model.PolicyBgpNeighborStatus.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

