/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * Route advertisement rules and filtering
 */
public final class RouteAdvertisementRule implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String ACTION_PERMIT = "PERMIT";

    public static final java.lang.String ACTION_DENY = "DENY";

    public static final java.lang.String PREFIX_OPERATOR_GE = "GE";

    public static final java.lang.String PREFIX_OPERATOR_EQ = "EQ";

    public static final java.lang.String ROUTE_ADVERTISEMENT_TYPES_STATIC_ROUTES = "TIER1_STATIC_ROUTES";

    public static final java.lang.String ROUTE_ADVERTISEMENT_TYPES_CONNECTED = "TIER1_CONNECTED";

    public static final java.lang.String ROUTE_ADVERTISEMENT_TYPES_NAT = "TIER1_NAT";

    public static final java.lang.String ROUTE_ADVERTISEMENT_TYPES_LB_VIP = "TIER1_LB_VIP";

    public static final java.lang.String ROUTE_ADVERTISEMENT_TYPES_LB_SNAT = "TIER1_LB_SNAT";

    public static final java.lang.String ROUTE_ADVERTISEMENT_TYPES_DNS_FORWARDER_IP = "TIER1_DNS_FORWARDER_IP";

    public static final java.lang.String ROUTE_ADVERTISEMENT_TYPES_IPSEC_LOCAL_ENDPOINT = "TIER1_IPSEC_LOCAL_ENDPOINT";

    private java.lang.String action;

    private java.lang.String name;

    private java.lang.String prefixOperator;

    private java.util.List<java.lang.String> routeAdvertisementTypes;

    private java.util.List<java.lang.String> subnets;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public RouteAdvertisementRule() {
    }

    protected RouteAdvertisementRule(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.RouteAdvertisementRule#ACTION_PERMIT}</li> <li>
     * {@link com.vmware.nsx_policy.model.RouteAdvertisementRule#ACTION_DENY}</li>
     * </ul> Action to advertise filtered routes to the connected Tier0 gateway.
     * PERMIT: Enables the advertisment DENY: Disables the advertisement
     *
     * @return The current value of the property.
     */
    public java.lang.String getAction() {
        return this.action;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.RouteAdvertisementRule#ACTION_PERMIT}</li> <li>
     * {@link com.vmware.nsx_policy.model.RouteAdvertisementRule#ACTION_DENY}</li>
     * </ul> Action to advertise filtered routes to the connected Tier0 gateway.
     * PERMIT: Enables the advertisment DENY: Disables the advertisement
     *
     * @param action New value for the property.
     */
    public void setAction(java.lang.String action) {
        this.action = action;
    }

    /**
     * Display name should be unique.
     *
     * @return The current value of the property.
     */
    public java.lang.String getName() {
        return this.name;
    }

    /**
     * Display name should be unique.
     *
     * @param name New value for the property.
     */
    public void setName(java.lang.String name) {
        this.name = name;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.RouteAdvertisementRule#PREFIX_OPERATOR_GE}</li> <li>
     * {@link
     * com.vmware.nsx_policy.model.RouteAdvertisementRule#PREFIX_OPERATOR_EQ}</li>
     * </ul> Prefix operator to filter subnets. GE prefix operator filters all the
     * routes with prefix length greater than or equal to the subnets configured. EQ
     * prefix operator filter all the routes with prefix length equal to the subnets
     * configured.
     *
     * @return The current value of the property.
     */
    public java.lang.String getPrefixOperator() {
        return this.prefixOperator;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.RouteAdvertisementRule#PREFIX_OPERATOR_GE}</li> <li>
     * {@link
     * com.vmware.nsx_policy.model.RouteAdvertisementRule#PREFIX_OPERATOR_EQ}</li>
     * </ul> Prefix operator to filter subnets. GE prefix operator filters all the
     * routes with prefix length greater than or equal to the subnets configured. EQ
     * prefix operator filter all the routes with prefix length equal to the subnets
     * configured.
     *
     * @param prefixOperator New value for the property.
     */
    public void setPrefixOperator(java.lang.String prefixOperator) {
        this.prefixOperator = prefixOperator;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.RouteAdvertisementRule#ROUTE_ADVERTISEMENT_TYPES_STATIC_ROUTES}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.RouteAdvertisementRule#ROUTE_ADVERTISEMENT_TYPES_CONNECTED}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.RouteAdvertisementRule#ROUTE_ADVERTISEMENT_TYPES_NAT}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.RouteAdvertisementRule#ROUTE_ADVERTISEMENT_TYPES_LB_VIP}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.RouteAdvertisementRule#ROUTE_ADVERTISEMENT_TYPES_LB_SNAT}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.RouteAdvertisementRule#ROUTE_ADVERTISEMENT_TYPES_DNS_FORWARDER_IP}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.RouteAdvertisementRule#ROUTE_ADVERTISEMENT_TYPES_IPSEC_LOCAL_ENDPOINT}</li>
     * </ul> Enable different types of route advertisements. When not specified, routes
     * to IPSec VPN local-endpoint subnets (TIER1_IPSEC_LOCAL_ENDPOINT) are
     * automatically advertised.
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getRouteAdvertisementTypes() {
        return this.routeAdvertisementTypes;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.RouteAdvertisementRule#ROUTE_ADVERTISEMENT_TYPES_STATIC_ROUTES}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.RouteAdvertisementRule#ROUTE_ADVERTISEMENT_TYPES_CONNECTED}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.RouteAdvertisementRule#ROUTE_ADVERTISEMENT_TYPES_NAT}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.RouteAdvertisementRule#ROUTE_ADVERTISEMENT_TYPES_LB_VIP}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.RouteAdvertisementRule#ROUTE_ADVERTISEMENT_TYPES_LB_SNAT}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.RouteAdvertisementRule#ROUTE_ADVERTISEMENT_TYPES_DNS_FORWARDER_IP}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.RouteAdvertisementRule#ROUTE_ADVERTISEMENT_TYPES_IPSEC_LOCAL_ENDPOINT}</li>
     * </ul> Enable different types of route advertisements. When not specified, routes
     * to IPSec VPN local-endpoint subnets (TIER1_IPSEC_LOCAL_ENDPOINT) are
     * automatically advertised.
     *
     * @param routeAdvertisementTypes New value for the property.
     */
    public void setRouteAdvertisementTypes(java.util.List<java.lang.String> routeAdvertisementTypes) {
        this.routeAdvertisementTypes = routeAdvertisementTypes;
    }

    /**
     * Network CIDRs to be routed. format: ip-cidr-block
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getSubnets() {
        return this.subnets;
    }

    /**
     * Network CIDRs to be routed. format: ip-cidr-block
     *
     * @param subnets New value for the property.
     */
    public void setSubnets(java.util.List<java.lang.String> subnets) {
        this.subnets = subnets;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.routeAdvertisementRule;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("action",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.action, this._getType().getField("action")));
        structValue.setField("name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.name, this._getType().getField("name")));
        structValue.setField("prefix_operator",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.prefixOperator, this._getType().getField("prefix_operator")));
        structValue.setField("route_advertisement_types",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.routeAdvertisementTypes, this._getType().getField("route_advertisement_types")));
        structValue.setField("subnets",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.subnets, this._getType().getField("subnets")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.routeAdvertisementRule;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.routeAdvertisementRule.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static RouteAdvertisementRule _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new RouteAdvertisementRule(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static RouteAdvertisementRule _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new RouteAdvertisementRule(structValue);
    }

    /**
     * Builder class for {@link RouteAdvertisementRule}.
     */
    public static final class Builder {
        private java.lang.String action;
        private java.lang.String name;
        private java.lang.String prefixOperator;
        private java.util.List<java.lang.String> routeAdvertisementTypes;
        private java.util.List<java.lang.String> subnets;

        /**
         * Constructor with parameters for the required properties of
         * {@link RouteAdvertisementRule}.
         */
        public Builder() {
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.RouteAdvertisementRule#ACTION_PERMIT}</li> <li>
         * {@link com.vmware.nsx_policy.model.RouteAdvertisementRule#ACTION_DENY}</li>
         * </ul> Action to advertise filtered routes to the connected Tier0 gateway.
         * PERMIT: Enables the advertisment DENY: Disables the advertisement
         *
         * @param action New value for the property.
         */
        public Builder setAction(java.lang.String action) {
            this.action = action;
            return this;
        }

        /**
         * Display name should be unique.
         *
         * @param name New value for the property.
         */
        public Builder setName(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.RouteAdvertisementRule#PREFIX_OPERATOR_GE}</li> <li>
         * {@link
         * com.vmware.nsx_policy.model.RouteAdvertisementRule#PREFIX_OPERATOR_EQ}</li>
         * </ul> Prefix operator to filter subnets. GE prefix operator filters all the
         * routes with prefix length greater than or equal to the subnets configured. EQ
         * prefix operator filter all the routes with prefix length equal to the subnets
         * configured.
         *
         * @param prefixOperator New value for the property.
         */
        public Builder setPrefixOperator(java.lang.String prefixOperator) {
            this.prefixOperator = prefixOperator;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.RouteAdvertisementRule#ROUTE_ADVERTISEMENT_TYPES_STATIC_ROUTES}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.RouteAdvertisementRule#ROUTE_ADVERTISEMENT_TYPES_CONNECTED}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.RouteAdvertisementRule#ROUTE_ADVERTISEMENT_TYPES_NAT}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.RouteAdvertisementRule#ROUTE_ADVERTISEMENT_TYPES_LB_VIP}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.RouteAdvertisementRule#ROUTE_ADVERTISEMENT_TYPES_LB_SNAT}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.RouteAdvertisementRule#ROUTE_ADVERTISEMENT_TYPES_DNS_FORWARDER_IP}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.RouteAdvertisementRule#ROUTE_ADVERTISEMENT_TYPES_IPSEC_LOCAL_ENDPOINT}</li>
         * </ul> Enable different types of route advertisements. When not specified, routes
         * to IPSec VPN local-endpoint subnets (TIER1_IPSEC_LOCAL_ENDPOINT) are
         * automatically advertised.
         *
         * @param routeAdvertisementTypes New value for the property.
         */
        public Builder setRouteAdvertisementTypes(java.util.List<java.lang.String> routeAdvertisementTypes) {
            this.routeAdvertisementTypes = routeAdvertisementTypes;
            return this;
        }

        /**
         * Network CIDRs to be routed. format: ip-cidr-block
         *
         * @param subnets New value for the property.
         */
        public Builder setSubnets(java.util.List<java.lang.String> subnets) {
            this.subnets = subnets;
            return this;
        }

        public RouteAdvertisementRule build() {
            RouteAdvertisementRule result = new RouteAdvertisementRule();
            result.setAction(this.action);
            result.setName(this.name);
            result.setPrefixOperator(this.prefixOperator);
            result.setRouteAdvertisementTypes(this.routeAdvertisementTypes);
            result.setSubnets(this.subnets);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("action", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("action",
                                                                                "action",
                                                                                "getAction",
                                                                                "setAction");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("name",
                                                                                "name",
                                                                                "getName",
                                                                                "setName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("prefix_operator", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("prefix_operator",
                                                                                "prefixOperator",
                                                                                "getPrefixOperator",
                                                                                "setPrefixOperator");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("route_advertisement_types", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("route_advertisement_types",
                                                                                "routeAdvertisementTypes",
                                                                                "getRouteAdvertisementTypes",
                                                                                "setRouteAdvertisementTypes");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("subnets", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("subnets",
                                                                                "subnets",
                                                                                "getSubnets",
                                                                                "setSubnets");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.route_advertisement_rule",
                                                            fields,
                                                            com.vmware.nsx_policy.model.RouteAdvertisementRule.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

