/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * IPSecVPN site specific attributes specified only on GM. This allows user to
 * specify site specific parameters which overrides the correspondig attributes in
 * the IPSecVpnSession Object.
 */
public final class SiteOverride implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.lang.String localEndpointPath;

    private java.lang.String localeServicePath;

    private java.lang.String peerAddress;

    private java.lang.String peerId;

    private java.util.List<com.vmware.nsx_policy.model.IPSecVpnTunnelInterface> tunnelInterfaces;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public SiteOverride() {
    }

    protected SiteOverride(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Policy path referencing Local endpoint.
     *
     * @return The current value of the property.
     */
    public java.lang.String getLocalEndpointPath() {
        return this.localEndpointPath;
    }

    /**
     * Policy path referencing Local endpoint.
     *
     * @param localEndpointPath New value for the property.
     */
    public void setLocalEndpointPath(java.lang.String localEndpointPath) {
        this.localEndpointPath = localEndpointPath;
    }

    /**
     * Policy path referencing LocateService where SiteOverride attributes will be
     * applied
     *
     * @return The current value of the property.
     */
    public java.lang.String getLocaleServicePath() {
        return this.localeServicePath;
    }

    /**
     * Policy path referencing LocateService where SiteOverride attributes will be
     * applied
     *
     * @param localeServicePath New value for the property.
     */
    public void setLocaleServicePath(java.lang.String localeServicePath) {
        this.localeServicePath = localeServicePath;
    }

    /**
     * Public IPV4 or IPV6 address of the remote device terminating the VPN connection.
     * Please note that configuring peer_address as IPv6 address is not supported in
     * the deprecated IPSecVpnSession Patch/PUT APIs. format: ip
     *
     * @return The current value of the property.
     */
    public java.lang.String getPeerAddress() {
        return this.peerAddress;
    }

    /**
     * Public IPV4 or IPV6 address of the remote device terminating the VPN connection.
     * Please note that configuring peer_address as IPv6 address is not supported in
     * the deprecated IPSecVpnSession Patch/PUT APIs. format: ip
     *
     * @param peerAddress New value for the property.
     */
    public void setPeerAddress(java.lang.String peerAddress) {
        this.peerAddress = peerAddress;
    }

    /**
     * Peer ID to uniquely identify the peer site. The peer ID is the public IP address
     * of the remote device terminating the VPN tunnel. When NAT is configured for the
     * peer, enter the private IP address of the peer.
     *
     * @return The current value of the property.
     */
    public java.lang.String getPeerId() {
        return this.peerId;
    }

    /**
     * Peer ID to uniquely identify the peer site. The peer ID is the public IP address
     * of the remote device terminating the VPN tunnel. When NAT is configured for the
     * peer, enter the private IP address of the peer.
     *
     * @param peerId New value for the property.
     */
    public void setPeerId(java.lang.String peerId) {
        this.peerId = peerId;
    }

    /**
     * IP Tunnel interfaces. This property is mandatory for RouteBasedIpSecVpn session.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx_policy.model.IPSecVpnTunnelInterface> getTunnelInterfaces() {
        return this.tunnelInterfaces;
    }

    /**
     * IP Tunnel interfaces. This property is mandatory for RouteBasedIpSecVpn session.
     *
     * @param tunnelInterfaces New value for the property.
     */
    public void setTunnelInterfaces(java.util.List<com.vmware.nsx_policy.model.IPSecVpnTunnelInterface> tunnelInterfaces) {
        this.tunnelInterfaces = tunnelInterfaces;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.siteOverride;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("local_endpoint_path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.localEndpointPath, this._getType().getField("local_endpoint_path")));
        structValue.setField("locale_service_path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.localeServicePath, this._getType().getField("locale_service_path")));
        structValue.setField("peer_address",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.peerAddress, this._getType().getField("peer_address")));
        structValue.setField("peer_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.peerId, this._getType().getField("peer_id")));
        structValue.setField("tunnel_interfaces",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.tunnelInterfaces, this._getType().getField("tunnel_interfaces")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.siteOverride;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.siteOverride.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static SiteOverride _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new SiteOverride(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static SiteOverride _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new SiteOverride(structValue);
    }

    /**
     * Builder class for {@link SiteOverride}.
     */
    public static final class Builder {
        private java.lang.String localEndpointPath;
        private java.lang.String localeServicePath;
        private java.lang.String peerAddress;
        private java.lang.String peerId;
        private java.util.List<com.vmware.nsx_policy.model.IPSecVpnTunnelInterface> tunnelInterfaces;

        /**
         * Constructor with parameters for the required properties of
         * {@link SiteOverride}.
         */
        public Builder() {
        }

        /**
         * Policy path referencing Local endpoint.
         *
         * @param localEndpointPath New value for the property.
         */
        public Builder setLocalEndpointPath(java.lang.String localEndpointPath) {
            this.localEndpointPath = localEndpointPath;
            return this;
        }

        /**
         * Policy path referencing LocateService where SiteOverride attributes will be
         * applied
         *
         * @param localeServicePath New value for the property.
         */
        public Builder setLocaleServicePath(java.lang.String localeServicePath) {
            this.localeServicePath = localeServicePath;
            return this;
        }

        /**
         * Public IPV4 or IPV6 address of the remote device terminating the VPN connection.
         * Please note that configuring peer_address as IPv6 address is not supported in
         * the deprecated IPSecVpnSession Patch/PUT APIs. format: ip
         *
         * @param peerAddress New value for the property.
         */
        public Builder setPeerAddress(java.lang.String peerAddress) {
            this.peerAddress = peerAddress;
            return this;
        }

        /**
         * Peer ID to uniquely identify the peer site. The peer ID is the public IP address
         * of the remote device terminating the VPN tunnel. When NAT is configured for the
         * peer, enter the private IP address of the peer.
         *
         * @param peerId New value for the property.
         */
        public Builder setPeerId(java.lang.String peerId) {
            this.peerId = peerId;
            return this;
        }

        /**
         * IP Tunnel interfaces. This property is mandatory for RouteBasedIpSecVpn session.
         *
         * @param tunnelInterfaces New value for the property.
         */
        public Builder setTunnelInterfaces(java.util.List<com.vmware.nsx_policy.model.IPSecVpnTunnelInterface> tunnelInterfaces) {
            this.tunnelInterfaces = tunnelInterfaces;
            return this;
        }

        public SiteOverride build() {
            SiteOverride result = new SiteOverride();
            result.setLocalEndpointPath(this.localEndpointPath);
            result.setLocaleServicePath(this.localeServicePath);
            result.setPeerAddress(this.peerAddress);
            result.setPeerId(this.peerId);
            result.setTunnelInterfaces(this.tunnelInterfaces);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("local_endpoint_path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("local_endpoint_path",
                                                                                "localEndpointPath",
                                                                                "getLocalEndpointPath",
                                                                                "setLocalEndpointPath");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("locale_service_path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("locale_service_path",
                                                                                "localeServicePath",
                                                                                "getLocaleServicePath",
                                                                                "setLocaleServicePath");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("peer_address", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("peer_address",
                                                                                "peerAddress",
                                                                                "getPeerAddress",
                                                                                "setPeerAddress");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("peer_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("peer_id",
                                                                                "peerId",
                                                                                "getPeerId",
                                                                                "setPeerId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("tunnel_interfaces", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.IPSecVpnTunnelInterface; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("tunnel_interfaces",
                                                                                "tunnelInterfaces",
                                                                                "getTunnelInterfaces",
                                                                                "setTunnelInterfaces");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.site_override",
                                                            fields,
                                                            com.vmware.nsx_policy.model.SiteOverride.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

