/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * External inspection profile is used when the TLS connection is destined to a
 * service not owned by the enterprise.
 */
public final class TlsInspectionExternalProfile implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    /**
     * Identifier denoting this class, when it is used in polymorphic context. 
     * <p>This
     * value should be assigned to the property which is used to discriminate the
     * actual type used in the polymorphic context.</p>
     */
    public static final java.lang.String _TYPE_IDENTIFIER = "TlsInspectionExternalProfile";

    public static final java.lang.String CLIENT_CIPHER_SUITE_ECDHE_RSA_WITH_AES_128_GCM_SHA256 = "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256";

    public static final java.lang.String CLIENT_CIPHER_SUITE_ECDHE_RSA_WITH_AES_256_GCM_SHA384 = "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384";

    public static final java.lang.String CLIENT_CIPHER_SUITE_ECDHE_RSA_WITH_AES_128_CBC_SHA = "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA";

    public static final java.lang.String CLIENT_CIPHER_SUITE_ECDHE_RSA_WITH_AES_256_CBC_SHA = "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA";

    public static final java.lang.String CLIENT_CIPHER_SUITE_ECDHE_RSA_WITH_AES_128_CBC_SHA256 = "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256";

    public static final java.lang.String CLIENT_CIPHER_SUITE_ECDHE_RSA_WITH_AES_256_CBC_SHA384 = "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384";

    public static final java.lang.String CLIENT_CIPHER_SUITE_RSA_WITH_AES_128_GCM_SHA256 = "TLS_RSA_WITH_AES_128_GCM_SHA256";

    public static final java.lang.String CLIENT_CIPHER_SUITE_RSA_WITH_AES_128_CBC_SHA256 = "TLS_RSA_WITH_AES_128_CBC_SHA256";

    public static final java.lang.String CLIENT_CIPHER_SUITE_RSA_WITH_AES_256_GCM_SHA384 = "TLS_RSA_WITH_AES_256_GCM_SHA384";

    public static final java.lang.String CLIENT_CIPHER_SUITE_RSA_WITH_AES_256_CBC_SHA256 = "TLS_RSA_WITH_AES_256_CBC_SHA256";

    public static final java.lang.String CLIENT_CIPHER_SUITE_RSA_WITH_AES_256_CBC_SHA = "TLS_RSA_WITH_AES_256_CBC_SHA";

    public static final java.lang.String CLIENT_CIPHER_SUITE_RSA_WITH_AES_128_CBC_SHA = "TLS_RSA_WITH_AES_128_CBC_SHA";

    public static final java.lang.String CLIENT_MAX_TLS_VERSION_2 = "TLS_V1_2";

    public static final java.lang.String CLIENT_MAX_TLS_VERSION_1 = "TLS_V1_1";

    public static final java.lang.String CLIENT_MAX_TLS_VERSION_0 = "TLS_V1_0";

    public static final java.lang.String CLIENT_MIN_TLS_VERSION_2 = "TLS_V1_2";

    public static final java.lang.String CLIENT_MIN_TLS_VERSION_1 = "TLS_V1_1";

    public static final java.lang.String CLIENT_MIN_TLS_VERSION_0 = "TLS_V1_0";

    public static final java.lang.String CRYPTO_ENFORCEMENT_ENFORCE = "ENFORCE";

    public static final java.lang.String CRYPTO_ENFORCEMENT_TRANSPARENT = "TRANSPARENT";

    public static final java.lang.String DECRYPTION_FAIL_ACTION_BLOCK = "BLOCK";

    public static final java.lang.String DECRYPTION_FAIL_ACTION_BYPASS = "BYPASS";

    public static final java.lang.String INVALID_CERT_ACTION_BLOCK = "BLOCK";

    public static final java.lang.String INVALID_CERT_ACTION_ALLOW = "ALLOW";

    public static final java.lang.String SERVER_CIPHER_SUITE_ECDHE_RSA_WITH_AES_128_GCM_SHA256 = "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256";

    public static final java.lang.String SERVER_CIPHER_SUITE_ECDHE_RSA_WITH_AES_256_GCM_SHA384 = "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384";

    public static final java.lang.String SERVER_CIPHER_SUITE_ECDHE_RSA_WITH_AES_128_CBC_SHA = "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA";

    public static final java.lang.String SERVER_CIPHER_SUITE_ECDHE_RSA_WITH_AES_256_CBC_SHA = "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA";

    public static final java.lang.String SERVER_CIPHER_SUITE_ECDHE_RSA_WITH_AES_128_CBC_SHA256 = "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256";

    public static final java.lang.String SERVER_CIPHER_SUITE_ECDHE_RSA_WITH_AES_256_CBC_SHA384 = "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384";

    public static final java.lang.String SERVER_CIPHER_SUITE_RSA_WITH_AES_128_GCM_SHA256 = "TLS_RSA_WITH_AES_128_GCM_SHA256";

    public static final java.lang.String SERVER_CIPHER_SUITE_RSA_WITH_AES_128_CBC_SHA256 = "TLS_RSA_WITH_AES_128_CBC_SHA256";

    public static final java.lang.String SERVER_CIPHER_SUITE_RSA_WITH_AES_256_GCM_SHA384 = "TLS_RSA_WITH_AES_256_GCM_SHA384";

    public static final java.lang.String SERVER_CIPHER_SUITE_RSA_WITH_AES_256_CBC_SHA256 = "TLS_RSA_WITH_AES_256_CBC_SHA256";

    public static final java.lang.String SERVER_CIPHER_SUITE_RSA_WITH_AES_256_CBC_SHA = "TLS_RSA_WITH_AES_256_CBC_SHA";

    public static final java.lang.String SERVER_CIPHER_SUITE_RSA_WITH_AES_128_CBC_SHA = "TLS_RSA_WITH_AES_128_CBC_SHA";

    public static final java.lang.String SERVER_MAX_TLS_VERSION_2 = "TLS_V1_2";

    public static final java.lang.String SERVER_MAX_TLS_VERSION_1 = "TLS_V1_1";

    public static final java.lang.String SERVER_MAX_TLS_VERSION_0 = "TLS_V1_0";

    public static final java.lang.String SERVER_MIN_TLS_VERSION_2 = "TLS_V1_2";

    public static final java.lang.String SERVER_MIN_TLS_VERSION_1 = "TLS_V1_1";

    public static final java.lang.String SERVER_MIN_TLS_VERSION_0 = "TLS_V1_0";

    public static final java.lang.String TLS_CONFIG_SETTING_BALANCED = "BALANCED";

    public static final java.lang.String TLS_CONFIG_SETTING_HIGH_FIDELITY = "HIGH_FIDELITY";

    public static final java.lang.String TLS_CONFIG_SETTING_HIGH_SECURITY = "HIGH_SECURITY";

    public static final java.lang.String TLS_CONFIG_SETTING_CUSTOM = "CUSTOM";

    private java.util.List<java.lang.String> clientCipherSuite;

    private java.lang.String clientMaxTlsVersion;

    private java.lang.String clientMinTlsVersion;

    private java.lang.String cryptoEnforcement;

    private java.lang.String decryptionFailAction;

    private java.lang.String invalidCertAction;

    private java.lang.Boolean ocspMustStaple;

    private java.lang.String proxyTrustedCaCert;

    private java.lang.String proxyUntrustedCaCert;

    private java.util.List<java.lang.String> serverCipherSuite;

    private java.lang.String serverMaxTlsVersion;

    private java.lang.String serverMinTlsVersion;

    private java.lang.String tlsConfigSetting;

    private java.util.List<com.vmware.nsx_policy.model.ResourceLink> links;

    private java.lang.String schema;

    private com.vmware.nsx_policy.model.SelfResourceLink self;

    private java.lang.Long revision;

    private java.lang.Long createTime;

    private java.lang.String createUser;

    private java.lang.Long lastModifiedTime;

    private java.lang.String lastModifiedUser;

    private java.lang.String protection;

    private java.lang.Boolean systemOwned;

    private java.lang.String description;

    private java.lang.String displayName;

    private java.lang.String id;

    private final java.lang.String resourceType = "TlsInspectionExternalProfile";

    private java.util.List<com.vmware.nsx_policy.model.Tag> tags;

    private java.lang.String originSiteId;

    private java.lang.String ownerId;

    private java.lang.String parentPath;

    private java.lang.String path;

    private java.lang.String realizationId;

    private java.lang.String relativePath;

    private java.lang.String remotePath;

    private java.lang.String uniqueId;

    private java.util.List<com.vmware.vapi.bindings.Structure> children;

    private java.lang.Boolean markedForDelete;

    private java.lang.Boolean overridden;

    private java.lang.String attention;

    private java.util.List<java.lang.String> crls;

    private java.lang.Long idleConnectionTimeout;

    private java.util.List<java.lang.String> trustedCaBundles;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public TlsInspectionExternalProfile() {
    }

    protected TlsInspectionExternalProfile(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#CLIENT_CIPHER_SUITE_ECDHE_RSA_WITH_AES_128_GCM_SHA256}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#CLIENT_CIPHER_SUITE_ECDHE_RSA_WITH_AES_256_GCM_SHA384}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#CLIENT_CIPHER_SUITE_ECDHE_RSA_WITH_AES_128_CBC_SHA}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#CLIENT_CIPHER_SUITE_ECDHE_RSA_WITH_AES_256_CBC_SHA}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#CLIENT_CIPHER_SUITE_ECDHE_RSA_WITH_AES_128_CBC_SHA256}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#CLIENT_CIPHER_SUITE_ECDHE_RSA_WITH_AES_256_CBC_SHA384}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#CLIENT_CIPHER_SUITE_RSA_WITH_AES_128_GCM_SHA256}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#CLIENT_CIPHER_SUITE_RSA_WITH_AES_128_CBC_SHA256}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#CLIENT_CIPHER_SUITE_RSA_WITH_AES_256_GCM_SHA384}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#CLIENT_CIPHER_SUITE_RSA_WITH_AES_256_CBC_SHA256}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#CLIENT_CIPHER_SUITE_RSA_WITH_AES_256_CBC_SHA}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#CLIENT_CIPHER_SUITE_RSA_WITH_AES_128_CBC_SHA}</li>
     * </ul> Client's list of cipher suites. Required if CryptoEnforcement is ENFORCE.
     * e.g. TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256.
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getClientCipherSuite() {
        return this.clientCipherSuite;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#CLIENT_CIPHER_SUITE_ECDHE_RSA_WITH_AES_128_GCM_SHA256}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#CLIENT_CIPHER_SUITE_ECDHE_RSA_WITH_AES_256_GCM_SHA384}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#CLIENT_CIPHER_SUITE_ECDHE_RSA_WITH_AES_128_CBC_SHA}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#CLIENT_CIPHER_SUITE_ECDHE_RSA_WITH_AES_256_CBC_SHA}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#CLIENT_CIPHER_SUITE_ECDHE_RSA_WITH_AES_128_CBC_SHA256}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#CLIENT_CIPHER_SUITE_ECDHE_RSA_WITH_AES_256_CBC_SHA384}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#CLIENT_CIPHER_SUITE_RSA_WITH_AES_128_GCM_SHA256}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#CLIENT_CIPHER_SUITE_RSA_WITH_AES_128_CBC_SHA256}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#CLIENT_CIPHER_SUITE_RSA_WITH_AES_256_GCM_SHA384}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#CLIENT_CIPHER_SUITE_RSA_WITH_AES_256_CBC_SHA256}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#CLIENT_CIPHER_SUITE_RSA_WITH_AES_256_CBC_SHA}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#CLIENT_CIPHER_SUITE_RSA_WITH_AES_128_CBC_SHA}</li>
     * </ul> Client's list of cipher suites. Required if CryptoEnforcement is ENFORCE.
     * e.g. TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256.
     *
     * @param clientCipherSuite New value for the property.
     */
    public void setClientCipherSuite(java.util.List<java.lang.String> clientCipherSuite) {
        this.clientCipherSuite = clientCipherSuite;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#CLIENT_MAX_TLS_VERSION_2}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#CLIENT_MAX_TLS_VERSION_1}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#CLIENT_MAX_TLS_VERSION_0}</li>
     * </ul> Client's maximum TLS version to enforce. Required if CryptoEnforcement is
     * ENFORCE. Supported TLS versions are TLS1.1 and TLS1.2.
     *
     * @return The current value of the property.
     */
    public java.lang.String getClientMaxTlsVersion() {
        return this.clientMaxTlsVersion;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#CLIENT_MAX_TLS_VERSION_2}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#CLIENT_MAX_TLS_VERSION_1}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#CLIENT_MAX_TLS_VERSION_0}</li>
     * </ul> Client's maximum TLS version to enforce. Required if CryptoEnforcement is
     * ENFORCE. Supported TLS versions are TLS1.1 and TLS1.2.
     *
     * @param clientMaxTlsVersion New value for the property.
     */
    public void setClientMaxTlsVersion(java.lang.String clientMaxTlsVersion) {
        this.clientMaxTlsVersion = clientMaxTlsVersion;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#CLIENT_MIN_TLS_VERSION_2}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#CLIENT_MIN_TLS_VERSION_1}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#CLIENT_MIN_TLS_VERSION_0}</li>
     * </ul> Client's minimum TLS version to enforce. Required if CryptoEnforcement is
     * ENFORCE. Supported TLS versions are TLS1.1 and TLS1.2.
     *
     * @return The current value of the property.
     */
    public java.lang.String getClientMinTlsVersion() {
        return this.clientMinTlsVersion;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#CLIENT_MIN_TLS_VERSION_2}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#CLIENT_MIN_TLS_VERSION_1}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#CLIENT_MIN_TLS_VERSION_0}</li>
     * </ul> Client's minimum TLS version to enforce. Required if CryptoEnforcement is
     * ENFORCE. Supported TLS versions are TLS1.1 and TLS1.2.
     *
     * @param clientMinTlsVersion New value for the property.
     */
    public void setClientMinTlsVersion(java.lang.String clientMinTlsVersion) {
        this.clientMinTlsVersion = clientMinTlsVersion;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#CRYPTO_ENFORCEMENT_ENFORCE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#CRYPTO_ENFORCEMENT_TRANSPARENT}</li>
     * </ul> If enforced and if TLS protocol Client/Server Hello has none of the
     * permitted TLS versions or ciphers then the connection is immediately terminated.
     *
     * @return The current value of the property.
     */
    public java.lang.String getCryptoEnforcement() {
        return this.cryptoEnforcement;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#CRYPTO_ENFORCEMENT_ENFORCE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#CRYPTO_ENFORCEMENT_TRANSPARENT}</li>
     * </ul> If enforced and if TLS protocol Client/Server Hello has none of the
     * permitted TLS versions or ciphers then the connection is immediately terminated.
     *
     * @param cryptoEnforcement New value for the property.
     */
    public void setCryptoEnforcement(java.lang.String cryptoEnforcement) {
        this.cryptoEnforcement = cryptoEnforcement;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#DECRYPTION_FAIL_ACTION_BLOCK}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#DECRYPTION_FAIL_ACTION_BYPASS}</li>
     * </ul> Action to take when TLS handshake fails.
     *
     * @return The current value of the property.
     */
    public java.lang.String getDecryptionFailAction() {
        return this.decryptionFailAction;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#DECRYPTION_FAIL_ACTION_BLOCK}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#DECRYPTION_FAIL_ACTION_BYPASS}</li>
     * </ul> Action to take when TLS handshake fails.
     *
     * @param decryptionFailAction New value for the property.
     */
    public void setDecryptionFailAction(java.lang.String decryptionFailAction) {
        this.decryptionFailAction = decryptionFailAction;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#INVALID_CERT_ACTION_BLOCK}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#INVALID_CERT_ACTION_ALLOW}</li>
     * </ul> If presented invalid certificates take this action.
     *
     * @return The current value of the property.
     */
    public java.lang.String getInvalidCertAction() {
        return this.invalidCertAction;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#INVALID_CERT_ACTION_BLOCK}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#INVALID_CERT_ACTION_ALLOW}</li>
     * </ul> If presented invalid certificates take this action.
     *
     * @param invalidCertAction New value for the property.
     */
    public void setInvalidCertAction(java.lang.String invalidCertAction) {
        this.invalidCertAction = invalidCertAction;
    }

    /**
     * true - activate the ocsp must staple, false - deactivate it.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getOcspMustStaple() {
        return this.ocspMustStaple;
    }

    /**
     * true - activate the ocsp must staple, false - deactivate it.
     *
     * @param ocspMustStaple New value for the property.
     */
    public void setOcspMustStaple(java.lang.Boolean ocspMustStaple) {
        this.ocspMustStaple = ocspMustStaple;
    }

    /**
     * Proxy trusted ca cert and key used to issue valid ca certificate. This is the
     * subordinate CA cert (referred to as Proxy CA) by the Enterprise Issuing CA.
     *
     * @return The current value of the property.
     */
    public java.lang.String getProxyTrustedCaCert() {
        return this.proxyTrustedCaCert;
    }

    /**
     * Proxy trusted ca cert and key used to issue valid ca certificate. This is the
     * subordinate CA cert (referred to as Proxy CA) by the Enterprise Issuing CA.
     *
     * @param proxyTrustedCaCert New value for the property.
     */
    public void setProxyTrustedCaCert(java.lang.String proxyTrustedCaCert) {
        this.proxyTrustedCaCert = proxyTrustedCaCert;
    }

    /**
     * Proxy untrusted ca cert and key used to issue invalid ca certificate
     *
     * @return The current value of the property.
     */
    public java.lang.String getProxyUntrustedCaCert() {
        return this.proxyUntrustedCaCert;
    }

    /**
     * Proxy untrusted ca cert and key used to issue invalid ca certificate
     *
     * @param proxyUntrustedCaCert New value for the property.
     */
    public void setProxyUntrustedCaCert(java.lang.String proxyUntrustedCaCert) {
        this.proxyUntrustedCaCert = proxyUntrustedCaCert;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#SERVER_CIPHER_SUITE_ECDHE_RSA_WITH_AES_128_GCM_SHA256}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#SERVER_CIPHER_SUITE_ECDHE_RSA_WITH_AES_256_GCM_SHA384}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#SERVER_CIPHER_SUITE_ECDHE_RSA_WITH_AES_128_CBC_SHA}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#SERVER_CIPHER_SUITE_ECDHE_RSA_WITH_AES_256_CBC_SHA}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#SERVER_CIPHER_SUITE_ECDHE_RSA_WITH_AES_128_CBC_SHA256}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#SERVER_CIPHER_SUITE_ECDHE_RSA_WITH_AES_256_CBC_SHA384}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#SERVER_CIPHER_SUITE_RSA_WITH_AES_128_GCM_SHA256}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#SERVER_CIPHER_SUITE_RSA_WITH_AES_128_CBC_SHA256}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#SERVER_CIPHER_SUITE_RSA_WITH_AES_256_GCM_SHA384}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#SERVER_CIPHER_SUITE_RSA_WITH_AES_256_CBC_SHA256}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#SERVER_CIPHER_SUITE_RSA_WITH_AES_256_CBC_SHA}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#SERVER_CIPHER_SUITE_RSA_WITH_AES_128_CBC_SHA}</li>
     * </ul> Server's list of cipher suites. Required if CryptoEnforcement is ENFORCE.
     * e.g. TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256.
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getServerCipherSuite() {
        return this.serverCipherSuite;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#SERVER_CIPHER_SUITE_ECDHE_RSA_WITH_AES_128_GCM_SHA256}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#SERVER_CIPHER_SUITE_ECDHE_RSA_WITH_AES_256_GCM_SHA384}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#SERVER_CIPHER_SUITE_ECDHE_RSA_WITH_AES_128_CBC_SHA}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#SERVER_CIPHER_SUITE_ECDHE_RSA_WITH_AES_256_CBC_SHA}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#SERVER_CIPHER_SUITE_ECDHE_RSA_WITH_AES_128_CBC_SHA256}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#SERVER_CIPHER_SUITE_ECDHE_RSA_WITH_AES_256_CBC_SHA384}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#SERVER_CIPHER_SUITE_RSA_WITH_AES_128_GCM_SHA256}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#SERVER_CIPHER_SUITE_RSA_WITH_AES_128_CBC_SHA256}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#SERVER_CIPHER_SUITE_RSA_WITH_AES_256_GCM_SHA384}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#SERVER_CIPHER_SUITE_RSA_WITH_AES_256_CBC_SHA256}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#SERVER_CIPHER_SUITE_RSA_WITH_AES_256_CBC_SHA}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#SERVER_CIPHER_SUITE_RSA_WITH_AES_128_CBC_SHA}</li>
     * </ul> Server's list of cipher suites. Required if CryptoEnforcement is ENFORCE.
     * e.g. TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256.
     *
     * @param serverCipherSuite New value for the property.
     */
    public void setServerCipherSuite(java.util.List<java.lang.String> serverCipherSuite) {
        this.serverCipherSuite = serverCipherSuite;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#SERVER_MAX_TLS_VERSION_2}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#SERVER_MAX_TLS_VERSION_1}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#SERVER_MAX_TLS_VERSION_0}</li>
     * </ul> Server's maximum TLS version to enforce. Required if CryptoEnforcement is
     * ENFORCE. Supported versions are TLS1.1 and TLS1.2.
     *
     * @return The current value of the property.
     */
    public java.lang.String getServerMaxTlsVersion() {
        return this.serverMaxTlsVersion;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#SERVER_MAX_TLS_VERSION_2}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#SERVER_MAX_TLS_VERSION_1}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#SERVER_MAX_TLS_VERSION_0}</li>
     * </ul> Server's maximum TLS version to enforce. Required if CryptoEnforcement is
     * ENFORCE. Supported versions are TLS1.1 and TLS1.2.
     *
     * @param serverMaxTlsVersion New value for the property.
     */
    public void setServerMaxTlsVersion(java.lang.String serverMaxTlsVersion) {
        this.serverMaxTlsVersion = serverMaxTlsVersion;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#SERVER_MIN_TLS_VERSION_2}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#SERVER_MIN_TLS_VERSION_1}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#SERVER_MIN_TLS_VERSION_0}</li>
     * </ul> Server's minimum TLS version to enforce. Required if CryptoEnforcement is
     * ENFORCE. Supported versions are TLS1.1 and TLS1.2.
     *
     * @return The current value of the property.
     */
    public java.lang.String getServerMinTlsVersion() {
        return this.serverMinTlsVersion;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#SERVER_MIN_TLS_VERSION_2}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#SERVER_MIN_TLS_VERSION_1}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#SERVER_MIN_TLS_VERSION_0}</li>
     * </ul> Server's minimum TLS version to enforce. Required if CryptoEnforcement is
     * ENFORCE. Supported versions are TLS1.1 and TLS1.2.
     *
     * @param serverMinTlsVersion New value for the property.
     */
    public void setServerMinTlsVersion(java.lang.String serverMinTlsVersion) {
        this.serverMinTlsVersion = serverMinTlsVersion;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#TLS_CONFIG_SETTING_BALANCED}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#TLS_CONFIG_SETTING_HIGH_FIDELITY}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#TLS_CONFIG_SETTING_HIGH_SECURITY}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#TLS_CONFIG_SETTING_CUSTOM}</li>
     * </ul> Pre-defined config settings. Settings could be one of Balanced, High
     * Fidelity, High Security, Custom
     *
     * @return The current value of the property.
     */
    public java.lang.String getTlsConfigSetting() {
        return this.tlsConfigSetting;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#TLS_CONFIG_SETTING_BALANCED}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#TLS_CONFIG_SETTING_HIGH_FIDELITY}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#TLS_CONFIG_SETTING_HIGH_SECURITY}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#TLS_CONFIG_SETTING_CUSTOM}</li>
     * </ul> Pre-defined config settings. Settings could be one of Balanced, High
     * Fidelity, High Security, Custom
     *
     * @param tlsConfigSetting New value for the property.
     */
    public void setTlsConfigSetting(java.lang.String tlsConfigSetting) {
        this.tlsConfigSetting = tlsConfigSetting;
    }

    /**
     * The server will populate this field when returing the resource. Ignored on PUT
     * and POST.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx_policy.model.ResourceLink> getLinks() {
        return this.links;
    }

    /**
     * The server will populate this field when returing the resource. Ignored on PUT
     * and POST.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param links New value for the property.
     */
    public void setLinks(java.util.List<com.vmware.nsx_policy.model.ResourceLink> links) {
        this.links = links;
    }

    /**
     * Schema for this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getSchema() {
        return this.schema;
    }

    /**
     * Schema for this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param schema New value for the property.
     */
    public void setSchema(java.lang.String schema) {
        this.schema = schema;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx_policy.model.SelfResourceLink getSelf() {
        return this.self;
    }

    /**
     *
     *
     * @param self New value for the property.
     */
    public void setSelf(com.vmware.nsx_policy.model.SelfResourceLink self) {
        this.self = self;
    }

    /**
     * The _revision property describes the current revision of the resource. To
     * prevent clients from overwriting each other's changes, PUT operations must
     * include the current _revision of the resource, which clients should obtain by
     * issuing a GET operation. If the _revision provided in a PUT request is missing
     * or stale, the operation will be rejected. format: int32
     *
     * @return The current value of the property.
     */
    public java.lang.Long getRevision() {
        return this.revision;
    }

    /**
     * The _revision property describes the current revision of the resource. To
     * prevent clients from overwriting each other's changes, PUT operations must
     * include the current _revision of the resource, which clients should obtain by
     * issuing a GET operation. If the _revision provided in a PUT request is missing
     * or stale, the operation will be rejected. format: int32
     *
     * @param revision New value for the property.
     */
    public void setRevision(java.lang.Long revision) {
        this.revision = revision;
    }

    /**
     * Timestamp of resource creation format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getCreateTime() {
        return this.createTime;
    }

    /**
     * Timestamp of resource creation format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param createTime New value for the property.
     */
    public void setCreateTime(java.lang.Long createTime) {
        this.createTime = createTime;
    }

    /**
     * ID of the user who created this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getCreateUser() {
        return this.createUser;
    }

    /**
     * ID of the user who created this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param createUser New value for the property.
     */
    public void setCreateUser(java.lang.String createUser) {
        this.createUser = createUser;
    }

    /**
     * Timestamp of last modification format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    /**
     * Timestamp of last modification format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param lastModifiedTime New value for the property.
     */
    public void setLastModifiedTime(java.lang.Long lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    /**
     * ID of the user who last modified this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getLastModifiedUser() {
        return this.lastModifiedUser;
    }

    /**
     * ID of the user who last modified this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param lastModifiedUser New value for the property.
     */
    public void setLastModifiedUser(java.lang.String lastModifiedUser) {
        this.lastModifiedUser = lastModifiedUser;
    }

    /**
     * Protection status is one of the following: PROTECTED - the client who retrieved
     * the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved
     * the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved
     * the entity is a super user and can modify it, but only when providing the
     * request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
     * be determined for this entity.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getProtection() {
        return this.protection;
    }

    /**
     * Protection status is one of the following: PROTECTED - the client who retrieved
     * the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved
     * the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved
     * the entity is a super user and can modify it, but only when providing the
     * request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
     * be determined for this entity.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param protection New value for the property.
     */
    public void setProtection(java.lang.String protection) {
        this.protection = protection;
    }

    /**
     * Indicates system owned resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getSystemOwned() {
        return this.systemOwned;
    }

    /**
     * Indicates system owned resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param systemOwned New value for the property.
     */
    public void setSystemOwned(java.lang.Boolean systemOwned) {
        this.systemOwned = systemOwned;
    }

    /**
     * Description of this resource
     *
     * @return The current value of the property.
     */
    public java.lang.String getDescription() {
        return this.description;
    }

    /**
     * Description of this resource
     *
     * @param description New value for the property.
     */
    public void setDescription(java.lang.String description) {
        this.description = description;
    }

    /**
     * Defaults to ID if not set
     *
     * @return The current value of the property.
     */
    public java.lang.String getDisplayName() {
        return this.displayName;
    }

    /**
     * Defaults to ID if not set
     *
     * @param displayName New value for the property.
     */
    public void setDisplayName(java.lang.String displayName) {
        this.displayName = displayName;
    }

    /**
     * Unique identifier of this resource
     *
     * @return The current value of the property.
     */
    public java.lang.String getId() {
        return this.id;
    }

    /**
     * Unique identifier of this resource
     *
     * @param id New value for the property.
     */
    public void setId(java.lang.String id) {
        this.id = id;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.TlsProfile#RESOURCE_TYPE_TLSINSPECTIONBYPASSPROFILE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TlsProfile#RESOURCE_TYPE_TLSINSPECTIONEXTERNALPROFILE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TlsProfile#RESOURCE_TYPE_TLSINSPECTIONINTERNALPROFILE}</li>
     * </ul> Resource type to use as profile type
     * The value of this property is automatically populated to {@code "TlsInspectionExternalProfile"}.
     *
     * @return The current value of the property.
     */
    public java.lang.String getResourceType() {
        return this.resourceType;
    }

    /**
     * Opaque identifiers meaningful to the API user
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx_policy.model.Tag> getTags() {
        return this.tags;
    }

    /**
     * Opaque identifiers meaningful to the API user
     *
     * @param tags New value for the property.
     */
    public void setTags(java.util.List<com.vmware.nsx_policy.model.Tag> tags) {
        this.tags = tags;
    }

    /**
     * This is a UUID generated by the system for knowing which site owns an object.
     * This is used in NSX+.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getOriginSiteId() {
        return this.originSiteId;
    }

    /**
     * This is a UUID generated by the system for knowing which site owns an object.
     * This is used in NSX+.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param originSiteId New value for the property.
     */
    public void setOriginSiteId(java.lang.String originSiteId) {
        this.originSiteId = originSiteId;
    }

    /**
     * This is a UUID generated by the system for knowing who owns this object. This is
     * used in NSX+.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getOwnerId() {
        return this.ownerId;
    }

    /**
     * This is a UUID generated by the system for knowing who owns this object. This is
     * used in NSX+.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param ownerId New value for the property.
     */
    public void setOwnerId(java.lang.String ownerId) {
        this.ownerId = ownerId;
    }

    /**
     * Path of its parent
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getParentPath() {
        return this.parentPath;
    }

    /**
     * Path of its parent
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param parentPath New value for the property.
     */
    public void setParentPath(java.lang.String parentPath) {
        this.parentPath = parentPath;
    }

    /**
     * Absolute path of this object
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getPath() {
        return this.path;
    }

    /**
     * Absolute path of this object
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param path New value for the property.
     */
    public void setPath(java.lang.String path) {
        this.path = path;
    }

    /**
     * This is a UUID generated by the system for realizing the entity object. In most
     * cases this should be same as 'unique_id' of the entity. However, in some cases
     * this can be different because of entities have migrated their unique identifier
     * to NSX Policy intent objects later in the timeline and did not use unique_id for
     * realization. Realization id is helpful for users to debug data path to correlate
     * the configuration with corresponding intent.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getRealizationId() {
        return this.realizationId;
    }

    /**
     * This is a UUID generated by the system for realizing the entity object. In most
     * cases this should be same as 'unique_id' of the entity. However, in some cases
     * this can be different because of entities have migrated their unique identifier
     * to NSX Policy intent objects later in the timeline and did not use unique_id for
     * realization. Realization id is helpful for users to debug data path to correlate
     * the configuration with corresponding intent.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param realizationId New value for the property.
     */
    public void setRealizationId(java.lang.String realizationId) {
        this.realizationId = realizationId;
    }

    /**
     * Path relative from its parent
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getRelativePath() {
        return this.relativePath;
    }

    /**
     * Path relative from its parent
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param relativePath New value for the property.
     */
    public void setRelativePath(java.lang.String relativePath) {
        this.relativePath = relativePath;
    }

    /**
     * This is the path of the object on the local managers when queried on the NSX+
     * service, and path of the object on NSX+ service when queried from the local
     * managers.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getRemotePath() {
        return this.remotePath;
    }

    /**
     * This is the path of the object on the local managers when queried on the NSX+
     * service, and path of the object on NSX+ service when queried from the local
     * managers.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param remotePath New value for the property.
     */
    public void setRemotePath(java.lang.String remotePath) {
        this.remotePath = remotePath;
    }

    /**
     * This is a UUID generated by the GM/LM to uniquely identify entities in a
     * federated environment. For entities that are stretched across multiple sites,
     * the same ID will be used on all the stretched sites.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getUniqueId() {
        return this.uniqueId;
    }

    /**
     * This is a UUID generated by the GM/LM to uniquely identify entities in a
     * federated environment. For entities that are stretched across multiple sites,
     * the same ID will be used on all the stretched sites.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param uniqueId New value for the property.
     */
    public void setUniqueId(java.lang.String uniqueId) {
        this.uniqueId = uniqueId;
    }

    /**
     * Subtree for this type within policy tree containing nested elements. Note that
     * this type is applicable to be used in Hierarchical API only.
     *
     * @return The current value of the property.
     * When clients pass a value of this class as a parameter, the property must
     * contain all the properties defined in {@link
     * com.vmware.nsx_policy.model.ChildPolicyConfigResource}. When methods return a
     * value of this class as a return value, the property will contain all the
     * properties defined in {@link
     * com.vmware.nsx_policy.model.ChildPolicyConfigResource}.
     */
    public java.util.List<com.vmware.vapi.bindings.Structure> getChildren() {
        return this.children;
    }

    /**
     * Subtree for this type within policy tree containing nested elements. Note that
     * this type is applicable to be used in Hierarchical API only.
     *
     * @param children New value for the property.
     * When clients pass a value of this class as a parameter, the property must
     * contain all the properties defined in {@link
     * com.vmware.nsx_policy.model.ChildPolicyConfigResource}. When methods return a
     * value of this class as a return value, the property will contain all the
     * properties defined in {@link
     * com.vmware.nsx_policy.model.ChildPolicyConfigResource}.
     */
    public void setChildren(java.util.List<com.vmware.vapi.bindings.Structure> children) {
        this.children = children;
    }

    /**
     * Intent objects are not directly deleted from the system when a delete is invoked
     * on them. They are marked for deletion and only when all the realized entities
     * for that intent object gets deleted, the intent object is deleted. Objects that
     * are marked for deletion are not returned in GET call. One can use the search API
     * to get these objects.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getMarkedForDelete() {
        return this.markedForDelete;
    }

    /**
     * Intent objects are not directly deleted from the system when a delete is invoked
     * on them. They are marked for deletion and only when all the realized entities
     * for that intent object gets deleted, the intent object is deleted. Objects that
     * are marked for deletion are not returned in GET call. One can use the search API
     * to get these objects.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param markedForDelete New value for the property.
     */
    public void setMarkedForDelete(java.lang.Boolean markedForDelete) {
        this.markedForDelete = markedForDelete;
    }

    /**
     * Global intent objects cannot be modified by the user. However, certain global
     * intent objects can be overridden locally by use of this property. In such cases,
     * the overridden local values take precedence over the globally defined values for
     * the properties.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getOverridden() {
        return this.overridden;
    }

    /**
     * Global intent objects cannot be modified by the user. However, certain global
     * intent objects can be overridden locally by use of this property. In such cases,
     * the overridden local values take precedence over the globally defined values for
     * the properties.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param overridden New value for the property.
     */
    public void setOverridden(java.lang.Boolean overridden) {
        this.overridden = overridden;
    }

    /**
     * Used to indicate an TLS version or Cipher version pre-defined settings
     * mis-match.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getAttention() {
        return this.attention;
    }

    /**
     * Used to indicate an TLS version or Cipher version pre-defined settings
     * mis-match.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param attention New value for the property.
     */
    public void setAttention(java.lang.String attention) {
        this.attention = attention;
    }

    /**
     * Bypass profile - CRL is required if the \"invalid_certificate\" action is allow.
     * External profile - CRL is always required. Internal profile - CRL is required if
     * \"certificate_validation\" is turned on.
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getCrls() {
        return this.crls;
    }

    /**
     * Bypass profile - CRL is required if the \"invalid_certificate\" action is allow.
     * External profile - CRL is always required. Internal profile - CRL is required if
     * \"certificate_validation\" is turned on.
     *
     * @param crls New value for the property.
     */
    public void setCrls(java.util.List<java.lang.String> crls) {
        this.crls = crls;
    }

    /**
     * Timeout the connection when kept idle. Default is 90 minutes. format: int32
     *
     * @return The current value of the property.
     */
    public java.lang.Long getIdleConnectionTimeout() {
        return this.idleConnectionTimeout;
    }

    /**
     * Timeout the connection when kept idle. Default is 90 minutes. format: int32
     *
     * @param idleConnectionTimeout New value for the property.
     */
    public void setIdleConnectionTimeout(java.lang.Long idleConnectionTimeout) {
        this.idleConnectionTimeout = idleConnectionTimeout;
    }

    /**
     * Bypass profile - CA bundle is required if the \"invalid_certificate\" action is
     * allow. External profile - CA bundle is always required. Internal profile - CA
     * bundle is required if \"certificate_validation\" is turned on.
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getTrustedCaBundles() {
        return this.trustedCaBundles;
    }

    /**
     * Bypass profile - CA bundle is required if the \"invalid_certificate\" action is
     * allow. External profile - CA bundle is always required. Internal profile - CA
     * bundle is required if \"certificate_validation\" is turned on.
     *
     * @param trustedCaBundles New value for the property.
     */
    public void setTrustedCaBundles(java.util.List<java.lang.String> trustedCaBundles) {
        this.trustedCaBundles = trustedCaBundles;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.tlsInspectionExternalProfile;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("client_cipher_suite",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.clientCipherSuite, this._getType().getField("client_cipher_suite")));
        structValue.setField("client_max_tls_version",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.clientMaxTlsVersion, this._getType().getField("client_max_tls_version")));
        structValue.setField("client_min_tls_version",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.clientMinTlsVersion, this._getType().getField("client_min_tls_version")));
        structValue.setField("crypto_enforcement",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.cryptoEnforcement, this._getType().getField("crypto_enforcement")));
        structValue.setField("decryption_fail_action",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.decryptionFailAction, this._getType().getField("decryption_fail_action")));
        structValue.setField("invalid_cert_action",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.invalidCertAction, this._getType().getField("invalid_cert_action")));
        structValue.setField("ocsp_must_staple",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ocspMustStaple, this._getType().getField("ocsp_must_staple")));
        structValue.setField("proxy_trusted_ca_cert",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.proxyTrustedCaCert, this._getType().getField("proxy_trusted_ca_cert")));
        structValue.setField("proxy_untrusted_ca_cert",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.proxyUntrustedCaCert, this._getType().getField("proxy_untrusted_ca_cert")));
        structValue.setField("server_cipher_suite",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.serverCipherSuite, this._getType().getField("server_cipher_suite")));
        structValue.setField("server_max_tls_version",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.serverMaxTlsVersion, this._getType().getField("server_max_tls_version")));
        structValue.setField("server_min_tls_version",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.serverMinTlsVersion, this._getType().getField("server_min_tls_version")));
        structValue.setField("tls_config_setting",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.tlsConfigSetting, this._getType().getField("tls_config_setting")));
        structValue.setField("_links",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.links, this._getType().getField("_links")));
        structValue.setField("_schema",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.schema, this._getType().getField("_schema")));
        structValue.setField("_self",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.self, this._getType().getField("_self")));
        structValue.setField("_revision",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.revision, this._getType().getField("_revision")));
        structValue.setField("_create_time",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.createTime, this._getType().getField("_create_time")));
        structValue.setField("_create_user",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.createUser, this._getType().getField("_create_user")));
        structValue.setField("_last_modified_time",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.lastModifiedTime, this._getType().getField("_last_modified_time")));
        structValue.setField("_last_modified_user",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.lastModifiedUser, this._getType().getField("_last_modified_user")));
        structValue.setField("_protection",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.protection, this._getType().getField("_protection")));
        structValue.setField("_system_owned",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.systemOwned, this._getType().getField("_system_owned")));
        structValue.setField("description",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.description, this._getType().getField("description")));
        structValue.setField("display_name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.displayName, this._getType().getField("display_name")));
        structValue.setField("id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.id, this._getType().getField("id")));
        structValue.setField("resource_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.resourceType, this._getType().getField("resource_type")));
        structValue.setField("tags",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.tags, this._getType().getField("tags")));
        structValue.setField("origin_site_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.originSiteId, this._getType().getField("origin_site_id")));
        structValue.setField("owner_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ownerId, this._getType().getField("owner_id")));
        structValue.setField("parent_path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.parentPath, this._getType().getField("parent_path")));
        structValue.setField("path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.path, this._getType().getField("path")));
        structValue.setField("realization_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.realizationId, this._getType().getField("realization_id")));
        structValue.setField("relative_path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.relativePath, this._getType().getField("relative_path")));
        structValue.setField("remote_path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.remotePath, this._getType().getField("remote_path")));
        structValue.setField("unique_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.uniqueId, this._getType().getField("unique_id")));
        structValue.setField("children",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.children, this._getType().getField("children")));
        structValue.setField("marked_for_delete",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.markedForDelete, this._getType().getField("marked_for_delete")));
        structValue.setField("overridden",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.overridden, this._getType().getField("overridden")));
        structValue.setField("attention",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.attention, this._getType().getField("attention")));
        structValue.setField("crls",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.crls, this._getType().getField("crls")));
        structValue.setField("idle_connection_timeout",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.idleConnectionTimeout, this._getType().getField("idle_connection_timeout")));
        structValue.setField("trusted_ca_bundles",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.trustedCaBundles, this._getType().getField("trusted_ca_bundles")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.tlsInspectionExternalProfile;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.tlsInspectionExternalProfile.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static TlsInspectionExternalProfile _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new TlsInspectionExternalProfile(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static TlsInspectionExternalProfile _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new TlsInspectionExternalProfile(structValue);
    }

    /**
     * Builder class for {@link TlsInspectionExternalProfile}.
     */
    public static final class Builder {
        private java.util.List<java.lang.String> clientCipherSuite;
        private java.lang.String clientMaxTlsVersion;
        private java.lang.String clientMinTlsVersion;
        private java.lang.String cryptoEnforcement;
        private java.lang.String decryptionFailAction;
        private java.lang.String invalidCertAction;
        private java.lang.Boolean ocspMustStaple;
        private java.lang.String proxyTrustedCaCert;
        private java.lang.String proxyUntrustedCaCert;
        private java.util.List<java.lang.String> serverCipherSuite;
        private java.lang.String serverMaxTlsVersion;
        private java.lang.String serverMinTlsVersion;
        private java.lang.String tlsConfigSetting;
        private java.util.List<com.vmware.nsx_policy.model.ResourceLink> links;
        private java.lang.String schema;
        private com.vmware.nsx_policy.model.SelfResourceLink self;
        private java.lang.Long revision;
        private java.lang.Long createTime;
        private java.lang.String createUser;
        private java.lang.Long lastModifiedTime;
        private java.lang.String lastModifiedUser;
        private java.lang.String protection;
        private java.lang.Boolean systemOwned;
        private java.lang.String description;
        private java.lang.String displayName;
        private java.lang.String id;
        private java.util.List<com.vmware.nsx_policy.model.Tag> tags;
        private java.lang.String originSiteId;
        private java.lang.String ownerId;
        private java.lang.String parentPath;
        private java.lang.String path;
        private java.lang.String realizationId;
        private java.lang.String relativePath;
        private java.lang.String remotePath;
        private java.lang.String uniqueId;
        private java.util.List<com.vmware.vapi.bindings.Structure> children;
        private java.lang.Boolean markedForDelete;
        private java.lang.Boolean overridden;
        private java.lang.String attention;
        private java.util.List<java.lang.String> crls;
        private java.lang.Long idleConnectionTimeout;
        private java.util.List<java.lang.String> trustedCaBundles;

        /**
         * Constructor with parameters for the required properties of
         * {@link TlsInspectionExternalProfile}.
         */
        public Builder() {
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#CLIENT_CIPHER_SUITE_ECDHE_RSA_WITH_AES_128_GCM_SHA256}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#CLIENT_CIPHER_SUITE_ECDHE_RSA_WITH_AES_256_GCM_SHA384}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#CLIENT_CIPHER_SUITE_ECDHE_RSA_WITH_AES_128_CBC_SHA}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#CLIENT_CIPHER_SUITE_ECDHE_RSA_WITH_AES_256_CBC_SHA}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#CLIENT_CIPHER_SUITE_ECDHE_RSA_WITH_AES_128_CBC_SHA256}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#CLIENT_CIPHER_SUITE_ECDHE_RSA_WITH_AES_256_CBC_SHA384}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#CLIENT_CIPHER_SUITE_RSA_WITH_AES_128_GCM_SHA256}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#CLIENT_CIPHER_SUITE_RSA_WITH_AES_128_CBC_SHA256}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#CLIENT_CIPHER_SUITE_RSA_WITH_AES_256_GCM_SHA384}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#CLIENT_CIPHER_SUITE_RSA_WITH_AES_256_CBC_SHA256}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#CLIENT_CIPHER_SUITE_RSA_WITH_AES_256_CBC_SHA}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#CLIENT_CIPHER_SUITE_RSA_WITH_AES_128_CBC_SHA}</li>
         * </ul> Client's list of cipher suites. Required if CryptoEnforcement is ENFORCE.
         * e.g. TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256.
         *
         * @param clientCipherSuite New value for the property.
         */
        public Builder setClientCipherSuite(java.util.List<java.lang.String> clientCipherSuite) {
            this.clientCipherSuite = clientCipherSuite;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#CLIENT_MAX_TLS_VERSION_2}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#CLIENT_MAX_TLS_VERSION_1}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#CLIENT_MAX_TLS_VERSION_0}</li>
         * </ul> Client's maximum TLS version to enforce. Required if CryptoEnforcement is
         * ENFORCE. Supported TLS versions are TLS1.1 and TLS1.2.
         *
         * @param clientMaxTlsVersion New value for the property.
         */
        public Builder setClientMaxTlsVersion(java.lang.String clientMaxTlsVersion) {
            this.clientMaxTlsVersion = clientMaxTlsVersion;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#CLIENT_MIN_TLS_VERSION_2}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#CLIENT_MIN_TLS_VERSION_1}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#CLIENT_MIN_TLS_VERSION_0}</li>
         * </ul> Client's minimum TLS version to enforce. Required if CryptoEnforcement is
         * ENFORCE. Supported TLS versions are TLS1.1 and TLS1.2.
         *
         * @param clientMinTlsVersion New value for the property.
         */
        public Builder setClientMinTlsVersion(java.lang.String clientMinTlsVersion) {
            this.clientMinTlsVersion = clientMinTlsVersion;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#CRYPTO_ENFORCEMENT_ENFORCE}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#CRYPTO_ENFORCEMENT_TRANSPARENT}</li>
         * </ul> If enforced and if TLS protocol Client/Server Hello has none of the
         * permitted TLS versions or ciphers then the connection is immediately terminated.
         *
         * @param cryptoEnforcement New value for the property.
         */
        public Builder setCryptoEnforcement(java.lang.String cryptoEnforcement) {
            this.cryptoEnforcement = cryptoEnforcement;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#DECRYPTION_FAIL_ACTION_BLOCK}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#DECRYPTION_FAIL_ACTION_BYPASS}</li>
         * </ul> Action to take when TLS handshake fails.
         *
         * @param decryptionFailAction New value for the property.
         */
        public Builder setDecryptionFailAction(java.lang.String decryptionFailAction) {
            this.decryptionFailAction = decryptionFailAction;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#INVALID_CERT_ACTION_BLOCK}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#INVALID_CERT_ACTION_ALLOW}</li>
         * </ul> If presented invalid certificates take this action.
         *
         * @param invalidCertAction New value for the property.
         */
        public Builder setInvalidCertAction(java.lang.String invalidCertAction) {
            this.invalidCertAction = invalidCertAction;
            return this;
        }

        /**
         * true - activate the ocsp must staple, false - deactivate it.
         *
         * @param ocspMustStaple New value for the property.
         */
        public Builder setOcspMustStaple(java.lang.Boolean ocspMustStaple) {
            this.ocspMustStaple = ocspMustStaple;
            return this;
        }

        /**
         * Proxy trusted ca cert and key used to issue valid ca certificate. This is the
         * subordinate CA cert (referred to as Proxy CA) by the Enterprise Issuing CA.
         *
         * @param proxyTrustedCaCert New value for the property.
         */
        public Builder setProxyTrustedCaCert(java.lang.String proxyTrustedCaCert) {
            this.proxyTrustedCaCert = proxyTrustedCaCert;
            return this;
        }

        /**
         * Proxy untrusted ca cert and key used to issue invalid ca certificate
         *
         * @param proxyUntrustedCaCert New value for the property.
         */
        public Builder setProxyUntrustedCaCert(java.lang.String proxyUntrustedCaCert) {
            this.proxyUntrustedCaCert = proxyUntrustedCaCert;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#SERVER_CIPHER_SUITE_ECDHE_RSA_WITH_AES_128_GCM_SHA256}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#SERVER_CIPHER_SUITE_ECDHE_RSA_WITH_AES_256_GCM_SHA384}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#SERVER_CIPHER_SUITE_ECDHE_RSA_WITH_AES_128_CBC_SHA}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#SERVER_CIPHER_SUITE_ECDHE_RSA_WITH_AES_256_CBC_SHA}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#SERVER_CIPHER_SUITE_ECDHE_RSA_WITH_AES_128_CBC_SHA256}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#SERVER_CIPHER_SUITE_ECDHE_RSA_WITH_AES_256_CBC_SHA384}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#SERVER_CIPHER_SUITE_RSA_WITH_AES_128_GCM_SHA256}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#SERVER_CIPHER_SUITE_RSA_WITH_AES_128_CBC_SHA256}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#SERVER_CIPHER_SUITE_RSA_WITH_AES_256_GCM_SHA384}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#SERVER_CIPHER_SUITE_RSA_WITH_AES_256_CBC_SHA256}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#SERVER_CIPHER_SUITE_RSA_WITH_AES_256_CBC_SHA}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#SERVER_CIPHER_SUITE_RSA_WITH_AES_128_CBC_SHA}</li>
         * </ul> Server's list of cipher suites. Required if CryptoEnforcement is ENFORCE.
         * e.g. TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256.
         *
         * @param serverCipherSuite New value for the property.
         */
        public Builder setServerCipherSuite(java.util.List<java.lang.String> serverCipherSuite) {
            this.serverCipherSuite = serverCipherSuite;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#SERVER_MAX_TLS_VERSION_2}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#SERVER_MAX_TLS_VERSION_1}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#SERVER_MAX_TLS_VERSION_0}</li>
         * </ul> Server's maximum TLS version to enforce. Required if CryptoEnforcement is
         * ENFORCE. Supported versions are TLS1.1 and TLS1.2.
         *
         * @param serverMaxTlsVersion New value for the property.
         */
        public Builder setServerMaxTlsVersion(java.lang.String serverMaxTlsVersion) {
            this.serverMaxTlsVersion = serverMaxTlsVersion;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#SERVER_MIN_TLS_VERSION_2}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#SERVER_MIN_TLS_VERSION_1}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#SERVER_MIN_TLS_VERSION_0}</li>
         * </ul> Server's minimum TLS version to enforce. Required if CryptoEnforcement is
         * ENFORCE. Supported versions are TLS1.1 and TLS1.2.
         *
         * @param serverMinTlsVersion New value for the property.
         */
        public Builder setServerMinTlsVersion(java.lang.String serverMinTlsVersion) {
            this.serverMinTlsVersion = serverMinTlsVersion;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#TLS_CONFIG_SETTING_BALANCED}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#TLS_CONFIG_SETTING_HIGH_FIDELITY}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#TLS_CONFIG_SETTING_HIGH_SECURITY}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TlsInspectionExternalProfile#TLS_CONFIG_SETTING_CUSTOM}</li>
         * </ul> Pre-defined config settings. Settings could be one of Balanced, High
         * Fidelity, High Security, Custom
         *
         * @param tlsConfigSetting New value for the property.
         */
        public Builder setTlsConfigSetting(java.lang.String tlsConfigSetting) {
            this.tlsConfigSetting = tlsConfigSetting;
            return this;
        }

        /**
         * The server will populate this field when returing the resource. Ignored on PUT
         * and POST.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param links New value for the property.
         */
        public Builder setLinks(java.util.List<com.vmware.nsx_policy.model.ResourceLink> links) {
            this.links = links;
            return this;
        }

        /**
         * Schema for this resource
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param schema New value for the property.
         */
        public Builder setSchema(java.lang.String schema) {
            this.schema = schema;
            return this;
        }

        /**
         *
         *
         * @param self New value for the property.
         */
        public Builder setSelf(com.vmware.nsx_policy.model.SelfResourceLink self) {
            this.self = self;
            return this;
        }

        /**
         * The _revision property describes the current revision of the resource. To
         * prevent clients from overwriting each other's changes, PUT operations must
         * include the current _revision of the resource, which clients should obtain by
         * issuing a GET operation. If the _revision provided in a PUT request is missing
         * or stale, the operation will be rejected. format: int32
         *
         * @param revision New value for the property.
         */
        public Builder setRevision(java.lang.Long revision) {
            this.revision = revision;
            return this;
        }

        /**
         * Timestamp of resource creation format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param createTime New value for the property.
         */
        public Builder setCreateTime(java.lang.Long createTime) {
            this.createTime = createTime;
            return this;
        }

        /**
         * ID of the user who created this resource
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param createUser New value for the property.
         */
        public Builder setCreateUser(java.lang.String createUser) {
            this.createUser = createUser;
            return this;
        }

        /**
         * Timestamp of last modification format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param lastModifiedTime New value for the property.
         */
        public Builder setLastModifiedTime(java.lang.Long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        /**
         * ID of the user who last modified this resource
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param lastModifiedUser New value for the property.
         */
        public Builder setLastModifiedUser(java.lang.String lastModifiedUser) {
            this.lastModifiedUser = lastModifiedUser;
            return this;
        }

        /**
         * Protection status is one of the following: PROTECTED - the client who retrieved
         * the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved
         * the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved
         * the entity is a super user and can modify it, but only when providing the
         * request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
         * be determined for this entity.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param protection New value for the property.
         */
        public Builder setProtection(java.lang.String protection) {
            this.protection = protection;
            return this;
        }

        /**
         * Indicates system owned resource
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param systemOwned New value for the property.
         */
        public Builder setSystemOwned(java.lang.Boolean systemOwned) {
            this.systemOwned = systemOwned;
            return this;
        }

        /**
         * Description of this resource
         *
         * @param description New value for the property.
         */
        public Builder setDescription(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Defaults to ID if not set
         *
         * @param displayName New value for the property.
         */
        public Builder setDisplayName(java.lang.String displayName) {
            this.displayName = displayName;
            return this;
        }

        /**
         * Unique identifier of this resource
         *
         * @param id New value for the property.
         */
        public Builder setId(java.lang.String id) {
            this.id = id;
            return this;
        }

        /**
         * Opaque identifiers meaningful to the API user
         *
         * @param tags New value for the property.
         */
        public Builder setTags(java.util.List<com.vmware.nsx_policy.model.Tag> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * This is a UUID generated by the system for knowing which site owns an object.
         * This is used in NSX+.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param originSiteId New value for the property.
         */
        public Builder setOriginSiteId(java.lang.String originSiteId) {
            this.originSiteId = originSiteId;
            return this;
        }

        /**
         * This is a UUID generated by the system for knowing who owns this object. This is
         * used in NSX+.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param ownerId New value for the property.
         */
        public Builder setOwnerId(java.lang.String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        /**
         * Path of its parent
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param parentPath New value for the property.
         */
        public Builder setParentPath(java.lang.String parentPath) {
            this.parentPath = parentPath;
            return this;
        }

        /**
         * Absolute path of this object
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param path New value for the property.
         */
        public Builder setPath(java.lang.String path) {
            this.path = path;
            return this;
        }

        /**
         * This is a UUID generated by the system for realizing the entity object. In most
         * cases this should be same as 'unique_id' of the entity. However, in some cases
         * this can be different because of entities have migrated their unique identifier
         * to NSX Policy intent objects later in the timeline and did not use unique_id for
         * realization. Realization id is helpful for users to debug data path to correlate
         * the configuration with corresponding intent.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param realizationId New value for the property.
         */
        public Builder setRealizationId(java.lang.String realizationId) {
            this.realizationId = realizationId;
            return this;
        }

        /**
         * Path relative from its parent
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param relativePath New value for the property.
         */
        public Builder setRelativePath(java.lang.String relativePath) {
            this.relativePath = relativePath;
            return this;
        }

        /**
         * This is the path of the object on the local managers when queried on the NSX+
         * service, and path of the object on NSX+ service when queried from the local
         * managers.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param remotePath New value for the property.
         */
        public Builder setRemotePath(java.lang.String remotePath) {
            this.remotePath = remotePath;
            return this;
        }

        /**
         * This is a UUID generated by the GM/LM to uniquely identify entities in a
         * federated environment. For entities that are stretched across multiple sites,
         * the same ID will be used on all the stretched sites.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param uniqueId New value for the property.
         */
        public Builder setUniqueId(java.lang.String uniqueId) {
            this.uniqueId = uniqueId;
            return this;
        }

        /**
         * Subtree for this type within policy tree containing nested elements. Note that
         * this type is applicable to be used in Hierarchical API only.
         *
         * @param children New value for the property.
         * When clients pass a value of this class as a parameter, the property must
         * contain all the properties defined in {@link
         * com.vmware.nsx_policy.model.ChildPolicyConfigResource}. When methods return a
         * value of this class as a return value, the property will contain all the
         * properties defined in {@link
         * com.vmware.nsx_policy.model.ChildPolicyConfigResource}.
         */
        public Builder setChildren(java.util.List<com.vmware.vapi.bindings.Structure> children) {
            this.children = children;
            return this;
        }

        /**
         * Intent objects are not directly deleted from the system when a delete is invoked
         * on them. They are marked for deletion and only when all the realized entities
         * for that intent object gets deleted, the intent object is deleted. Objects that
         * are marked for deletion are not returned in GET call. One can use the search API
         * to get these objects.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param markedForDelete New value for the property.
         */
        public Builder setMarkedForDelete(java.lang.Boolean markedForDelete) {
            this.markedForDelete = markedForDelete;
            return this;
        }

        /**
         * Global intent objects cannot be modified by the user. However, certain global
         * intent objects can be overridden locally by use of this property. In such cases,
         * the overridden local values take precedence over the globally defined values for
         * the properties.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param overridden New value for the property.
         */
        public Builder setOverridden(java.lang.Boolean overridden) {
            this.overridden = overridden;
            return this;
        }

        /**
         * Used to indicate an TLS version or Cipher version pre-defined settings
         * mis-match.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param attention New value for the property.
         */
        public Builder setAttention(java.lang.String attention) {
            this.attention = attention;
            return this;
        }

        /**
         * Bypass profile - CRL is required if the \"invalid_certificate\" action is allow.
         * External profile - CRL is always required. Internal profile - CRL is required if
         * \"certificate_validation\" is turned on.
         *
         * @param crls New value for the property.
         */
        public Builder setCrls(java.util.List<java.lang.String> crls) {
            this.crls = crls;
            return this;
        }

        /**
         * Timeout the connection when kept idle. Default is 90 minutes. format: int32
         *
         * @param idleConnectionTimeout New value for the property.
         */
        public Builder setIdleConnectionTimeout(java.lang.Long idleConnectionTimeout) {
            this.idleConnectionTimeout = idleConnectionTimeout;
            return this;
        }

        /**
         * Bypass profile - CA bundle is required if the \"invalid_certificate\" action is
         * allow. External profile - CA bundle is always required. Internal profile - CA
         * bundle is required if \"certificate_validation\" is turned on.
         *
         * @param trustedCaBundles New value for the property.
         */
        public Builder setTrustedCaBundles(java.util.List<java.lang.String> trustedCaBundles) {
            this.trustedCaBundles = trustedCaBundles;
            return this;
        }

        public TlsInspectionExternalProfile build() {
            TlsInspectionExternalProfile result = new TlsInspectionExternalProfile();
            result.setClientCipherSuite(this.clientCipherSuite);
            result.setClientMaxTlsVersion(this.clientMaxTlsVersion);
            result.setClientMinTlsVersion(this.clientMinTlsVersion);
            result.setCryptoEnforcement(this.cryptoEnforcement);
            result.setDecryptionFailAction(this.decryptionFailAction);
            result.setInvalidCertAction(this.invalidCertAction);
            result.setOcspMustStaple(this.ocspMustStaple);
            result.setProxyTrustedCaCert(this.proxyTrustedCaCert);
            result.setProxyUntrustedCaCert(this.proxyUntrustedCaCert);
            result.setServerCipherSuite(this.serverCipherSuite);
            result.setServerMaxTlsVersion(this.serverMaxTlsVersion);
            result.setServerMinTlsVersion(this.serverMinTlsVersion);
            result.setTlsConfigSetting(this.tlsConfigSetting);
            result.setLinks(this.links);
            result.setSchema(this.schema);
            result.setSelf(this.self);
            result.setRevision(this.revision);
            result.setCreateTime(this.createTime);
            result.setCreateUser(this.createUser);
            result.setLastModifiedTime(this.lastModifiedTime);
            result.setLastModifiedUser(this.lastModifiedUser);
            result.setProtection(this.protection);
            result.setSystemOwned(this.systemOwned);
            result.setDescription(this.description);
            result.setDisplayName(this.displayName);
            result.setId(this.id);
            result.setTags(this.tags);
            result.setOriginSiteId(this.originSiteId);
            result.setOwnerId(this.ownerId);
            result.setParentPath(this.parentPath);
            result.setPath(this.path);
            result.setRealizationId(this.realizationId);
            result.setRelativePath(this.relativePath);
            result.setRemotePath(this.remotePath);
            result.setUniqueId(this.uniqueId);
            result.setChildren(this.children);
            result.setMarkedForDelete(this.markedForDelete);
            result.setOverridden(this.overridden);
            result.setAttention(this.attention);
            result.setCrls(this.crls);
            result.setIdleConnectionTimeout(this.idleConnectionTimeout);
            result.setTrustedCaBundles(this.trustedCaBundles);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("client_cipher_suite", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("client_cipher_suite",
                                                                                "clientCipherSuite",
                                                                                "getClientCipherSuite",
                                                                                "setClientCipherSuite");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("client_max_tls_version", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("client_max_tls_version",
                                                                                "clientMaxTlsVersion",
                                                                                "getClientMaxTlsVersion",
                                                                                "setClientMaxTlsVersion");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("client_min_tls_version", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("client_min_tls_version",
                                                                                "clientMinTlsVersion",
                                                                                "getClientMinTlsVersion",
                                                                                "setClientMinTlsVersion");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("crypto_enforcement", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("crypto_enforcement",
                                                                                "cryptoEnforcement",
                                                                                "getCryptoEnforcement",
                                                                                "setCryptoEnforcement");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("decryption_fail_action", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("decryption_fail_action",
                                                                                "decryptionFailAction",
                                                                                "getDecryptionFailAction",
                                                                                "setDecryptionFailAction");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("invalid_cert_action", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("invalid_cert_action",
                                                                                "invalidCertAction",
                                                                                "getInvalidCertAction",
                                                                                "setInvalidCertAction");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ocsp_must_staple", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ocsp_must_staple",
                                                                                "ocspMustStaple",
                                                                                "getOcspMustStaple",
                                                                                "setOcspMustStaple");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("proxy_trusted_ca_cert", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("proxy_trusted_ca_cert",
                                                                                "proxyTrustedCaCert",
                                                                                "getProxyTrustedCaCert",
                                                                                "setProxyTrustedCaCert");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("proxy_untrusted_ca_cert", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("proxy_untrusted_ca_cert",
                                                                                "proxyUntrustedCaCert",
                                                                                "getProxyUntrustedCaCert",
                                                                                "setProxyUntrustedCaCert");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("server_cipher_suite", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("server_cipher_suite",
                                                                                "serverCipherSuite",
                                                                                "getServerCipherSuite",
                                                                                "setServerCipherSuite");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("server_max_tls_version", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("server_max_tls_version",
                                                                                "serverMaxTlsVersion",
                                                                                "getServerMaxTlsVersion",
                                                                                "setServerMaxTlsVersion");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("server_min_tls_version", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("server_min_tls_version",
                                                                                "serverMinTlsVersion",
                                                                                "getServerMinTlsVersion",
                                                                                "setServerMinTlsVersion");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("tls_config_setting", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("tls_config_setting",
                                                                                "tlsConfigSetting",
                                                                                "getTlsConfigSetting",
                                                                                "setTlsConfigSetting");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_links", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.resourceLink; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_links",
                                                                                "links",
                                                                                "getLinks",
                                                                                "setLinks");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_schema", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_schema",
                                                                                "schema",
                                                                                "getSchema",
                                                                                "setSchema");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_self", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.selfResourceLink; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_self",
                                                                                "self",
                                                                                "getSelf",
                                                                                "setSelf");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_revision", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_revision",
                                                                                "revision",
                                                                                "getRevision",
                                                                                "setRevision");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_create_time", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_create_time",
                                                                                "createTime",
                                                                                "getCreateTime",
                                                                                "setCreateTime");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_create_user", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_create_user",
                                                                                "createUser",
                                                                                "getCreateUser",
                                                                                "setCreateUser");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_last_modified_time", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_last_modified_time",
                                                                                "lastModifiedTime",
                                                                                "getLastModifiedTime",
                                                                                "setLastModifiedTime");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_last_modified_user", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_last_modified_user",
                                                                                "lastModifiedUser",
                                                                                "getLastModifiedUser",
                                                                                "setLastModifiedUser");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_protection", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_protection",
                                                                                "protection",
                                                                                "getProtection",
                                                                                "setProtection");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_system_owned", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_system_owned",
                                                                                "systemOwned",
                                                                                "getSystemOwned",
                                                                                "setSystemOwned");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("description", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("description",
                                                                                "description",
                                                                                "getDescription",
                                                                                "setDescription");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("display_name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("display_name",
                                                                                "displayName",
                                                                                "getDisplayName",
                                                                                "setDisplayName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("id",
                                                                                "id",
                                                                                "getId",
                                                                                "setId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("resource_type", new com.vmware.vapi.bindings.type.StringType());
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("resource_type",
                                                                                "resourceType",
                                                                                "getResourceType",
                                                                                null);
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("tags", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.tag; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("tags",
                                                                                "tags",
                                                                                "getTags",
                                                                                "setTags");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("origin_site_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("origin_site_id",
                                                                                "originSiteId",
                                                                                "getOriginSiteId",
                                                                                "setOriginSiteId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("owner_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("owner_id",
                                                                                "ownerId",
                                                                                "getOwnerId",
                                                                                "setOwnerId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("parent_path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("parent_path",
                                                                                "parentPath",
                                                                                "getParentPath",
                                                                                "setParentPath");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("path",
                                                                                "path",
                                                                                "getPath",
                                                                                "setPath");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("realization_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("realization_id",
                                                                                "realizationId",
                                                                                "getRealizationId",
                                                                                "setRealizationId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("relative_path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("relative_path",
                                                                                "relativePath",
                                                                                "getRelativePath",
                                                                                "setRelativePath");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("remote_path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("remote_path",
                                                                                "remotePath",
                                                                                "getRemotePath",
                                                                                "setRemotePath");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("unique_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("unique_id",
                                                                                "uniqueId",
                                                                                "getUniqueId",
                                                                                "setUniqueId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("children", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.DynamicStructType(java.util.Arrays.<com.vmware.vapi.internal.data.ConstraintValidator>asList(new com.vmware.vapi.internal.bindings.HasFieldsOfValidator(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.childPolicyConfigResource; } }))))));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("children",
                                                                                "children",
                                                                                "getChildren",
                                                                                "setChildren");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("marked_for_delete", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("marked_for_delete",
                                                                                "markedForDelete",
                                                                                "getMarkedForDelete",
                                                                                "setMarkedForDelete");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("overridden", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("overridden",
                                                                                "overridden",
                                                                                "getOverridden",
                                                                                "setOverridden");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("attention", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("attention",
                                                                                "attention",
                                                                                "getAttention",
                                                                                "setAttention");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("crls", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("crls",
                                                                                "crls",
                                                                                "getCrls",
                                                                                "setCrls");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("idle_connection_timeout", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("idle_connection_timeout",
                                                                                "idleConnectionTimeout",
                                                                                "getIdleConnectionTimeout",
                                                                                "setIdleConnectionTimeout");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("trusted_ca_bundles", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("trusted_ca_bundles",
                                                                                "trustedCaBundles",
                                                                                "getTrustedCaBundles",
                                                                                "setTrustedCaBundles");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.tls_inspection_external_profile",
                                                            fields,
                                                            com.vmware.nsx_policy.model.TlsInspectionExternalProfile.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            "resource_type",
                                                            "TlsInspectionExternalProfile");
    }
}

