/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * Returns the certificate and thumbprint of a remote TLS listener, if the listener
 * is running and accepting requests. If the certificate cannot be retrieved, the
 * result property describes the problem.
 */
public final class TlsListenerCertificate implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String RESULT_SUCCESS = "SUCCESS";

    public static final java.lang.String RESULT_CONNECTION_TIMEOUT = "CONNECTION_TIMEOUT";

    public static final java.lang.String RESULT_NO_ROUTE_TO_HOST = "NO_ROUTE_TO_HOST";

    public static final java.lang.String RESULT_CONNECTION_REFUSED = "CONNECTION_REFUSED";

    private com.vmware.nsx_policy.model.X509Certificate certificate;

    private java.lang.String result;

    private java.lang.String thumbprint;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public TlsListenerCertificate() {
    }

    protected TlsListenerCertificate(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx_policy.model.X509Certificate getCertificate() {
        return this.certificate;
    }

    /**
     *
     *
     * @param certificate New value for the property.
     */
    public void setCertificate(com.vmware.nsx_policy.model.X509Certificate certificate) {
        this.certificate = certificate;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.TlsListenerCertificate#RESULT_SUCCESS}</li> <li>
     * {@link
     * com.vmware.nsx_policy.model.TlsListenerCertificate#RESULT_CONNECTION_TIMEOUT}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TlsListenerCertificate#RESULT_NO_ROUTE_TO_HOST}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TlsListenerCertificate#RESULT_CONNECTION_REFUSED}</li>
     * </ul> Result of get certificate operation.
     *
     * @return The current value of the property.
     */
    public java.lang.String getResult() {
        return this.result;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.TlsListenerCertificate#RESULT_SUCCESS}</li> <li>
     * {@link
     * com.vmware.nsx_policy.model.TlsListenerCertificate#RESULT_CONNECTION_TIMEOUT}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TlsListenerCertificate#RESULT_NO_ROUTE_TO_HOST}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TlsListenerCertificate#RESULT_CONNECTION_REFUSED}</li>
     * </ul> Result of get certificate operation.
     *
     * @param result New value for the property.
     */
    public void setResult(java.lang.String result) {
        this.result = result;
    }

    /**
     * The SHA-256 thumbprint of the TLS listener.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getThumbprint() {
        return this.thumbprint;
    }

    /**
     * The SHA-256 thumbprint of the TLS listener.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param thumbprint New value for the property.
     */
    public void setThumbprint(java.lang.String thumbprint) {
        this.thumbprint = thumbprint;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.tlsListenerCertificate;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("certificate",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.certificate, this._getType().getField("certificate")));
        structValue.setField("result",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.result, this._getType().getField("result")));
        structValue.setField("thumbprint",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.thumbprint, this._getType().getField("thumbprint")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.tlsListenerCertificate;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.tlsListenerCertificate.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static TlsListenerCertificate _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new TlsListenerCertificate(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static TlsListenerCertificate _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new TlsListenerCertificate(structValue);
    }

    /**
     * Builder class for {@link TlsListenerCertificate}.
     */
    public static final class Builder {
        private com.vmware.nsx_policy.model.X509Certificate certificate;
        private java.lang.String result;
        private java.lang.String thumbprint;

        /**
         * Constructor with parameters for the required properties of
         * {@link TlsListenerCertificate}.
         */
        public Builder() {
        }

        /**
         *
         *
         * @param certificate New value for the property.
         */
        public Builder setCertificate(com.vmware.nsx_policy.model.X509Certificate certificate) {
            this.certificate = certificate;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.TlsListenerCertificate#RESULT_SUCCESS}</li> <li>
         * {@link
         * com.vmware.nsx_policy.model.TlsListenerCertificate#RESULT_CONNECTION_TIMEOUT}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TlsListenerCertificate#RESULT_NO_ROUTE_TO_HOST}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TlsListenerCertificate#RESULT_CONNECTION_REFUSED}</li>
         * </ul> Result of get certificate operation.
         *
         * @param result New value for the property.
         */
        public Builder setResult(java.lang.String result) {
            this.result = result;
            return this;
        }

        /**
         * The SHA-256 thumbprint of the TLS listener.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param thumbprint New value for the property.
         */
        public Builder setThumbprint(java.lang.String thumbprint) {
            this.thumbprint = thumbprint;
            return this;
        }

        public TlsListenerCertificate build() {
            TlsListenerCertificate result = new TlsListenerCertificate();
            result.setCertificate(this.certificate);
            result.setResult(this.result);
            result.setThumbprint(this.thumbprint);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("certificate", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.x509Certificate; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("certificate",
                                                                                "certificate",
                                                                                "getCertificate",
                                                                                "setCertificate");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("result", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("result",
                                                                                "result",
                                                                                "getResult",
                                                                                "setResult");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("thumbprint", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("thumbprint",
                                                                                "thumbprint",
                                                                                "getThumbprint",
                                                                                "setThumbprint");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.tls_listener_certificate",
                                                            fields,
                                                            com.vmware.nsx_policy.model.TlsListenerCertificate.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

