/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * If Virtual Distributed Switch is used as a HostSwitch to configure TransportNode
 * or TransportNodeProfie, this mapping should be specified. You can either use
 * vds_uplink_name or vds_lag_name to associate with uplink_name from
 * UplinkHostSwitch profile.
 */
public final class VdsUplink implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.lang.String uplinkName;

    private java.lang.String vdsLagName;

    private java.lang.String vdsUplinkName;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public VdsUplink() {
    }

    protected VdsUplink(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * This name is from UplinkHostSwitch profile that is associated with the
     * HostSwitch specified in TransportNode or TransportNodeProfile configuration.
     * This name will be used as an alias to either VDS uplink or lag in other
     * configuration.
     *
     * @return The current value of the property.
     */
    public java.lang.String getUplinkName() {
        return this.uplinkName;
    }

    /**
     * This name is from UplinkHostSwitch profile that is associated with the
     * HostSwitch specified in TransportNode or TransportNodeProfile configuration.
     * This name will be used as an alias to either VDS uplink or lag in other
     * configuration.
     *
     * @param uplinkName New value for the property.
     */
    public void setUplinkName(java.lang.String uplinkName) {
        this.uplinkName = uplinkName;
    }

    /**
     * LAG name that is connected to Physical NIC on a host from vSphere.
     *
     * @return The current value of the property.
     */
    public java.lang.String getVdsLagName() {
        return this.vdsLagName;
    }

    /**
     * LAG name that is connected to Physical NIC on a host from vSphere.
     *
     * @param vdsLagName New value for the property.
     */
    public void setVdsLagName(java.lang.String vdsLagName) {
        this.vdsLagName = vdsLagName;
    }

    /**
     * Uplink name of VDS that is connected to Physical NIC on a host from vSphere.
     *
     * @return The current value of the property.
     */
    public java.lang.String getVdsUplinkName() {
        return this.vdsUplinkName;
    }

    /**
     * Uplink name of VDS that is connected to Physical NIC on a host from vSphere.
     *
     * @param vdsUplinkName New value for the property.
     */
    public void setVdsUplinkName(java.lang.String vdsUplinkName) {
        this.vdsUplinkName = vdsUplinkName;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.vdsUplink;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("uplink_name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.uplinkName, this._getType().getField("uplink_name")));
        structValue.setField("vds_lag_name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.vdsLagName, this._getType().getField("vds_lag_name")));
        structValue.setField("vds_uplink_name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.vdsUplinkName, this._getType().getField("vds_uplink_name")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.vdsUplink;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.vdsUplink.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static VdsUplink _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new VdsUplink(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static VdsUplink _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new VdsUplink(structValue);
    }

    /**
     * Builder class for {@link VdsUplink}.
     */
    public static final class Builder {
        private java.lang.String uplinkName;
        private java.lang.String vdsLagName;
        private java.lang.String vdsUplinkName;

        /**
         * Constructor with parameters for the required properties of
         * {@link VdsUplink}.
         */
        public Builder() {
        }

        /**
         * This name is from UplinkHostSwitch profile that is associated with the
         * HostSwitch specified in TransportNode or TransportNodeProfile configuration.
         * This name will be used as an alias to either VDS uplink or lag in other
         * configuration.
         *
         * @param uplinkName New value for the property.
         */
        public Builder setUplinkName(java.lang.String uplinkName) {
            this.uplinkName = uplinkName;
            return this;
        }

        /**
         * LAG name that is connected to Physical NIC on a host from vSphere.
         *
         * @param vdsLagName New value for the property.
         */
        public Builder setVdsLagName(java.lang.String vdsLagName) {
            this.vdsLagName = vdsLagName;
            return this;
        }

        /**
         * Uplink name of VDS that is connected to Physical NIC on a host from vSphere.
         *
         * @param vdsUplinkName New value for the property.
         */
        public Builder setVdsUplinkName(java.lang.String vdsUplinkName) {
            this.vdsUplinkName = vdsUplinkName;
            return this;
        }

        public VdsUplink build() {
            VdsUplink result = new VdsUplink();
            result.setUplinkName(this.uplinkName);
            result.setVdsLagName(this.vdsLagName);
            result.setVdsUplinkName(this.vdsUplinkName);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("uplink_name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("uplink_name",
                                                                                "uplinkName",
                                                                                "getUplinkName",
                                                                                "setUplinkName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("vds_lag_name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("vds_lag_name",
                                                                                "vdsLagName",
                                                                                "getVdsLagName",
                                                                                "setVdsLagName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("vds_uplink_name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("vds_uplink_name",
                                                                                "vdsUplinkName",
                                                                                "getVdsUplinkName",
                                                                                "setVdsUplinkName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.vds_uplink",
                                                            fields,
                                                            com.vmware.nsx_policy.model.VdsUplink.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

