/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx_policy.orgs.projects.vpcs.subnets.ip_pools.
 * Used by client-side stubs.
 */

package com.vmware.nsx_policy.orgs.projects.vpcs.subnets.ip_pools;

public interface IpAllocations extends com.vmware.vapi.bindings.Service, com.vmware.nsx_policy.orgs.projects.vpcs.subnets.ip_pools.IpAllocationsTypes {

    /**
     * Releases the IP that was allocated for this allocation request
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param orgId (required)
     * @param projectId (required)
     * @param vpcId (required)
     * @param subnetId (required)
     * @param ipPoolId (required)
     * @param ipAllocationId (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void delete(java.lang.String orgId, java.lang.String projectId, java.lang.String vpcId, java.lang.String subnetId, java.lang.String ipPoolId, java.lang.String ipAllocationId);

    /**
     * Releases the IP that was allocated for this allocation request
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param orgId (required)
     * @param projectId (required)
     * @param vpcId (required)
     * @param subnetId (required)
     * @param ipPoolId (required)
     * @param ipAllocationId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void delete(java.lang.String orgId, java.lang.String projectId, java.lang.String vpcId, java.lang.String subnetId, java.lang.String ipPoolId, java.lang.String ipAllocationId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Releases the IP that was allocated for this allocation request
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param orgId (required)
     * @param projectId (required)
     * @param vpcId (required)
     * @param subnetId (required)
     * @param ipPoolId (required)
     * @param ipAllocationId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void delete(java.lang.String orgId, java.lang.String projectId, java.lang.String vpcId, java.lang.String subnetId, java.lang.String ipPoolId, java.lang.String ipAllocationId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Releases the IP that was allocated for this allocation request
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param orgId (required)
     * @param projectId (required)
     * @param vpcId (required)
     * @param subnetId (required)
     * @param ipPoolId (required)
     * @param ipAllocationId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void delete(java.lang.String orgId, java.lang.String projectId, java.lang.String vpcId, java.lang.String subnetId, java.lang.String ipPoolId, java.lang.String ipAllocationId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Get detail information on VPC Subnet ip allocation by giving ID.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param orgId (required)
     * @param projectId (required)
     * @param vpcId (required)
     * @param subnetId (required)
     * @param ipPoolId (required)
     * @param ipAllocationId (required)
     * @return com.vmware.nsx_policy.model.IpAddressAllocation
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.IpAddressAllocation get(java.lang.String orgId, java.lang.String projectId, java.lang.String vpcId, java.lang.String subnetId, java.lang.String ipPoolId, java.lang.String ipAllocationId);

    /**
     * Get detail information on VPC Subnet ip allocation by giving ID.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param orgId (required)
     * @param projectId (required)
     * @param vpcId (required)
     * @param subnetId (required)
     * @param ipPoolId (required)
     * @param ipAllocationId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.IpAddressAllocation
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.IpAddressAllocation get(java.lang.String orgId, java.lang.String projectId, java.lang.String vpcId, java.lang.String subnetId, java.lang.String ipPoolId, java.lang.String ipAllocationId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Get detail information on VPC Subnet ip allocation by giving ID.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.IpAddressAllocation
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param orgId (required)
     * @param projectId (required)
     * @param vpcId (required)
     * @param subnetId (required)
     * @param ipPoolId (required)
     * @param ipAllocationId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void get(java.lang.String orgId, java.lang.String projectId, java.lang.String vpcId, java.lang.String subnetId, java.lang.String ipPoolId, java.lang.String ipAllocationId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.IpAddressAllocation> asyncCallback);

    /**
     * Get detail information on VPC Subnet ip allocation by giving ID.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.IpAddressAllocation
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param orgId (required)
     * @param projectId (required)
     * @param vpcId (required)
     * @param subnetId (required)
     * @param ipPoolId (required)
     * @param ipAllocationId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void get(java.lang.String orgId, java.lang.String projectId, java.lang.String vpcId, java.lang.String subnetId, java.lang.String ipPoolId, java.lang.String ipAllocationId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.IpAddressAllocation> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * List all the ip allocations for a VPC Subnet.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param orgId (required)
     * @param projectId (required)
     * @param vpcId (required)
     * @param subnetId (required)
     * @param ipPoolId (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includeMarkForDeleteObjects Include objects that are marked for deletion in results (optional, default to
     * false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @return com.vmware.nsx_policy.model.IpAddressAllocationListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.IpAddressAllocationListResult list(java.lang.String orgId, java.lang.String projectId, java.lang.String vpcId, java.lang.String subnetId, java.lang.String ipPoolId, java.lang.String cursor, java.lang.Boolean includeMarkForDeleteObjects, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy);

    /**
     * List all the ip allocations for a VPC Subnet.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param orgId (required)
     * @param projectId (required)
     * @param vpcId (required)
     * @param subnetId (required)
     * @param ipPoolId (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includeMarkForDeleteObjects Include objects that are marked for deletion in results (optional, default to
     * false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.IpAddressAllocationListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.IpAddressAllocationListResult list(java.lang.String orgId, java.lang.String projectId, java.lang.String vpcId, java.lang.String subnetId, java.lang.String ipPoolId, java.lang.String cursor, java.lang.Boolean includeMarkForDeleteObjects, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * List all the ip allocations for a VPC Subnet.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.IpAddressAllocationListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param orgId (required)
     * @param projectId (required)
     * @param vpcId (required)
     * @param subnetId (required)
     * @param ipPoolId (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includeMarkForDeleteObjects Include objects that are marked for deletion in results (optional, default to
     * false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void list(java.lang.String orgId, java.lang.String projectId, java.lang.String vpcId, java.lang.String subnetId, java.lang.String ipPoolId, java.lang.String cursor, java.lang.Boolean includeMarkForDeleteObjects, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.IpAddressAllocationListResult> asyncCallback);

    /**
     * List all the ip allocations for a VPC Subnet.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.IpAddressAllocationListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param orgId (required)
     * @param projectId (required)
     * @param vpcId (required)
     * @param subnetId (required)
     * @param ipPoolId (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includeMarkForDeleteObjects Include objects that are marked for deletion in results (optional, default to
     * false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void list(java.lang.String orgId, java.lang.String projectId, java.lang.String vpcId, java.lang.String subnetId, java.lang.String ipPoolId, java.lang.String cursor, java.lang.Boolean includeMarkForDeleteObjects, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.IpAddressAllocationListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Create a VPC Subnet ip-allocation if it does not exist based on the IDs, or
     * update existing ip-allocation
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param orgId (required)
     * @param projectId (required)
     * @param vpcId (required)
     * @param subnetId (required)
     * @param ipPoolId (required)
     * @param ipAllocationId (required)
     * @param ipAddressAllocation (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void patch(java.lang.String orgId, java.lang.String projectId, java.lang.String vpcId, java.lang.String subnetId, java.lang.String ipPoolId, java.lang.String ipAllocationId, com.vmware.nsx_policy.model.IpAddressAllocation ipAddressAllocation);

    /**
     * Create a VPC Subnet ip-allocation if it does not exist based on the IDs, or
     * update existing ip-allocation
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param orgId (required)
     * @param projectId (required)
     * @param vpcId (required)
     * @param subnetId (required)
     * @param ipPoolId (required)
     * @param ipAllocationId (required)
     * @param ipAddressAllocation (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void patch(java.lang.String orgId, java.lang.String projectId, java.lang.String vpcId, java.lang.String subnetId, java.lang.String ipPoolId, java.lang.String ipAllocationId, com.vmware.nsx_policy.model.IpAddressAllocation ipAddressAllocation, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Create a VPC Subnet ip-allocation if it does not exist based on the IDs, or
     * update existing ip-allocation
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param orgId (required)
     * @param projectId (required)
     * @param vpcId (required)
     * @param subnetId (required)
     * @param ipPoolId (required)
     * @param ipAllocationId (required)
     * @param ipAddressAllocation (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void patch(java.lang.String orgId, java.lang.String projectId, java.lang.String vpcId, java.lang.String subnetId, java.lang.String ipPoolId, java.lang.String ipAllocationId, com.vmware.nsx_policy.model.IpAddressAllocation ipAddressAllocation, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Create a VPC Subnet ip-allocation if it does not exist based on the IDs, or
     * update existing ip-allocation
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param orgId (required)
     * @param projectId (required)
     * @param vpcId (required)
     * @param subnetId (required)
     * @param ipPoolId (required)
     * @param ipAllocationId (required)
     * @param ipAddressAllocation (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void patch(java.lang.String orgId, java.lang.String projectId, java.lang.String vpcId, java.lang.String subnetId, java.lang.String ipPoolId, java.lang.String ipAllocationId, com.vmware.nsx_policy.model.IpAddressAllocation ipAddressAllocation, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Create a VPC Subnet ip allocation if it does not exist based on the IDs, or
     * update existing ip-allocation information by replacing the port object already
     * exists.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param orgId (required)
     * @param projectId (required)
     * @param vpcId (required)
     * @param subnetId (required)
     * @param ipPoolId (required)
     * @param ipAllocationId (required)
     * @param ipAddressAllocation (required)
     * @return com.vmware.nsx_policy.model.IpAddressAllocation
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.IpAddressAllocation update(java.lang.String orgId, java.lang.String projectId, java.lang.String vpcId, java.lang.String subnetId, java.lang.String ipPoolId, java.lang.String ipAllocationId, com.vmware.nsx_policy.model.IpAddressAllocation ipAddressAllocation);

    /**
     * Create a VPC Subnet ip allocation if it does not exist based on the IDs, or
     * update existing ip-allocation information by replacing the port object already
     * exists.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param orgId (required)
     * @param projectId (required)
     * @param vpcId (required)
     * @param subnetId (required)
     * @param ipPoolId (required)
     * @param ipAllocationId (required)
     * @param ipAddressAllocation (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.IpAddressAllocation
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.IpAddressAllocation update(java.lang.String orgId, java.lang.String projectId, java.lang.String vpcId, java.lang.String subnetId, java.lang.String ipPoolId, java.lang.String ipAllocationId, com.vmware.nsx_policy.model.IpAddressAllocation ipAddressAllocation, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Create a VPC Subnet ip allocation if it does not exist based on the IDs, or
     * update existing ip-allocation information by replacing the port object already
     * exists.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.IpAddressAllocation
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param orgId (required)
     * @param projectId (required)
     * @param vpcId (required)
     * @param subnetId (required)
     * @param ipPoolId (required)
     * @param ipAllocationId (required)
     * @param ipAddressAllocation (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void update(java.lang.String orgId, java.lang.String projectId, java.lang.String vpcId, java.lang.String subnetId, java.lang.String ipPoolId, java.lang.String ipAllocationId, com.vmware.nsx_policy.model.IpAddressAllocation ipAddressAllocation, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.IpAddressAllocation> asyncCallback);

    /**
     * Create a VPC Subnet ip allocation if it does not exist based on the IDs, or
     * update existing ip-allocation information by replacing the port object already
     * exists.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.IpAddressAllocation
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param orgId (required)
     * @param projectId (required)
     * @param vpcId (required)
     * @param subnetId (required)
     * @param ipPoolId (required)
     * @param ipAllocationId (required)
     * @param ipAddressAllocation (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void update(java.lang.String orgId, java.lang.String projectId, java.lang.String vpcId, java.lang.String subnetId, java.lang.String ipPoolId, java.lang.String ipAllocationId, com.vmware.nsx_policy.model.IpAddressAllocation ipAddressAllocation, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.IpAddressAllocation> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
