/* **********************************************************
 * Copyright 2012 VMware, Inc.  All rights reserved.
 *      -- VMware Confidential
 * **********************************************************/

/*
 * ErrorValueFactory.java --
 *
 *      Factory for ErrorValue(s)
 */
package com.vmware.vapi;

import static com.vmware.vapi.MessageFactory.getMessage;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import com.vmware.vapi.data.ErrorValue;
import com.vmware.vapi.std.StandardDataFactory;

/**
 * Factory for constructing <code>ErrorValues</code>.
 */
// TODO[mcvetanov]: remove this one, it is replaced by new factory in
//       ...vapi.std package
public class ErrorValueFactory {

    public static ErrorValue buildErrorValue(String errorName,
                                             String msgId,
                                             String... msgArgs) {
        return StandardDataFactory.createErrorValueForMessages(errorName,
                Arrays.asList(getMessage(msgId, msgArgs)));
    }

    public static ErrorValue buildErrorValue(String errorName,
                                             Message... messages) {
        return StandardDataFactory.createErrorValueForMessages(errorName,
                Arrays.asList(messages));
    }

    public static ErrorValue buildErrorValue(String errorName,
                                             List<Message> messages) {
        return StandardDataFactory.createErrorValueForMessages(errorName,
                                                               messages);
    }

    public static ErrorValue buildErrorValue(String errorName,
                                             Message mainMessage,
                                             List<Message> details) {
        List<Message> errMessages =
                new ArrayList<Message>(details.size() + 1);
        errMessages.add(mainMessage);
        errMessages.addAll(details);
        return buildErrorValue(errorName, errMessages);
    }

}
