/* **********************************************************
 * Copyright 2013 VMware, Inc.  All rights reserved.
 *      -- VMware Confidential
 * **********************************************************/

package com.vmware.vapi.bindings;

import com.vmware.vapi.data.StructValue;

/**
 * Resolver that specifies the target class for "dynamic data" conversion.
 * That is the alternative of {@link DynamicStructure} when converting
 * {@link StructValue} for dynamic field to bindings type.
 */
public interface DynamicStructClassResolver {

    /**
     * Resolves the target <code>Class</code>.
     *
     * @param strValue the runtime struct value to be converted
     * @return the target type for the conversion or <code>null</code> if the
     *         type cannot be resolved
     */
    public Class<? extends StaticStructure> resolveTargetClass(
            StructValue strValue);
}
