/* **********************************************************
 * Copyright 2013 VMware, Inc.  All rights reserved.
 *      -- VMware Confidential
 * **********************************************************/

/*
 * DynamicStructure.java --
 *
 *      Interface representing a "dynamic structure".
 */
package com.vmware.vapi.bindings;


/**
 * Interface representing a "dynamic structure".
 */
public interface DynamicStructure extends Structure {

    /**
     * Gets a field value, represented as static bindings type.
     *
     * @param <T> static binding type for the field value
     * @param fieldName name of the field to get
     * @param targetClass <code>Class</code> for the result field value
     * @return the field value
     */
    public <T> T getField(String fieldName, Class<T> targetClass);

    /**
     * Sets a field value, represented as static bindings type.
     *
     * @param <T> static binding type for the field value
     * @param fieldName name of the field to set
     * @param newValue new value for <code>fieldName</code> field
     * @param valueClass <code>Class</code> of <code>newValue</code>
     */
    public <T> void setField(String fieldName, T newValue, Class<T> valueClass);
}
