/* **********************************************************
 * Copyright 2012-2013 VMware, Inc.  All rights reserved.
 *      -- VMware Confidential
 * **********************************************************/
package com.vmware.vapi.bindings;

import java.util.Set;

import com.vmware.vapi.bindings.client.RetryPolicy;
import com.vmware.vapi.bindings.type.ErrorType;
import com.vmware.vapi.core.ExecutionContext.SecurityContext;

/**
 * This class provides all needed configuration for creating a {@link Stub}
 */
public abstract class StubConfigurationBase {

    /**
     * @return the security context for the given stub instance. can be null.
     * @see SecurityContextFactory
     */
    public abstract SecurityContext getSecurityContext();

    /**
     * Returns <code>ErrorType</code>s to be used for resolving VMODL2 for
     * method invocations by the configured <code>Stub</code>.
     *
     * @return list of <code>ErrorType</code>s
     */
    public abstract Set<ErrorType> getErrorTypes();

    /**
     * @return retry policy for failed invocations; can be <code>null</code>
     */
    public RetryPolicy getRetryPolicy() {
        return null;
    }
}
