/* **********************************************************
 * Copyright (c) 2012, 2015, 2017, 2019 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/
package com.vmware.vapi.bindings.server.impl;

import com.vmware.vapi.bindings.server.InvocationContext;
import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vapi.internal.util.Validate;

/**
 * Implementation of {@link InvocationContext}. It is internal and must not be
 * used directly by user code.
 */
public final class InvocationContextImpl implements InvocationContext {

    private final ExecutionContext executionContext;
    private final boolean isTask;

    public InvocationContextImpl(ExecutionContext executionContext) {
        this(executionContext, false);
    }

    public InvocationContextImpl(ExecutionContext executionContext,
                                 boolean isTask) {
        Validate.notNull(executionContext);
        this.executionContext = executionContext;
        this.isTask = isTask;
    }

    @Override
    public ExecutionContext getExecutionContext() {
        return executionContext;
    }

    @Override
    public boolean isTask() {
        return isTask;
    }

}
