/* **********************************************************
 * Copyright 2012-2014, 2019 VMware, Inc.  All rights reserved.
 *      -- VMware Confidential
 * **********************************************************/
package com.vmware.vapi.bindings.type;

import com.vmware.vapi.internal.util.Validate;

/**
 * Description of an enumeration type.
 */
public class EnumType implements Type {

    private final Class<?> bindingClass;
    private final String name;

    /**
     * Creates an enumeration type.
     *
     * @param name the canonical name of the enum. must not be <code>null</code>
     * @param bindingClass Java language binding of the enumeration type. must
     *                     not be <code>null</code>
     * @throws NullPointerException if one of the parameters is null
     */
    public EnumType(String name, Class<?> bindingClass) {
        Validate.notNull(name);
        Validate.notNull(bindingClass);

        this.bindingClass = bindingClass;
        this.name = name;
    }

    /**
     * Returns a class which represents the Java language binding of this
     * enumeration.
     *
     * @return language binding class
     */
    public Class<?> getBindingClass() {
        return bindingClass;
    }

    /**
     * @return the canonical name of the enum. cannot be <code>null</code>
     */
    public String getName() {
        return name;
    }

    @Override
    public void accept(TypeVisitor visitor) {
        visitor.visit(this);
    }

}
