/* **********************************************************
 * Copyright 2012-2013 VMware, Inc.  All rights reserved.
 *      -- VMware Confidential
 * **********************************************************/
package com.vmware.vapi.bindings.type;

import java.util.Map;

/**
 * Description of an error type.
 */
public class ErrorType extends StructType implements Type {

    /**
     * Creates an error type.
     *
     * @param name  name of the error
     * @param fields  types of the error fields
     * @param bindingClass  Java language binding of the error type
     * @throws NullPointerException if one of the parameters is null
     */
    public ErrorType(String name,
                     Map<String, Type> fields,
                     Class<?> bindingClass,
                     Map<String, FieldNameDetails> fieldNameDetails) {
        super(name, fields, bindingClass, null, false, null, fieldNameDetails);
    }

    @Override
    public void accept(TypeVisitor visitor) {
        visitor.visit(this);
    }
}
