/* **********************************************************
 * Copyright 2012-2014, 2019 VMware, Inc.  All rights reserved.
 *      -- VMware Confidential
 * **********************************************************/

package com.vmware.vapi.bindings.type;

import com.vmware.vapi.internal.util.Validate;

public class MapType implements Type {

    private final Type keyType;
    private final Type valueType;

    /**
     * Map type.
     *
     * <p>For Map key one of the integer, ID, URI, string or enumeration type is
     * expected.
     *
     * @param keyType the key type for the map (required).
     * @param valueType the value type for the map (required).
     * @throws IllegalArgumentException if any of the arguments is <code>null</code>
     */
    public MapType(Type keyType, Type valueType) {
        Validate.notNull(keyType);
        Validate.notNull(valueType);
        this.keyType = keyType;
        this.valueType = valueType;
    }

    public Type getKeyType() {
        return keyType;
    }

    public Type getValueType() {
        return valueType;
    }

    @Override
    public void accept(TypeVisitor visitor) {
        visitor.visit(this);
    }
}