/* **********************************************************
 * Copyright (c) 2017 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

package com.vmware.vapi.client;

import java.io.Closeable;

import com.vmware.vapi.bindings.StubCreator;

/**
 * Represents a Client for an API.
 *
 * <p>Instances of implementing classes obtain and manage any resource needed
 * to connect to the API provider, exchange request/response pairs and perform
 * any other activities for consuming the remote API.
 *
 * <p>This is a {@link StubCreator} which is the mechanism to create remote
 * stubs for the API services.
 *
 * <p>Use the static factory methods from {@link ApiClients} to create
 * instances.
 *
 * <p>The {@code ApiClient} instance must be {@link #close()} when it and
 * the stubs it created are no longer needed. This will ensure that all
 * resources used by this instances are freed.
 */
public interface ApiClient extends StubCreator, Closeable {

}
