/* **********************************************************
 * Copyright (c) 2017 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

package com.vmware.vapi.client;

import com.vmware.vapi.internal.client.ApiClientImpl;
import com.vmware.vapi.internal.protocol.RestProtocol;

/**
 * This class contains static factory methods for creating
 * new {@link ApiClient} instances.
 */
public class ApiClients {
    /**
     * Creates {@code ApiClient} instance which can be used to consume REST
     * API.
     *
     * @param baseUrl the base URL of the REST API; must not be {@code null}
     * @return new {@code ApiClient} instance
     */
    public static ApiClient newRestClient(String baseUrl) {

        return new ApiClientImpl(baseUrl,
                                 RestProtocol.getInstance(),
                                 Configuration.newEmptyConfig());
    }

    /**
     * Creates {@code ApiClient} instance for the specified configuration, which
     * can be used to consume REST API.
     *
     * @param baseUrl the base URL of the REST API; must not be {@code null}
     * @param config configuration for the created client instance; must not
     *               be {@code null}
     * @return new {@code ApiClient} instance
     */
    public static ApiClient newRestClient(String baseUrl,
                                          Configuration config) {
        return new ApiClientImpl(baseUrl,
                                 RestProtocol.getInstance(),
                                 config);
    }
}
