/* **********************************************************
 * Copyright 2014 VMware, Inc.  All rights reserved.
 *      -- VMware Confidential
 * **********************************************************/

package com.vmware.vapi.client.exception;

/**
 * Signals that an exception has occurred in the vAPI client. This class is the
 * base of the client exception hierarchy. The clients may handle general
 * client exception by catching this class or a specific type of exception by
 * catching subclass of the exception.
 */
public class ClientException extends RuntimeException {

    private static final long serialVersionUID = 7364442005238834232L;

    /**
     * Constructs an exception with an empty message string.
     */
    public ClientException() {
    }

    /**
     * Constructs an exception with the specified message string.
     *
     * @param msg The message string.
     */
    public ClientException(String msg) {
        super(msg);
    }

    /**
     * Constructs an exception with the specified cause.
     *
     * @param cause The cause.
     */
    public ClientException(Throwable cause) {
        super(cause);
    }

    /**
     * Constructs an exception with the specified message and cause.
     *
     * @param msg The message string.
     * @param cause The cause.
     */
    public ClientException(String message, Throwable cause) {
        super(message, cause);
    }
}
