/* **********************************************************
 * Copyright 2014 VMware, Inc.  All rights reserved.
 *      -- VMware Confidential
 * **********************************************************/

package com.vmware.vapi.client.exception;

/**
 * Thrown in cases of server protocol errors related to the lower level
 * communication protocol errors (like HTTP protocol errors).
 * <p>
 * The exceptions translated to this one are:
 * <li> org.apache.http.MalformedChunkCodingException
 * <li> org.apache.http.HttpException
 * <li> org.apache.http.NoHttpResponseException
 * <li> org.apache.http.ParseException
 * <li> org.apache.http.client.ClientProtocolException
 */
public class TransportProtocolException extends ClientException {

    private static final long serialVersionUID = 2917317527811471735L;

    public TransportProtocolException() {
        super();
    }

    public TransportProtocolException(String message) {
        super(message);
    }

    public TransportProtocolException(String message, Throwable cause) {
        super(message, cause);
    }

    public TransportProtocolException(Throwable cause) {
        super(cause);
    }
}