/* **********************************************************
 * Copyright 2012-2013 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

/*
 * Configurator.java --
 *
 *      Creates vAPI runtime objects from a configuration.
 */

package com.vmware.vapi.config;

import java.util.List;

import com.vmware.vapi.core.ApiProvider;
import com.vmware.vapi.protocol.ProtocolHandler;

/**
 * Collection of the server-side runtime objects created from a configuration.
 */
public interface Configurator {

    /**
     * Returns the primary API provider described in the configuration.
     *
     * @return API provider
     */
    ApiProvider getApiProvider();

    /**
     * Returns a list of protocol handlers as described in the configuration.
     *
     * @return list of protocol handlers
     */
    List<ProtocolHandler> getProtocolHandlers();
}
