/* **********************************************************
 * Copyright 2011-2012 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

/*
 * BlobDefinition.java --
 *
 *      Type definition for vAPI Blob (binary) built-in type
 */

package com.vmware.vapi.data;

public class BlobDefinition extends DataDefinition {
    private static BlobDefinition instance = new BlobDefinition();

    private BlobDefinition() {
    }

    public static BlobDefinition getInstance() {
        return instance;
    }

    @Override
    public DataType getType() {
        return DataType.BLOB;
    }

    @Override
    public String toString() {
        return "BLOB";
    }

    @Override
    public void accept(DefinitionVisitor visitor) {
        visitor.visit(this);
    }
}
