/* **********************************************************
 * Copyright 2012 VMware, Inc.  All rights reserved.
 *      -- VMware Confidential
 * **********************************************************/

/*
 * ErrorValue.java --
 *
 *      Data value for vAPI errors
 */
package com.vmware.vapi.data;


/**
 * <code>DataValue</code> implementation for vAPI errors.
 */
public class ErrorValue extends StructValue {

    private static final long serialVersionUID = 1L;

    /**
     * Constructor.
     *
     * <p>Creates instance for given error name. The name is used as name
     * of the <code>StructValue</code> represented by the instance.
     *
     * @param name  the error name
     */
    public ErrorValue(String name) {
        super(name);
    }

    @Override
    public DataType getType() {
        return DataType.ERROR;
    }

    @Override
    public ErrorValue copy() {
        ErrorValue result = new ErrorValue(this.getName());
        for (String field : this.getFieldNames()) {
            result.setField(field, getField(field).copy());
        }
        return result;
    }
}
