/* **********************************************************
 * Copyright 2012-2013 VMware, Inc.  All rights reserved.
 *      -- VMware Confidential
 * **********************************************************/
package com.vmware.vapi.data;

public class IntegerValue implements DataValue {

    private static final long serialVersionUID = 1L;
    private final long value;

    public IntegerValue(long value) {
        this.value = value;
    }

    @Override
    public DataType getType() {
        return DataType.INTEGER;
    }

    public long getValue() {
        return this.value;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof IntegerValue) {
            IntegerValue intVal = (IntegerValue) o;
            return this.value == intVal.value;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Long.valueOf(value).hashCode();
    }

    @Override
    public String toString() {
        return Long.toString(value);
    }

    @Override
    public void accept(ValueVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public IntegerValue copy() {
        return this;
    }
}
