/* **********************************************************
 * Copyright 2011-2012 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

/*
 * OpaqueDefinition.java --
 *
 *      Type definition for vAPI opaque built-in type
 */

package com.vmware.vapi.data;

import static com.vmware.vapi.MessageFactory.getMessage;

import java.util.*;

import com.vmware.vapi.*;

public class OpaqueDefinition extends DataDefinition {
    private static OpaqueDefinition instance = new OpaqueDefinition();

    private OpaqueDefinition() {
    }

    public static OpaqueDefinition getInstance() {
        return instance;
    }

    public DataType getType() {
        return DataType.OPAQUE;
    }

    /**
     * Validates that the specified DataValue is an instance of this data
     * definition.
     *
     * <p>Only validates that supplied value is not <code>null</code>.
     */
    @Override
    public List<Message> validate(DataValue value) {
        List<Message> errors = new LinkedList<Message>();
        if (value != null) {
            // its opaque it can be anything
            return errors;
        }

        errors.add(getMessage("vapi.data.opaque.definition.null.value"));
        return errors;
    }

    @Override
    public String toString() {
        return "Opaque";
    }

    @Override
    public void accept(DefinitionVisitor visitor) {
        visitor.visit(this);
    }
}
