/* **********************************************************
 * Copyright (c) 2013, 2016 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/
package com.vmware.vapi.data;

public final class VoidValue implements DataValue {

    /**
     * Constant returned by the {@code toString} method of {@link VoidValue}.
     */
    public static final String STRING_REPRESENTATION = "<void>";

    private static final long serialVersionUID = 1L;
    private static final VoidValue instance = new VoidValue();

    private VoidValue() {
    }

    public static VoidValue getInstance() {
        return instance;
    }

    @Override
    public DataType getType() {
        return DataType.VOID;
    }

    @Override
    public String toString() {
        return STRING_REPRESENTATION;
    }

    @Override
    public void accept(ValueVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public VoidValue copy() {
        return instance;
    }

    /**
     * Preserve the single instance class invariant when creating instances via
     * <em>Java</em> deserialization.
     * @see java.io.Serializable
     *
     * @return the single instance of this class
     */
    private Object readResolve() {
        return instance;
    }
}
