/* **********************************************************
 * Copyright 2013-2014 VMware, Inc.  All rights reserved.
 *      -- VMware Confidential
 * **********************************************************/

/*
 * LogDiagnosticsUtil.java --
 *
 *      Utility for log diagnostic context
 */
package com.vmware.vapi.diagnostics;

import java.util.Collections;
import java.util.Map;
import java.util.Set;

import com.vmware.vapi.core.ExecutionContext;

/**
 * Utility for log diagnostic context.
 */
public class LogDiagnosticUtil {

    // TODO: = "operationID" ?!
    public static final String OPERATION_ID = "opId";

    private static final Set<String> DIAG_CTX_KEYS =
            Collections.singleton(OPERATION_ID);

    /**
     * Extracts log disgnostic context from <code>ExecutionContext</code>.
     *
     * <p>In particular looks for {@link #OPERATION_ID opId} key and its value in
     * <code>ctx</code>.
     *
     * @param ctx input execution context
     * @return <code>Map</code> representing the logging diagnostic context
     */
    public static Map<String, String> getDiagnosticContext(ExecutionContext ctx) {
        if (ctx == null || ctx.retrieveApplicationData() == null) {
            return Collections.emptyMap();
        }

        // only support opId today
        String opId = ctx.retrieveApplicationData().getProperty(OPERATION_ID);
        if (opId == null) {
            return Collections.emptyMap();
        }

        return Collections.singletonMap(OPERATION_ID, opId);
    }

    /**
     * Returns the diagnostic context keys used by vAPI infrastructure. Could
     * be used for fetching their values or
     * {@link LogDiagnosticsConfigurator#cleanUpContext(java.util.Collection) removing}
     * them from the context.
     *
     * @return the key names
     */
    public static Set<String> getDiagnosticKeys() {
        return DIAG_CTX_KEYS;
    }
}
