/* **********************************************************
 * Copyright 2013-2014 VMware, Inc.  All rights reserved.
 *      -- VMware Confidential
 * **********************************************************/

/*
 * LogDiagnosticsConfigurator.java --
 *
 *      Interface for configurators for logging dignostics context
 */
package com.vmware.vapi.diagnostics;

import java.util.Collection;
import java.util.Map;

/**
 * Interface for configurators for logging dignostics context. Concrete
 * subclasses can be used to configure context with additional information to
 * appear in logging traces.
 */
public interface LogDiagnosticsConfigurator {

    /**
     * Configure logging context for the current thread.
     *
     * @param diagCtx log diagnostics context
     */
    public void configureContext(Map<String, String> diagCtx);

    /**
     * Clean the logging context for the current thread.
     *
     * <p><b>WARNING:</b> this will clear the while underlying storage of the
     * context, e.g. the slf4j MDC. It is possible that other data is stored in
     * that storage, which is not supposed to be cleared. Use this method with
     * caution, the vAPI infrastructure will never invoke it.
     */
    public void cleanUpContext();

    /**
     * Cleans specified keys from the logging context. Removes the mappings for
     * these keys from the underlying context storage (e.g. slf4j MDC).
     *
     * @param keys the keys to be cleaned; must not be <code>null</code>
     */
    public void cleanUpContext(Collection<String> keys);

    /**
     * Retrieve the logging context for the current thread
     * ({@link Thread#currentThread()}).
     *
     * <p>The result can be used to transfer the logging context to another
     * thread, which continues the execution of the logical operation
     *
     * @return <code>Map</code> representing the log diagnostics context
     */
    public Map<String, String> getContext();
}
