/* **********************************************************
 * Copyright 2015 VMware, Inc.  All rights reserved.
 *      -- VMware Confidential
 * **********************************************************/
package com.vmware.vapi.dsig.json;

import java.util.HashMap;
import java.util.Map;

import com.vmware.vapi.core.ExecutionContext.SecurityContext;
import com.vmware.vapi.internal.security.SecurityContextConstants;
import com.vmware.vapi.protocol.RequestProcessor;
import com.vmware.vapi.security.StdSecuritySchemes;
import com.vmware.vapi.security.OAuthSecurityContext;

/**
 * {@link RequestProcessor} implementation for OAuth based authentication
 */
public final class JsonOAuthProcessor extends SecurityContextProcessor {

    @Override
    public boolean isSchemeSupported(String requestedScheme) {
        return requestedScheme.equalsIgnoreCase(StdSecuritySchemes.OAUTH);
    }

    @Override
    public Map<String, Object> getSecurityContextProperties(SecurityContext ctx) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put(SecurityContextConstants.SCHEME_ID_KEY,
                StdSecuritySchemes.OAUTH);
        props.put(OAuthSecurityContext.ACCESS_TOKEN,
                ctx.getProperty(OAuthSecurityContext.ACCESS_TOKEN));
        return props;
    }
}
