/* **********************************************************
 * Copyright 2012-2013 VMware, Inc.  All rights reserved.
 *      -- VMware Confidential
 * **********************************************************/
package com.vmware.vapi.dsig.json;

import java.util.HashMap;
import java.util.Map;

import com.vmware.vapi.core.ExecutionContext.SecurityContext;
import com.vmware.vapi.security.SessionSecurityContext;
import com.vmware.vapi.security.StdSecuritySchemes;

/**
 * Client side processor for session authentication
 */
public final class JsonSessionProcessor extends SecurityContextProcessor {

    @Override
    public boolean isSchemeSupported(String requestedScheme) {
        return requestedScheme.equalsIgnoreCase(StdSecuritySchemes.SESSION);
    }

    @Override
    public Map<String, Object> getSecurityContextProperties(SecurityContext ctx) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put(SCHEME_ID_KEY, StdSecuritySchemes.SESSION);
        props.put(SessionSecurityContext.SESSION_ID_KEY, ctx.getProperty(
                SessionSecurityContext.SESSION_ID_KEY));

        return props;
    }
}
